/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.reader;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineReaderManager;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineReaderWebServices;
import org.apache.hadoop.yarn.webapp.ForbiddenException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestTimelineReaderWebServicesBasicAcl {
    private TimelineReaderManager manager;
    private static String adminUser = "admin";
    private static UserGroupInformation adminUgi = UserGroupInformation.createRemoteUser((String)adminUser);
    private Configuration config;

    @Before
    public void setUp() throws Exception {
        this.config = new YarnConfiguration();
    }

    @After
    public void tearDown() throws Exception {
        if (this.manager != null) {
            this.manager.stop();
            this.manager = null;
        }
        this.config = null;
    }

    @Test
    public void testTimelineReaderManagerAclsWhenDisabled() throws Exception {
        this.config.setBoolean("yarn.acl.enable", false);
        this.config.set("yarn.admin.acl", adminUser);
        this.manager = new TimelineReaderManager(null);
        this.manager.init(this.config);
        this.manager.start();
        Assert.assertTrue((boolean)this.manager.checkAccess(null));
        Assert.assertFalse((boolean)TimelineReaderWebServices.isDisplayEntityPerUserFilterEnabled((Configuration)this.config));
    }

    @Test
    public void testTimelineReaderManagerAclsWhenEnabled() throws Exception {
        YarnConfiguration config = new YarnConfiguration();
        config.setBoolean("yarn.acl.enable", true);
        config.setBoolean("yarn.webapp.filter-entity-list-by-user", true);
        config.set("yarn.admin.acl", adminUser);
        this.manager = new TimelineReaderManager(null);
        this.manager.init((Configuration)config);
        this.manager.start();
        String user1 = "user1";
        String user2 = "user2";
        UserGroupInformation user1Ugi = UserGroupInformation.createRemoteUser((String)user1);
        UserGroupInformation user2Ugi = UserGroupInformation.createRemoteUser((String)user2);
        Assert.assertFalse((boolean)TimelineReaderWebServices.validateAuthUserWithEntityUser((TimelineReaderManager)this.manager, null, (String)user1));
        try {
            TimelineReaderWebServices.checkAccess((TimelineReaderManager)this.manager, null, (String)user1);
            Assert.fail((String)"user1Ugi is not allowed to view user1");
        }
        catch (ForbiddenException forbiddenException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)TimelineReaderWebServices.checkAccess((TimelineReaderManager)this.manager, (UserGroupInformation)adminUgi, (String)user1));
        Assert.assertTrue((boolean)TimelineReaderWebServices.checkAccess((TimelineReaderManager)this.manager, (UserGroupInformation)adminUgi, (String)user2));
        try {
            TimelineReaderWebServices.checkAccess((TimelineReaderManager)this.manager, (UserGroupInformation)user1Ugi, (String)user2);
            Assert.fail((String)"user1Ugi is not allowed to view user2");
        }
        catch (ForbiddenException forbiddenException) {
            // empty catch block
        }
        try {
            TimelineReaderWebServices.checkAccess((TimelineReaderManager)this.manager, (UserGroupInformation)user1Ugi, (String)user2);
            Assert.fail((String)"user2Ugi is not allowed to view user1");
        }
        catch (ForbiddenException forbiddenException) {
            // empty catch block
        }
        String userKey = "user";
        Set<TimelineEntity> entities = this.createEntities(10, userKey);
        TimelineReaderWebServices.checkAccess((TimelineReaderManager)this.manager, (UserGroupInformation)adminUgi, entities, (String)userKey, (boolean)true);
        Assert.assertTrue((entities.size() == 10 ? 1 : 0) != 0);
        entities = this.createEntities(5, userKey);
        TimelineReaderWebServices.checkAccess((TimelineReaderManager)this.manager, (UserGroupInformation)user1Ugi, entities, (String)userKey, (boolean)true);
        Assert.assertTrue((entities.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)user1, entities.iterator().next().getInfo().get(userKey));
        entities = this.createEntities(8, userKey);
        TimelineReaderWebServices.checkAccess((TimelineReaderManager)this.manager, (UserGroupInformation)user2Ugi, entities, (String)userKey, (boolean)true);
        Assert.assertTrue((entities.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)user2, entities.iterator().next().getInfo().get(userKey));
    }

    Set<TimelineEntity> createEntities(int noOfUsers, String userKey) {
        LinkedHashSet<TimelineEntity> entities = new LinkedHashSet<TimelineEntity>();
        for (int i = 0; i < noOfUsers; ++i) {
            TimelineEntity e = new TimelineEntity();
            e.setType("user" + i);
            e.setId("user" + i);
            e.getInfo().put(userKey, "user" + i);
            entities.add(e);
        }
        return entities;
    }
}

