/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.reader;

import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineReaderContext;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineUIDConverter;
import org.junit.Assert;
import org.junit.Test;

public class TestTimelineUIDConverter {
    @Test
    public void testUIDEncodingDecoding() throws Exception {
        TimelineReaderContext context = new TimelineReaderContext("!cluster", "!b*o*!xer", "oozie*", null, null, null, null);
        String uid = TimelineUIDConverter.FLOW_UID.encodeUID(context);
        Assert.assertEquals((Object)"*!cluster!*!b**o***!xer!oozie**", (Object)uid);
        Assert.assertEquals((Object)context, (Object)TimelineUIDConverter.FLOW_UID.decodeUID(uid));
        context = new TimelineReaderContext("!cluster*", "!b*o!!x!*er", "*oozie!", Long.valueOf(123L), null, null, null);
        uid = TimelineUIDConverter.FLOWRUN_UID.encodeUID(context);
        Assert.assertEquals((Object)"*!cluster**!*!b**o*!*!x*!**er!**oozie*!!123", (Object)uid);
        Assert.assertEquals((Object)context, (Object)TimelineUIDConverter.FLOWRUN_UID.decodeUID(uid));
        context = new TimelineReaderContext("yarn_cluster", "root", "hive_join", Long.valueOf(1234L), "application_1111111111_1111", null, null);
        uid = TimelineUIDConverter.APPLICATION_UID.encodeUID(context);
        Assert.assertEquals((Object)"yarn_cluster!root!hive_join!1234!application_1111111111_1111", (Object)uid);
        Assert.assertEquals((Object)context, (Object)TimelineUIDConverter.APPLICATION_UID.decodeUID(uid));
        context = new TimelineReaderContext("yarn_cluster", null, null, null, "application_1111111111_1111", null, null);
        uid = TimelineUIDConverter.APPLICATION_UID.encodeUID(context);
        Assert.assertEquals((Object)"yarn_cluster!application_1111111111_1111", (Object)uid);
        Assert.assertEquals((Object)context, (Object)TimelineUIDConverter.APPLICATION_UID.decodeUID(uid));
        context = new TimelineReaderContext("yarn_cluster", "root", "hive_join", Long.valueOf(1234L), "application_1111111111_1111", "YARN_CONTAINER", Long.valueOf(12345L), "container_1111111111_1111_01_000001");
        uid = TimelineUIDConverter.GENERIC_ENTITY_UID.encodeUID(context);
        Assert.assertEquals((Object)"yarn_cluster!root!hive_join!1234!application_1111111111_1111!YARN_CONTAINER!12345!container_1111111111_1111_01_000001", (Object)uid);
        Assert.assertEquals((Object)context, (Object)TimelineUIDConverter.GENERIC_ENTITY_UID.decodeUID(uid));
        context = new TimelineReaderContext("yarn_cluster", null, null, null, "application_1111111111_1111", "YARN_CONTAINER", Long.valueOf(54321L), "container_1111111111_1111_01_000001");
        uid = TimelineUIDConverter.GENERIC_ENTITY_UID.encodeUID(context);
        Assert.assertEquals((Object)"yarn_cluster!application_1111111111_1111!YARN_CONTAINER!54321!container_1111111111_1111_01_000001", (Object)uid);
        Assert.assertEquals((Object)context, (Object)TimelineUIDConverter.GENERIC_ENTITY_UID.decodeUID(uid));
        context = new TimelineReaderContext("yarn_cluster", null, null, null, null, "YARN_CONTAINER", Long.valueOf(54321L), "container_1111111111_1111_01_000001", "user1");
        uid = TimelineUIDConverter.SUB_APPLICATION_ENTITY_UID.encodeUID(context);
        Assert.assertEquals((Object)"yarn_cluster!user1!YARN_CONTAINER!54321!container_1111111111_1111_01_000001", (Object)uid);
        Assert.assertEquals((Object)context, (Object)TimelineUIDConverter.SUB_APPLICATION_ENTITY_UID.decodeUID(uid));
    }

    @Test
    public void testUIDNotProperlyEscaped() throws Exception {
        try {
            TimelineUIDConverter.FLOW_UID.decodeUID("*!cluster!*!b*o***!xer!oozie**");
            Assert.fail((String)"UID not properly escaped. Exception should have been thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            TimelineUIDConverter.FLOW_UID.decodeUID("*!cluster!*!b**o***!xer!oozie*");
            Assert.fail((String)"UID not properly escaped. Exception should have been thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            TimelineUIDConverter.FLOW_UID.decodeUID("*!cluster!*!b**o***xer!oozie*");
            Assert.fail((String)"UID not properly escaped. Exception should have been thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertNull((Object)TimelineUIDConverter.FLOW_UID.decodeUID("!cluster!*!b**o***!xer!oozie**"));
        Assert.assertNull((Object)TimelineUIDConverter.FLOW_UID.decodeUID("*!cluster!*!b**o**!xer!oozie**"));
    }
}

