/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineMetric;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineMetricOperation;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.timelineservice.collector.TimelineCollectorContext;
import org.apache.hadoop.yarn.server.timelineservice.storage.FileSystemTimelineWriterImpl;
import org.apache.hadoop.yarn.util.timeline.TimelineUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestFileSystemTimelineWriterImpl {
    @Rule
    public TemporaryFolder tmpFolder = new TemporaryFolder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteEntityToFile() throws Exception {
        TimelineEntities te = new TimelineEntities();
        TimelineEntity entity = new TimelineEntity();
        String id = "hello";
        String type = "world";
        entity.setId(id);
        entity.setType(type);
        entity.setCreatedTime(Long.valueOf(1425016501000L));
        te.addEntity(entity);
        TimelineMetric metric = new TimelineMetric();
        String metricId = "CPU";
        metric.setId(metricId);
        metric.setType(TimelineMetric.Type.SINGLE_VALUE);
        metric.setRealtimeAggregationOp(TimelineMetricOperation.SUM);
        metric.addValue(1425016501000L, (Number)1234567L);
        TimelineEntity entity2 = new TimelineEntity();
        String id2 = "metric";
        String type2 = "app";
        entity2.setId(id2);
        entity2.setType(type2);
        entity2.setCreatedTime(Long.valueOf(1425016503000L));
        entity2.addMetric(metric);
        te.addEntity(entity2);
        HashMap<String, TimelineMetric> aggregatedMetrics = new HashMap<String, TimelineMetric>();
        aggregatedMetrics.put(metricId, metric);
        try (FileSystemTimelineWriterImpl fsi = null;){
            fsi = new FileSystemTimelineWriterImpl();
            YarnConfiguration conf = new YarnConfiguration();
            String outputRoot = this.tmpFolder.newFolder().getAbsolutePath();
            conf.set("yarn.timeline-service.fs-writer.root-dir", outputRoot);
            fsi.init((Configuration)conf);
            fsi.start();
            fsi.write(new TimelineCollectorContext("cluster_id", "user_id", "flow_name", "flow_version", Long.valueOf(12345678L), "app_id"), te, UserGroupInformation.createRemoteUser((String)"user_id"));
            String fileName = outputRoot + File.separator + "entities" + File.separator + "cluster_id" + File.separator + "user_id" + File.separator + "flow_name" + File.separator + "flow_version" + File.separator + "12345678" + File.separator + "app_id" + File.separator + type + File.separator + id + ".thist";
            Path path = new Path(fileName);
            FileSystem fs = FileSystem.get((Configuration)conf);
            Assert.assertTrue((String)("Specified path(" + fileName + ") should exist: "), (boolean)fs.exists(path));
            FileStatus fileStatus = fs.getFileStatus(path);
            Assert.assertTrue((String)"Specified path should be a file", (!fileStatus.isDirectory() ? 1 : 0) != 0);
            List<String> data = this.readFromFile(fs, path);
            Assert.assertTrue((String)("data size is:" + data.size()), (data.size() == 2 ? 1 : 0) != 0);
            String d = data.get(0);
            Assert.assertEquals((Object)d, (Object)TimelineUtils.dumpTimelineRecordtoJSON((Object)entity));
            String fileName2 = fsi.getOutputRoot() + File.separator + "entities" + File.separator + "cluster_id" + File.separator + "user_id" + File.separator + "flow_name" + File.separator + "flow_version" + File.separator + "12345678" + File.separator + "app_id" + File.separator + type2 + File.separator + id2 + ".thist";
            Path path2 = new Path(fileName2);
            Assert.assertTrue((String)("Specified path(" + fileName + ") should exist: "), (boolean)fs.exists(path2));
            FileStatus fileStatus2 = fs.getFileStatus(path2);
            Assert.assertTrue((String)"Specified path should be a file", (!fileStatus2.isDirectory() ? 1 : 0) != 0);
            List<String> data2 = this.readFromFile(fs, path2);
            Assert.assertTrue((String)("data size is:" + data2.size()), (data2.size() == 2 ? 1 : 0) != 0);
            String metricToString = data2.get(0);
            Assert.assertEquals((Object)metricToString, (Object)TimelineUtils.dumpTimelineRecordtoJSON((Object)entity2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteMultipleEntities() throws Exception {
        String id = "appId";
        String type = "app";
        TimelineEntities te1 = new TimelineEntities();
        TimelineEntity entity = new TimelineEntity();
        entity.setId(id);
        entity.setType(type);
        entity.setCreatedTime(Long.valueOf(1425016501000L));
        te1.addEntity(entity);
        TimelineEntities te2 = new TimelineEntities();
        TimelineEntity entity2 = new TimelineEntity();
        entity2.setId(id);
        entity2.setType(type);
        entity2.setCreatedTime(Long.valueOf(1425016503000L));
        te2.addEntity(entity2);
        try (FileSystemTimelineWriterImpl fsi = null;){
            fsi = new FileSystemTimelineWriterImpl();
            YarnConfiguration conf = new YarnConfiguration();
            String outputRoot = this.tmpFolder.newFolder().getAbsolutePath();
            conf.set("yarn.timeline-service.fs-writer.root-dir", outputRoot);
            fsi.init((Configuration)conf);
            fsi.start();
            fsi.write(new TimelineCollectorContext("cluster_id", "user_id", "flow_name", "flow_version", Long.valueOf(12345678L), "app_id"), te1, UserGroupInformation.createRemoteUser((String)"user_id"));
            fsi.write(new TimelineCollectorContext("cluster_id", "user_id", "flow_name", "flow_version", Long.valueOf(12345678L), "app_id"), te2, UserGroupInformation.createRemoteUser((String)"user_id"));
            String fileName = outputRoot + File.separator + "entities" + File.separator + "cluster_id" + File.separator + "user_id" + File.separator + "flow_name" + File.separator + "flow_version" + File.separator + "12345678" + File.separator + "app_id" + File.separator + type + File.separator + id + ".thist";
            Path path = new Path(fileName);
            FileSystem fs = FileSystem.get((Configuration)conf);
            Assert.assertTrue((String)("Specified path(" + fileName + ") should exist: "), (boolean)fs.exists(path));
            FileStatus fileStatus = fs.getFileStatus(path);
            Assert.assertTrue((String)"Specified path should be a file", (!fileStatus.isDirectory() ? 1 : 0) != 0);
            List<String> data = this.readFromFile(fs, path);
            Assert.assertTrue((String)("data size is:" + data.size()), (data.size() == 3 ? 1 : 0) != 0);
            String d = data.get(0);
            Assert.assertEquals((Object)d, (Object)TimelineUtils.dumpTimelineRecordtoJSON((Object)entity));
            String metricToString = data.get(1);
            Assert.assertEquals((Object)metricToString, (Object)TimelineUtils.dumpTimelineRecordtoJSON((Object)entity2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteEntitiesWithEmptyFlowName() throws Exception {
        String id = "appId";
        String type = "app";
        TimelineEntities te = new TimelineEntities();
        TimelineEntity entity = new TimelineEntity();
        entity.setId(id);
        entity.setType(type);
        entity.setCreatedTime(Long.valueOf(1425016501000L));
        te.addEntity(entity);
        try (FileSystemTimelineWriterImpl fsi = null;){
            fsi = new FileSystemTimelineWriterImpl();
            YarnConfiguration conf = new YarnConfiguration();
            String outputRoot = this.tmpFolder.newFolder().getAbsolutePath();
            conf.set("yarn.timeline-service.fs-writer.root-dir", outputRoot);
            fsi.init((Configuration)conf);
            fsi.start();
            fsi.write(new TimelineCollectorContext("cluster_id", "user_id", "", "flow_version", Long.valueOf(12345678L), "app_id"), te, UserGroupInformation.createRemoteUser((String)"user_id"));
            String fileName = outputRoot + File.separator + "entities" + File.separator + "cluster_id" + File.separator + "user_id" + File.separator + "" + File.separator + "flow_version" + File.separator + "12345678" + File.separator + "app_id" + File.separator + type + File.separator + id + ".thist";
            Path path = new Path(fileName);
            FileSystem fs = FileSystem.get((Configuration)conf);
            Assert.assertTrue((String)("Specified path(" + fileName + ") should exist: "), (boolean)fs.exists(path));
            FileStatus fileStatus = fs.getFileStatus(path);
            Assert.assertTrue((String)"Specified path should be a file", (!fileStatus.isDirectory() ? 1 : 0) != 0);
            List<String> data = this.readFromFile(fs, path);
            Assert.assertTrue((String)("data size is:" + data.size()), (data.size() == 2 ? 1 : 0) != 0);
            String d = data.get(0);
            Assert.assertEquals((Object)d, (Object)TimelineUtils.dumpTimelineRecordtoJSON((Object)entity));
        }
    }

    private List<String> readFromFile(FileSystem fs, Path path) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fs.open(path)));
        ArrayList<String> data = new ArrayList<String>();
        String line = br.readLine();
        data.add(line);
        while (line != null) {
            line = br.readLine();
            data.add(line);
        }
        return data;
    }
}

