/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.yarn.api.records.timelineservice.ApplicationEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.server.timelineservice.collector.TimelineCollectorContext;
import org.apache.hadoop.yarn.server.timelineservice.storage.DataGeneratorForTest;
import org.apache.hadoop.yarn.server.timelineservice.storage.HBaseTimelineWriterImpl;
import org.apache.hadoop.yarn.server.timelineservice.storage.TimelineStorageMonitor;
import org.junit.Assert;
import org.junit.Test;

public class TestTimelineWriterHBaseDown {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testTimelineWriterHBaseDown() throws Exception {
        HBaseTestingUtility util = new HBaseTestingUtility();
        HBaseTimelineWriterImpl writer = new HBaseTimelineWriterImpl();
        try {
            boolean exceptionCaught;
            block7: {
                Configuration c1 = util.getConfiguration();
                c1.setLong("yarn.timeline-service.reader.storage-monitor.interval-ms", 5000L);
                writer.init(c1);
                writer.start();
                util.startMiniCluster();
                DataGeneratorForTest.createSchema(util.getConfiguration());
                TimelineStorageMonitor storageMonitor = writer.getTimelineStorageMonitor();
                this.waitForHBaseToUp(storageMonitor);
                try {
                    storageMonitor.checkStorageIsUp();
                }
                catch (IOException e) {
                    Assert.fail((String)"HBaseStorageMonitor failed to detect HBase Up");
                }
                util.shutdownMiniHBaseCluster();
                this.waitForHBaseToDown(storageMonitor);
                TimelineEntities te = new TimelineEntities();
                ApplicationEntity entity = new ApplicationEntity();
                String appId = "application_1000178881110_2002";
                entity.setId(appId);
                Long cTime = 1425016501000L;
                entity.setCreatedTime(cTime);
                te.addEntity((TimelineEntity)entity);
                exceptionCaught = false;
                try {
                    writer.write(new TimelineCollectorContext("ATS1", "user1", "flow2", "AB7822C10F1111", Long.valueOf(1002345678919L), appId), te, UserGroupInformation.createRemoteUser((String)"user1"));
                }
                catch (IOException e) {
                    if (!e.getMessage().equals("HBase is down")) break block7;
                    exceptionCaught = true;
                }
            }
            Assert.assertTrue((String)"HBaseStorageMonitor failed to detect HBase Down", (boolean)exceptionCaught);
        }
        finally {
            writer.stop();
            util.shutdownMiniCluster();
        }
    }

    public void waitForHBaseToUp(TimelineStorageMonitor storageMonitor) throws Exception {
        GenericTestUtils.waitFor(() -> {
            try {
                storageMonitor.checkStorageIsUp();
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }, (int)1000, (int)150000);
    }

    public void waitForHBaseToDown(TimelineStorageMonitor storageMonitor) throws Exception {
        GenericTestUtils.waitFor(() -> {
            try {
                storageMonitor.checkStorageIsUp();
                return false;
            }
            catch (IOException e) {
                return true;
            }
        }, (int)1000, (int)150000);
    }
}

