/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.common;

import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.AppIdKeyConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.EventColumnName;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.EventColumnNameConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.LongKeyConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.Separator;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.StringKeyConverter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestKeyConverters {
    @Test
    void testAppIdKeyConverter() {
        AppIdKeyConverter appIdKeyConverter = new AppIdKeyConverter();
        long currentTs = System.currentTimeMillis();
        ApplicationId appId1 = ApplicationId.newInstance((long)currentTs, (int)1);
        ApplicationId appId2 = ApplicationId.newInstance((long)currentTs, (int)2);
        ApplicationId appId3 = ApplicationId.newInstance((long)(currentTs + 300L), (int)1);
        String appIdStr1 = appId1.toString();
        String appIdStr2 = appId2.toString();
        String appIdStr3 = appId3.toString();
        byte[] appIdBytes1 = appIdKeyConverter.encode(appIdStr1);
        byte[] appIdBytes2 = appIdKeyConverter.encode(appIdStr2);
        byte[] appIdBytes3 = appIdKeyConverter.encode(appIdStr3);
        Assertions.assertTrue((Bytes.compareTo((byte[])appIdBytes1, (byte[])appIdBytes2) > 0 && Bytes.compareTo((byte[])appIdBytes1, (byte[])appIdBytes3) > 0 && Bytes.compareTo((byte[])appIdBytes2, (byte[])appIdBytes3) > 0 ? 1 : 0) != 0, (String)"Ordering of app ids' is incorrect");
        String decodedAppId1 = appIdKeyConverter.decode(appIdBytes1);
        String decodedAppId2 = appIdKeyConverter.decode(appIdBytes2);
        String decodedAppId3 = appIdKeyConverter.decode(appIdBytes3);
        Assertions.assertEquals((Object)appIdStr1, (Object)decodedAppId1);
        Assertions.assertEquals((Object)appIdStr2, (Object)decodedAppId2);
        Assertions.assertEquals((Object)appIdStr3, (Object)decodedAppId3);
    }

    @Test
    void testEventColumnNameConverter() {
        String eventId = "=foo_=eve=nt=";
        byte[] valSepBytes = Bytes.toBytes((String)Separator.VALUES.getValue());
        byte[] maxByteArr = Bytes.createMaxByteArray((int)(8 - valSepBytes.length));
        byte[] ts = Bytes.add((byte[])valSepBytes, (byte[])maxByteArr);
        Long eventTs = Bytes.toLong((byte[])ts);
        byte[] byteEventColName = new EventColumnName(eventId, eventTs, null).getColumnQualifier();
        EventColumnNameConverter eventColumnNameConverter = new EventColumnNameConverter();
        EventColumnName eventColName = (EventColumnName)eventColumnNameConverter.decode(byteEventColName);
        Assertions.assertEquals((Object)eventId, (Object)eventColName.getId());
        Assertions.assertEquals((Long)eventTs, (Long)eventColName.getTimestamp());
        Assertions.assertNull((Object)eventColName.getInfoKey());
        String infoKey = "f=oo_event_in=fo=_key";
        byteEventColName = new EventColumnName(eventId, eventTs, infoKey).getColumnQualifier();
        eventColName = (EventColumnName)eventColumnNameConverter.decode(byteEventColName);
        Assertions.assertEquals((Object)eventId, (Object)eventColName.getId());
        Assertions.assertEquals((Long)eventTs, (Long)eventColName.getTimestamp());
        Assertions.assertEquals((Object)infoKey, (Object)eventColName.getInfoKey());
    }

    @Test
    void testLongKeyConverter() {
        LongKeyConverter longKeyConverter = new LongKeyConverter();
        this.confirmLongKeyConverter(longKeyConverter, Long.MIN_VALUE);
        this.confirmLongKeyConverter(longKeyConverter, -1234567890L);
        this.confirmLongKeyConverter(longKeyConverter, -128L);
        this.confirmLongKeyConverter(longKeyConverter, -127L);
        this.confirmLongKeyConverter(longKeyConverter, -1L);
        this.confirmLongKeyConverter(longKeyConverter, 0L);
        this.confirmLongKeyConverter(longKeyConverter, 1L);
        this.confirmLongKeyConverter(longKeyConverter, 127L);
        this.confirmLongKeyConverter(longKeyConverter, 128L);
        this.confirmLongKeyConverter(longKeyConverter, 1234567890L);
        this.confirmLongKeyConverter(longKeyConverter, Long.MAX_VALUE);
    }

    private void confirmLongKeyConverter(LongKeyConverter longKeyConverter, Long testValue) {
        Long decoded = longKeyConverter.decode(longKeyConverter.encode(testValue));
        Assertions.assertEquals((Long)testValue, (Long)decoded);
    }

    @Test
    void testStringKeyConverter() {
        StringKeyConverter stringKeyConverter = new StringKeyConverter();
        String phrase = "QuackAttack now!";
        for (int i = 0; i < phrase.length(); ++i) {
            String sub = phrase.substring(i, phrase.length());
            this.confirmStrignKeyConverter(stringKeyConverter, sub);
            this.confirmStrignKeyConverter(stringKeyConverter, sub + sub);
        }
    }

    private void confirmStrignKeyConverter(StringKeyConverter stringKeyConverter, String testValue) {
        String decoded = stringKeyConverter.decode(stringKeyConverter.encode(testValue));
        Assertions.assertEquals((Object)testValue, (Object)decoded);
    }
}

