/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.apptoflow;

import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.yarn.server.timelineservice.storage.apptoflow.AppToFlowColumnFamily;
import org.apache.hadoop.yarn.server.timelineservice.storage.apptoflow.AppToFlowTable;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ColumnFamily;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ColumnHelper;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ColumnPrefix;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.GenericConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.Separator;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ValueConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.Attribute;

public enum AppToFlowColumnPrefix implements ColumnPrefix<AppToFlowTable>
{
    FLOW_NAME(AppToFlowColumnFamily.MAPPING, "flow_name"),
    FLOW_RUN_ID(AppToFlowColumnFamily.MAPPING, "flow_run_id"),
    USER_ID(AppToFlowColumnFamily.MAPPING, "user_id");

    private final ColumnFamily<AppToFlowTable> columnFamily;
    private final String columnPrefix;
    private final byte[] columnPrefixBytes;
    private final ValueConverter valueConverter;

    private AppToFlowColumnPrefix(ColumnFamily<AppToFlowTable> columnFamily, String columnPrefix) {
        this.columnFamily = columnFamily;
        this.columnPrefix = columnPrefix;
        this.columnPrefixBytes = (byte[])(columnPrefix == null ? null : Bytes.toBytes((String)Separator.SPACE.encode(columnPrefix)));
        this.valueConverter = GenericConverter.getInstance();
    }

    @Override
    public byte[] getColumnPrefixBytes(String qualifierPrefix) {
        return ColumnHelper.getColumnQualifier(this.columnPrefixBytes, qualifierPrefix);
    }

    @Override
    public byte[] getColumnPrefixBytes(byte[] qualifierPrefix) {
        return ColumnHelper.getColumnQualifier(this.columnPrefixBytes, qualifierPrefix);
    }

    @Override
    public byte[] getColumnPrefixInBytes() {
        return this.columnPrefixBytes != null ? (byte[])this.columnPrefixBytes.clone() : null;
    }

    @Override
    public byte[] getColumnFamilyBytes() {
        return this.columnFamily.getBytes();
    }

    @Override
    public ValueConverter getValueConverter() {
        return this.valueConverter;
    }

    @Override
    public Attribute[] getCombinedAttrsWithAggr(Attribute ... attributes) {
        return attributes;
    }

    @Override
    public boolean supplementCellTimeStamp() {
        return false;
    }
}

