/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.common;

import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.server.timelineservice.storage.application.ApplicationRowKey;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.HBaseTimelineSchemaUtils;
import org.apache.hadoop.yarn.server.timelineservice.storage.entity.EntityRowKey;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowActivityRowKey;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowRunRowKey;
import org.apache.hadoop.yarn.server.timelineservice.storage.subapplication.SubApplicationRowKey;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestRowKeysAsString {
    private static final String CLUSTER = "cl!uster*";
    private static final String USER = "*user";
    private static final String SUB_APP_USER = "*subAppUser";
    private static final String FLOW_NAME = "dummy_!*flow!";
    private static final Long FLOW_RUN_ID = System.currentTimeMillis();
    private static final String APPLICATION_ID = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1).toString();

    @Test
    @Timeout(value=10000L)
    void testApplicationRow() {
        String rowKeyAsString = new ApplicationRowKey(CLUSTER, USER, FLOW_NAME, FLOW_RUN_ID, APPLICATION_ID).getRowKeyAsString();
        ApplicationRowKey rowKey = ApplicationRowKey.parseRowKeyFromString((String)rowKeyAsString);
        Assertions.assertEquals((Object)CLUSTER, (Object)rowKey.getClusterId());
        Assertions.assertEquals((Object)USER, (Object)rowKey.getUserId());
        Assertions.assertEquals((Object)FLOW_NAME, (Object)rowKey.getFlowName());
        Assertions.assertEquals((Long)FLOW_RUN_ID, (Long)rowKey.getFlowRunId());
        Assertions.assertEquals((Object)APPLICATION_ID, (Object)rowKey.getAppId());
    }

    @Test
    @Timeout(value=10000L)
    void testEntityRowKey() {
        char del = '!';
        char esc = '*';
        String id = del + esc + "ent" + esc + del + "ity" + esc + del + esc + "id" + esc + del + esc;
        String type = "entity" + esc + del + esc + "Type";
        TimelineEntity entity = new TimelineEntity();
        entity.setId(id);
        entity.setType(type);
        entity.setIdPrefix(54321L);
        String rowKeyAsString = new EntityRowKey(CLUSTER, USER, FLOW_NAME, FLOW_RUN_ID, APPLICATION_ID, entity.getType(), Long.valueOf(entity.getIdPrefix()), entity.getId()).getRowKeyAsString();
        EntityRowKey rowKey = EntityRowKey.parseRowKeyFromString((String)rowKeyAsString);
        Assertions.assertEquals((Object)CLUSTER, (Object)rowKey.getClusterId());
        Assertions.assertEquals((Object)USER, (Object)rowKey.getUserId());
        Assertions.assertEquals((Object)FLOW_NAME, (Object)rowKey.getFlowName());
        Assertions.assertEquals((Long)FLOW_RUN_ID, (Long)rowKey.getFlowRunId());
        Assertions.assertEquals((Object)APPLICATION_ID, (Object)rowKey.getAppId());
        Assertions.assertEquals((Object)entity.getType(), (Object)rowKey.getEntityType());
        Assertions.assertEquals((long)entity.getIdPrefix(), (long)rowKey.getEntityIdPrefix());
        Assertions.assertEquals((Object)entity.getId(), (Object)rowKey.getEntityId());
    }

    @Test
    @Timeout(value=10000L)
    void testFlowActivityRowKey() {
        Long ts = 1459900830000L;
        Long dayTimestamp = HBaseTimelineSchemaUtils.getTopOfTheDayTimestamp((long)ts);
        String rowKeyAsString = new FlowActivityRowKey(CLUSTER, ts, USER, FLOW_NAME).getRowKeyAsString();
        FlowActivityRowKey rowKey = FlowActivityRowKey.parseRowKeyFromString((String)rowKeyAsString);
        Assertions.assertEquals((Object)CLUSTER, (Object)rowKey.getClusterId());
        Assertions.assertEquals((Long)dayTimestamp, (Long)rowKey.getDayTimestamp());
        Assertions.assertEquals((Object)USER, (Object)rowKey.getUserId());
        Assertions.assertEquals((Object)FLOW_NAME, (Object)rowKey.getFlowName());
    }

    @Test
    @Timeout(value=10000L)
    void testFlowRunRowKey() {
        String rowKeyAsString = new FlowRunRowKey(CLUSTER, USER, FLOW_NAME, FLOW_RUN_ID).getRowKeyAsString();
        FlowRunRowKey rowKey = FlowRunRowKey.parseRowKeyFromString((String)rowKeyAsString);
        Assertions.assertEquals((Object)CLUSTER, (Object)rowKey.getClusterId());
        Assertions.assertEquals((Object)USER, (Object)rowKey.getUserId());
        Assertions.assertEquals((Object)FLOW_NAME, (Object)rowKey.getFlowName());
        Assertions.assertEquals((Long)FLOW_RUN_ID, (Long)rowKey.getFlowRunId());
    }

    @Test
    @Timeout(value=10000L)
    void testSubApplicationRowKey() {
        char del = '!';
        char esc = '*';
        String id = del + esc + "ent" + esc + del + "ity" + esc + del + esc + "id" + esc + del + esc;
        String type = "entity" + esc + del + esc + "Type";
        TimelineEntity entity = new TimelineEntity();
        entity.setId(id);
        entity.setType(type);
        entity.setIdPrefix(54321L);
        String rowKeyAsString = new SubApplicationRowKey(SUB_APP_USER, CLUSTER, entity.getType(), Long.valueOf(entity.getIdPrefix()), entity.getId(), USER).getRowKeyAsString();
        SubApplicationRowKey rowKey = SubApplicationRowKey.parseRowKeyFromString((String)rowKeyAsString);
        Assertions.assertEquals((Object)SUB_APP_USER, (Object)rowKey.getSubAppUserId());
        Assertions.assertEquals((Object)CLUSTER, (Object)rowKey.getClusterId());
        Assertions.assertEquals((Object)entity.getType(), (Object)rowKey.getEntityType());
        Assertions.assertEquals((long)entity.getIdPrefix(), (long)rowKey.getEntityIdPrefix());
        Assertions.assertEquals((Object)entity.getId(), (Object)rowKey.getEntityId());
        Assertions.assertEquals((Object)USER, (Object)rowKey.getUserId());
    }
}

