/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.common;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.HBaseTimelineStorageUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestHBaseTimelineStorageUtils {
    private String hbaseConfigPath = "target/hbase-site.xml";

    @Before
    public void setup() throws IOException {
        Configuration hbaseConf = new Configuration();
        hbaseConf.set("input", "test");
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        hbaseConf.writeXml((OutputStream)bytesOut);
        bytesOut.close();
        File file = new File(this.hbaseConfigPath);
        FileOutputStream os = new FileOutputStream(file);
        ((OutputStream)os).write(bytesOut.toByteArray());
        ((OutputStream)os).close();
    }

    @Test(expected=NullPointerException.class)
    public void testGetTimelineServiceHBaseConfNullArgument() throws Exception {
        HBaseTimelineStorageUtils.getTimelineServiceHBaseConf(null);
    }

    @Test
    public void testWithHbaseConfAtLocalFileSystem() throws IOException {
        Configuration conf = new Configuration();
        conf.set("yarn.timeline-service.hbase.configuration.file", this.hbaseConfigPath);
        Configuration hbaseConfFromLocal = HBaseTimelineStorageUtils.getTimelineServiceHBaseConf((Configuration)conf);
        Assert.assertEquals((String)"Failed to read hbase config from Local FileSystem", (Object)"test", (Object)hbaseConfFromLocal.get("input"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWithHbaseConfAtHdfsFileSystem() throws IOException {
        MiniDFSCluster hdfsCluster = null;
        try {
            HdfsConfiguration hdfsConfig = new HdfsConfiguration();
            hdfsCluster = new MiniDFSCluster.Builder((Configuration)hdfsConfig).numDataNodes(1).build();
            DistributedFileSystem fs = hdfsCluster.getFileSystem();
            Path path = new Path("/tmp/hdfs-site.xml");
            fs.copyFromLocalFile(new Path(this.hbaseConfigPath), path);
            Configuration conf = new Configuration((Configuration)hdfsConfig);
            conf.set("yarn.timeline-service.hbase.configuration.file", path.toString());
            Configuration hbaseConfFromHdfs = HBaseTimelineStorageUtils.getTimelineServiceHBaseConf((Configuration)conf);
            Assert.assertEquals((String)"Failed to read hbase config from Hdfs FileSystem", (Object)"test", (Object)hbaseConfFromHdfs.get("input"));
        }
        finally {
            if (hdfsCluster != null) {
                hdfsCluster.shutdown();
            }
        }
    }
}

