/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.common;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.Column;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ColumnHelper;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ColumnPrefix;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.KeyConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.Separator;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.TimestampGenerator;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.TypedBufferedMutator;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ValueConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.AggregationCompactionDimension;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.Attribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ColumnRWHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ColumnHelper.class);

    private ColumnRWHelper() {
    }

    private static long getPutTimestamp(Long timestamp, boolean supplementTs, Attribute[] attributes) {
        if (timestamp == null) {
            timestamp = System.currentTimeMillis();
        }
        if (!supplementTs) {
            return timestamp;
        }
        String appId = ColumnRWHelper.getAppIdFromAttributes(attributes);
        long supplementedTS = TimestampGenerator.getSupplementedTimestamp((long)timestamp, (String)appId);
        return supplementedTS;
    }

    private static String getAppIdFromAttributes(Attribute[] attributes) {
        if (attributes == null) {
            return null;
        }
        String appId = null;
        for (Attribute attribute : attributes) {
            if (!AggregationCompactionDimension.APPLICATION_ID.toString().equals(attribute.getName())) continue;
            appId = Bytes.toString((byte[])attribute.getValue());
        }
        return appId;
    }

    public static void store(byte[] rowKey, TypedBufferedMutator<?> tableMutator, Column<?> column, Long timestamp, Object inputValue, Attribute ... attributes) throws IOException {
        ColumnRWHelper.store(rowKey, tableMutator, column.getColumnFamilyBytes(), column.getColumnQualifierBytes(), timestamp, column.supplementCellTimestamp(), inputValue, column.getValueConverter(), column.getCombinedAttrsWithAggr(attributes));
    }

    public static void store(byte[] rowKey, TypedBufferedMutator<?> tableMutator, byte[] columnFamilyBytes, byte[] columnQualifier, Long timestamp, boolean supplementTs, Object inputValue, ValueConverter converter, Attribute ... attributes) throws IOException {
        if (rowKey == null || columnQualifier == null || inputValue == null) {
            return;
        }
        Put p = new Put(rowKey);
        timestamp = ColumnRWHelper.getPutTimestamp(timestamp, supplementTs, attributes);
        p.addColumn(columnFamilyBytes, columnQualifier, timestamp.longValue(), converter.encodeValue(inputValue));
        if (attributes != null && attributes.length > 0) {
            for (Attribute attribute : attributes) {
                p.setAttribute(attribute.getName(), attribute.getValue());
            }
        }
        tableMutator.mutate((Mutation)p);
    }

    public static Object readResult(Result result, byte[] columnFamilyBytes, byte[] columnQualifierBytes, ValueConverter converter) throws IOException {
        if (result == null || columnQualifierBytes == null) {
            return null;
        }
        byte[] value = result.getValue(columnFamilyBytes, columnQualifierBytes);
        return converter.decodeValue(value);
    }

    public static Object readResult(Result result, Column<?> column) throws IOException {
        return ColumnRWHelper.readResult(result, column.getColumnFamilyBytes(), column.getColumnQualifierBytes(), column.getValueConverter());
    }

    public static Object readResult(Result result, ColumnPrefix<?> columnPrefix, String qualifier) throws IOException {
        byte[] columnQualifier = ColumnHelper.getColumnQualifier((byte[])columnPrefix.getColumnPrefixInBytes(), (String)qualifier);
        return ColumnRWHelper.readResult(result, columnPrefix.getColumnFamilyBytes(), columnQualifier, columnPrefix.getValueConverter());
    }

    public static <K> Map<K, Object> readResults(Result result, ColumnPrefix<?> columnPrefix, KeyConverter<K> keyConverter) throws IOException {
        return ColumnRWHelper.readResults(result, columnPrefix.getColumnFamilyBytes(), columnPrefix.getColumnPrefixInBytes(), keyConverter, columnPrefix.getValueConverter());
    }

    public static <K, V> NavigableMap<K, NavigableMap<Long, V>> readResultsWithTimestamps(Result result, ColumnPrefix<?> columnPrefix, KeyConverter<K> keyConverter) throws IOException {
        return ColumnRWHelper.readResultsWithTimestamps(result, columnPrefix.getColumnFamilyBytes(), columnPrefix.getColumnPrefixInBytes(), keyConverter, columnPrefix.getValueConverter(), columnPrefix.supplementCellTimeStamp());
    }

    public static <K, V> NavigableMap<K, NavigableMap<Long, V>> readResultsWithTimestamps(Result result, byte[] columnFamilyBytes, byte[] columnPrefixBytes, KeyConverter<K> keyConverter, ValueConverter valueConverter, boolean supplementTs) throws IOException {
        NavigableMap resultMap;
        NavigableMap columnCellMap;
        TreeMap results = new TreeMap();
        if (result != null && (columnCellMap = (NavigableMap)(resultMap = result.getMap()).get(columnFamilyBytes)) != null) {
            for (Map.Entry entry : columnCellMap.entrySet()) {
                Object converterColumnKey;
                block10: {
                    converterColumnKey = null;
                    if (columnPrefixBytes == null) {
                        LOG.debug("null prefix was specified; returning all columns");
                        try {
                            converterColumnKey = keyConverter.decode((byte[])entry.getKey());
                            break block10;
                        }
                        catch (IllegalArgumentException iae) {
                            LOG.error("Illegal column found, skipping this column.", (Throwable)iae);
                            continue;
                        }
                    }
                    byte[][] columnNameParts = Separator.QUALIFIERS.split((byte[])entry.getKey(), 2);
                    byte[] actualColumnPrefixBytes = columnNameParts[0];
                    if (Bytes.equals((byte[])columnPrefixBytes, (byte[])actualColumnPrefixBytes) && columnNameParts.length == 2) {
                        try {
                            converterColumnKey = keyConverter.decode(columnNameParts[1]);
                        }
                        catch (IllegalArgumentException iae) {
                            LOG.error("Illegal column found, skipping this column.", (Throwable)iae);
                            continue;
                        }
                    }
                }
                if (converterColumnKey == null) continue;
                TreeMap<Long, Object> cellResults = new TreeMap<Long, Object>();
                NavigableMap cells = (NavigableMap)entry.getValue();
                if (cells != null) {
                    for (Map.Entry cell : cells.entrySet()) {
                        Object value = valueConverter.decodeValue((byte[])cell.getValue());
                        Long ts = supplementTs ? TimestampGenerator.getTruncatedTimestamp((long)((Long)cell.getKey())) : (Long)cell.getKey();
                        cellResults.put(ts, value);
                    }
                }
                results.put(converterColumnKey, cellResults);
            }
        }
        return results;
    }

    public static <K> Map<K, Object> readResults(Result result, byte[] columnFamilyBytes, byte[] columnPrefixBytes, KeyConverter<K> keyConverter, ValueConverter valueConverter) throws IOException {
        HashMap<Object, Object> results = new HashMap<Object, Object>();
        if (result != null) {
            NavigableMap columns = result.getFamilyMap(columnFamilyBytes);
            for (Map.Entry entry : columns.entrySet()) {
                Object converterColumnKey;
                block8: {
                    byte[] actualColumnPrefixBytes;
                    byte[] columnKey = (byte[])entry.getKey();
                    if (columnKey == null || columnKey.length <= 0) continue;
                    converterColumnKey = null;
                    if (columnPrefixBytes == null) {
                        try {
                            converterColumnKey = keyConverter.decode(columnKey);
                            break block8;
                        }
                        catch (IllegalArgumentException iae) {
                            LOG.error("Illegal column found, skipping this column.", (Throwable)iae);
                            continue;
                        }
                    }
                    byte[][] columnNameParts = Separator.QUALIFIERS.split(columnKey, 2);
                    if (columnNameParts.length > 0 && Bytes.equals((byte[])columnPrefixBytes, (byte[])(actualColumnPrefixBytes = columnNameParts[0])) && columnNameParts.length == 2) {
                        try {
                            converterColumnKey = keyConverter.decode(columnNameParts[1]);
                        }
                        catch (IllegalArgumentException iae) {
                            LOG.error("Illegal column found, skipping this column.", (Throwable)iae);
                            continue;
                        }
                    }
                }
                if (converterColumnKey == null) continue;
                Object value = valueConverter.decodeValue((byte[])entry.getValue());
                results.put(converterColumnKey, value);
            }
        }
        return results;
    }

    public static void store(byte[] rowKey, TypedBufferedMutator<?> tableMutator, ColumnPrefix<?> columnPrefix, byte[] qualifier, Long timestamp, Object inputValue, Attribute ... attributes) throws IOException {
        if (qualifier == null) {
            throw new IOException("Cannot store column with null qualifier in " + tableMutator.getName().getNameAsString());
        }
        byte[] columnQualifier = columnPrefix.getColumnPrefixBytes(qualifier);
        Attribute[] combinedAttributes = columnPrefix.getCombinedAttrsWithAggr(attributes);
        ColumnRWHelper.store(rowKey, tableMutator, columnPrefix.getColumnFamilyBytes(), columnQualifier, timestamp, columnPrefix.supplementCellTimeStamp(), inputValue, columnPrefix.getValueConverter(), combinedAttributes);
    }

    public static void store(byte[] rowKey, TypedBufferedMutator<?> tableMutator, ColumnPrefix<?> columnPrefix, String qualifier, Long timestamp, Object inputValue, Attribute ... attributes) throws IOException {
        if (qualifier == null) {
            throw new IOException("Cannot store column with null qualifier in " + tableMutator.getName().getNameAsString());
        }
        byte[] columnQualifier = columnPrefix.getColumnPrefixBytes(qualifier);
        Attribute[] combinedAttributes = columnPrefix.getCombinedAttrsWithAggr(attributes);
        ColumnRWHelper.store(rowKey, tableMutator, columnPrefix.getColumnFamilyBytes(), columnQualifier, timestamp, columnPrefix.supplementCellTimeStamp(), inputValue, columnPrefix.getValueConverter(), combinedAttributes);
    }
}

