/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.documentstore.reader;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntityType;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.DocumentStoreTestUtils;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.collection.document.TimelineDocument;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.collection.document.entity.TimelineEntityDocument;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.collection.document.flowactivity.FlowActivityDocument;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.collection.document.flowrun.FlowRunDocument;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.reader.DocumentStoreReader;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineReaderContext;

public class DummyDocumentStoreReader<TimelineDoc extends TimelineDocument>
implements DocumentStoreReader<TimelineDoc> {
    private final TimelineEntityDocument entityDoc;
    private final List<TimelineEntityDocument> entityDocs;
    private final FlowRunDocument flowRunDoc;
    private final FlowActivityDocument flowActivityDoc;

    public DummyDocumentStoreReader() {
        try {
            this.entityDoc = DocumentStoreTestUtils.bakeTimelineEntityDoc();
            this.entityDocs = DocumentStoreTestUtils.bakeYarnAppTimelineEntities();
            this.flowRunDoc = DocumentStoreTestUtils.bakeFlowRunDoc();
            this.flowActivityDoc = DocumentStoreTestUtils.bakeFlowActivityDoc();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create DummyDocumentStoreReader : ", e);
        }
    }

    public TimelineDoc readDocument(String collectionName, TimelineReaderContext context, Class<TimelineDoc> docClass) {
        switch (TimelineEntityType.valueOf((String)context.getEntityType())) {
            case YARN_FLOW_ACTIVITY: {
                return (TimelineDoc)this.flowActivityDoc;
            }
            case YARN_FLOW_RUN: {
                return (TimelineDoc)this.flowRunDoc;
            }
        }
        return (TimelineDoc)this.entityDoc;
    }

    public List<TimelineDoc> readDocumentList(String collectionName, TimelineReaderContext context, Class<TimelineDoc> docClass, long size) {
        switch (TimelineEntityType.valueOf((String)context.getEntityType())) {
            case YARN_FLOW_ACTIVITY: {
                ArrayList<FlowActivityDocument> flowActivityDocs = new ArrayList<FlowActivityDocument>();
                flowActivityDocs.add(this.flowActivityDoc);
                if (size > (long)flowActivityDocs.size()) {
                    size = flowActivityDocs.size();
                }
                return flowActivityDocs.subList(0, (int)size);
            }
            case YARN_FLOW_RUN: {
                ArrayList<FlowRunDocument> flowRunDocs = new ArrayList<FlowRunDocument>();
                flowRunDocs.add(this.flowRunDoc);
                if (size > (long)flowRunDocs.size()) {
                    size = flowRunDocs.size();
                }
                return flowRunDocs.subList(0, (int)size);
            }
            case YARN_APPLICATION: {
                ArrayList<TimelineEntityDocument> applicationEntities = new ArrayList<TimelineEntityDocument>();
                applicationEntities.add(this.entityDoc);
                if (size > (long)applicationEntities.size()) {
                    size = applicationEntities.size();
                }
                return applicationEntities.subList(0, (int)size);
            }
        }
        if (size > (long)this.entityDocs.size() || size == -1L) {
            size = this.entityDocs.size();
        }
        return this.entityDocs.subList(0, (int)size);
    }

    public Set<String> fetchEntityTypes(String collectionName, TimelineReaderContext context) {
        return this.entityDocs.stream().map(TimelineEntityDocument::getType).collect(Collectors.toSet());
    }

    public void close() {
    }
}

