/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.documentstore;

import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntityType;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.DocumentStoreTestUtils;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.DocumentStoreTimelineReaderImpl;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.DocumentStoreUtils;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.collection.document.TimelineDocument;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.collection.document.entity.TimelineEntityDocument;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.lib.DocumentStoreFactory;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.reader.DocumentStoreReader;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.reader.DummyDocumentStoreReader;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineDataToRetrieve;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineEntityFilters;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineReaderContext;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineCompareFilter;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineCompareOp;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineExistsFilter;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineFilter;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineFilterList;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineKeyValueFilter;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelinePrefixFilter;
import org.apache.hadoop.yarn.server.timelineservice.storage.TimelineReader;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={DocumentStoreFactory.class})
public class TestDocumentStoreTimelineReaderImpl {
    private final DocumentStoreReader<TimelineDocument> documentStoreReader = new DummyDocumentStoreReader<TimelineDocument>();
    private final List<TimelineEntity> entities = DocumentStoreTestUtils.bakeTimelineEntities();
    private final TimelineEntityDocument appTimelineEntity = DocumentStoreTestUtils.bakeTimelineEntityDoc();
    private final Configuration conf = new Configuration();
    private final TimelineReaderContext context = new TimelineReaderContext(null, null, null, Long.valueOf(1L), null, null, null);
    private final DocumentStoreTimelineReaderImpl timelineReader = new DocumentStoreTimelineReaderImpl();

    @Before
    public void setUp() throws YarnException {
        this.conf.set("yarn.timeline-service.document-store.db-name", "TestDB");
        this.conf.set("yarn.timeline-service.document-store.cosmos-db.endpoint", "https://localhost:443");
        this.conf.set("yarn.timeline-service.document-store.cosmos-db.masterkey", "1234567");
        PowerMockito.mockStatic(DocumentStoreFactory.class, (Class[])new Class[0]);
        PowerMockito.when((Object)DocumentStoreFactory.createDocumentStoreReader((Configuration)((Configuration)ArgumentMatchers.any(Configuration.class)))).thenReturn(this.documentStoreReader);
    }

    @Test(expected=YarnException.class)
    public void testFailOnNoCosmosDBConfigs() throws Exception {
        DocumentStoreUtils.validateCosmosDBConf((Configuration)new Configuration());
    }

    @Test
    public void testGetEntity() throws Exception {
        this.context.setEntityType(TimelineEntityType.YARN_APPLICATION.toString());
        this.timelineReader.serviceInit(this.conf);
        TimelineDataToRetrieve dataToRetrieve = new TimelineDataToRetrieve();
        EnumSet<TimelineReader.Field> fieldsToRetrieve = EnumSet.noneOf(TimelineReader.Field.class);
        dataToRetrieve.setFieldsToRetrieve(fieldsToRetrieve);
        TimelineEntity timelineEntity = this.timelineReader.getEntity(this.context, dataToRetrieve);
        Assert.assertEquals((long)this.appTimelineEntity.getCreatedTime(), (long)timelineEntity.getCreatedTime());
        Assert.assertEquals((long)0L, (long)timelineEntity.getMetrics().size());
        Assert.assertEquals((long)0L, (long)timelineEntity.getEvents().size());
        Assert.assertEquals((long)0L, (long)timelineEntity.getConfigs().size());
        Assert.assertEquals((long)this.appTimelineEntity.getInfo().size(), (long)timelineEntity.getInfo().size());
    }

    @Test
    public void testGetEntityCustomField() throws Exception {
        this.context.setEntityType(TimelineEntityType.YARN_CONTAINER.toString());
        this.timelineReader.serviceInit(this.conf);
        TimelineDataToRetrieve dataToRetrieve = new TimelineDataToRetrieve();
        dataToRetrieve.getFieldsToRetrieve().add(TimelineReader.Field.METRICS);
        TimelineEntity timelineEntity = this.timelineReader.getEntity(this.context, dataToRetrieve);
        Assert.assertEquals((long)this.appTimelineEntity.getCreatedTime(), (long)timelineEntity.getCreatedTime());
        Assert.assertEquals((long)this.appTimelineEntity.getMetrics().size(), (long)timelineEntity.getMetrics().size());
        Assert.assertEquals((long)0L, (long)timelineEntity.getEvents().size());
        Assert.assertEquals((long)0L, (long)timelineEntity.getConfigs().size());
        Assert.assertEquals((long)this.appTimelineEntity.getInfo().size(), (long)timelineEntity.getInfo().size());
    }

    @Test
    public void testGetEntityAllFields() throws Exception {
        this.context.setEntityType(TimelineEntityType.YARN_CONTAINER.toString());
        this.timelineReader.serviceInit(this.conf);
        TimelineDataToRetrieve dataToRetrieve = new TimelineDataToRetrieve();
        dataToRetrieve.getFieldsToRetrieve().add(TimelineReader.Field.ALL);
        TimelineEntity timelineEntity = this.timelineReader.getEntity(this.context, dataToRetrieve);
        Assert.assertEquals((long)this.appTimelineEntity.getCreatedTime(), (long)timelineEntity.getCreatedTime());
        Assert.assertEquals((long)this.appTimelineEntity.getMetrics().size(), (long)timelineEntity.getMetrics().size());
        Assert.assertEquals((long)this.appTimelineEntity.getEvents().size(), (long)timelineEntity.getEvents().size());
        Assert.assertEquals((long)this.appTimelineEntity.getConfigs().size(), (long)timelineEntity.getConfigs().size());
        Assert.assertEquals((long)this.appTimelineEntity.getInfo().size(), (long)timelineEntity.getInfo().size());
    }

    @Test
    public void testGetAllEntities() throws Exception {
        this.context.setEntityType(TimelineEntityType.YARN_CONTAINER.toString());
        this.timelineReader.serviceInit(this.conf);
        TimelineDataToRetrieve dataToRetrieve = new TimelineDataToRetrieve();
        dataToRetrieve.getFieldsToRetrieve().add(TimelineReader.Field.ALL);
        Set actualEntities = this.timelineReader.getEntities(this.context, new TimelineEntityFilters.Builder().build(), dataToRetrieve);
        Assert.assertEquals((long)this.entities.size(), (long)actualEntities.size());
    }

    @Test
    public void testGetEntitiesWithLimit() throws Exception {
        this.context.setEntityType(TimelineEntityType.YARN_CONTAINER.toString());
        this.timelineReader.serviceInit(this.conf);
        TimelineDataToRetrieve dataToRetrieve = new TimelineDataToRetrieve();
        Set actualEntities = this.timelineReader.getEntities(this.context, new TimelineEntityFilters.Builder().entityLimit(Long.valueOf(2L)).build(), dataToRetrieve);
        Assert.assertEquals((long)2L, (long)actualEntities.size());
    }

    @Test
    public void testGetEntitiesByWindows() throws Exception {
        this.context.setEntityType(TimelineEntityType.YARN_CONTAINER.toString());
        this.timelineReader.serviceInit(this.conf);
        TimelineDataToRetrieve dataToRetrieve = new TimelineDataToRetrieve();
        Set actualEntities = this.timelineReader.getEntities(this.context, new TimelineEntityFilters.Builder().createdTimeBegin(Long.valueOf(1533985554927L)).createTimeEnd(Long.valueOf(1533985554927L)).build(), dataToRetrieve);
        Assert.assertEquals((long)1L, (long)actualEntities.size());
    }

    @Test
    public void testGetFilteredEntities() throws Exception {
        this.context.setEntityType(TimelineEntityType.YARN_CONTAINER.toString());
        this.timelineReader.serviceInit(this.conf);
        TimelineDataToRetrieve dataToRetrieve = new TimelineDataToRetrieve();
        dataToRetrieve.getFieldsToRetrieve().add(TimelineReader.Field.ALL);
        TimelineFilterList infoFilterList = new TimelineFilterList();
        infoFilterList.addFilter((TimelineFilter)new TimelineKeyValueFilter(TimelineCompareOp.EQUAL, "YARN_APPLICATION_ATTEMPT_FINAL_STATUS", (Object)"SUCCEEDED"));
        Set actualEntities = this.timelineReader.getEntities(this.context, new TimelineEntityFilters.Builder().infoFilters(infoFilterList).build(), dataToRetrieve);
        Assert.assertEquals((long)1L, (long)actualEntities.size());
        for (Object entity : actualEntities) {
            if (entity.getType().equals("YARN_APPLICATION_ATTEMPT")) continue;
            Assert.fail((String)"Incorrect filtering based on info filters");
        }
        TimelineFilterList confFilterList = new TimelineFilterList();
        this.context.setEntityType(TimelineEntityType.YARN_APPLICATION.toString());
        confFilterList.addFilter((TimelineFilter)new TimelineKeyValueFilter(TimelineCompareOp.EQUAL, "YARN_AM_NODE_LABEL_EXPRESSION", (Object)"<DEFAULT_PARTITION>"));
        actualEntities = this.timelineReader.getEntities(this.context, new TimelineEntityFilters.Builder().configFilters(confFilterList).build(), dataToRetrieve);
        Assert.assertEquals((long)1L, (long)actualEntities.size());
        for (Object entity : actualEntities) {
            if (entity.getType().equals("YARN_APPLICATION")) continue;
            Assert.fail((String)"Incorrect filtering based on info filters");
        }
        this.context.setEntityType(TimelineEntityType.YARN_CONTAINER.toString());
        TimelineFilterList eventFilters = new TimelineFilterList();
        eventFilters.addFilter((TimelineFilter)new TimelineExistsFilter(TimelineCompareOp.EQUAL, "CONTAINER_LAUNCHED"));
        actualEntities = this.timelineReader.getEntities(this.context, new TimelineEntityFilters.Builder().eventFilters(eventFilters).build(), dataToRetrieve);
        Assert.assertEquals((long)1L, (long)actualEntities.size());
        for (TimelineEntity entity : actualEntities) {
            if (entity.getType().equals("YARN_CONTAINER")) continue;
            Assert.fail((String)"Incorrect filtering based on info filters");
        }
        TimelineFilterList metricFilterList = new TimelineFilterList();
        metricFilterList.addFilter((TimelineFilter)new TimelineCompareFilter(TimelineCompareOp.GREATER_OR_EQUAL, "MEMORY", (Object)150298624L));
        actualEntities = this.timelineReader.getEntities(this.context, new TimelineEntityFilters.Builder().metricFilters(metricFilterList).build(), dataToRetrieve);
        Assert.assertEquals((long)1L, (long)actualEntities.size());
        for (TimelineEntity entity : actualEntities) {
            if (entity.getType().equals("YARN_CONTAINER")) continue;
            Assert.fail((String)"Incorrect filtering based on info filters");
        }
    }

    @Test
    public void testReadingDifferentEntityTypes() throws Exception {
        this.timelineReader.serviceInit(this.conf);
        TimelineDataToRetrieve dataToRetrieve = new TimelineDataToRetrieve();
        this.context.setEntityType(TimelineEntityType.YARN_FLOW_ACTIVITY.toString());
        TimelineEntity timelineEntity = this.timelineReader.getEntity(this.context, dataToRetrieve);
        Assert.assertEquals((Object)TimelineEntityType.YARN_FLOW_ACTIVITY.toString(), (Object)timelineEntity.getType());
        this.context.setEntityType(TimelineEntityType.YARN_FLOW_RUN.toString());
        timelineEntity = this.timelineReader.getEntity(this.context, dataToRetrieve);
        Assert.assertEquals((Object)TimelineEntityType.YARN_FLOW_RUN.toString(), (Object)timelineEntity.getType());
        this.context.setEntityType(TimelineEntityType.YARN_APPLICATION.toString());
        timelineEntity = this.timelineReader.getEntity(this.context, dataToRetrieve);
        Assert.assertEquals((Object)TimelineEntityType.YARN_APPLICATION.toString(), (Object)timelineEntity.getType());
    }

    @Test
    public void testReadingAllEntityTypes() throws Exception {
        this.timelineReader.serviceInit(this.conf);
        this.context.setEntityType(TimelineEntityType.YARN_CONTAINER.toString());
        Set entityTypes = this.timelineReader.getEntityTypes(this.context);
        Assert.assertTrue((boolean)entityTypes.contains(TimelineEntityType.YARN_CONTAINER.toString()));
        Assert.assertTrue((boolean)entityTypes.contains(TimelineEntityType.YARN_APPLICATION_ATTEMPT.toString()));
    }

    @Test
    public void testMetricsToRetrieve() throws Exception {
        this.timelineReader.serviceInit(this.conf);
        TimelineDataToRetrieve dataToRetrieve = new TimelineDataToRetrieve();
        dataToRetrieve.getFieldsToRetrieve().add(TimelineReader.Field.METRICS);
        TimelineFilterList timelineFilterList = new TimelineFilterList();
        timelineFilterList.setOperator(TimelineFilterList.Operator.OR);
        timelineFilterList.addFilter((TimelineFilter)new TimelinePrefixFilter(TimelineCompareOp.EQUAL, "NOTHING"));
        dataToRetrieve.setMetricsToRetrieve(timelineFilterList);
        this.context.setEntityType(TimelineEntityType.YARN_APPLICATION.toString());
        TimelineEntity timelineEntity = this.timelineReader.getEntity(this.context, dataToRetrieve);
        Assert.assertEquals((long)0L, (long)timelineEntity.getMetrics().size());
        timelineFilterList.addFilter((TimelineFilter)new TimelinePrefixFilter(TimelineCompareOp.EQUAL, "YARN_APPLICATION_NON_AM_CONTAINER_PREEMPTED"));
        dataToRetrieve.setMetricsToRetrieve(timelineFilterList);
        this.context.setEntityType(TimelineEntityType.YARN_APPLICATION.toString());
        timelineEntity = this.timelineReader.getEntity(this.context, dataToRetrieve);
        Assert.assertTrue((timelineEntity.getMetrics().size() > 0 ? 1 : 0) != 0);
        timelineFilterList.setOperator(TimelineFilterList.Operator.AND);
        timelineEntity = this.timelineReader.getEntity(this.context, dataToRetrieve);
        Assert.assertEquals((long)0L, (long)timelineEntity.getMetrics().size());
        dataToRetrieve.getMetricsToRetrieve().getFilterList().remove(0);
        this.context.setEntityType(TimelineEntityType.YARN_APPLICATION.toString());
        timelineEntity = this.timelineReader.getEntity(this.context, dataToRetrieve);
        Assert.assertTrue((timelineEntity.getMetrics().size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testConfigsToRetrieve() throws Exception {
        this.timelineReader.serviceInit(this.conf);
        TimelineDataToRetrieve dataToRetrieve = new TimelineDataToRetrieve();
        dataToRetrieve.getFieldsToRetrieve().add(TimelineReader.Field.CONFIGS);
        TimelineFilterList timelineFilterList = new TimelineFilterList();
        timelineFilterList.setOperator(TimelineFilterList.Operator.OR);
        timelineFilterList.addFilter((TimelineFilter)new TimelinePrefixFilter(TimelineCompareOp.EQUAL, "NOTHING"));
        dataToRetrieve.setConfsToRetrieve(timelineFilterList);
        this.context.setEntityType(TimelineEntityType.YARN_APPLICATION.toString());
        TimelineEntity timelineEntity = this.timelineReader.getEntity(this.context, dataToRetrieve);
        Assert.assertEquals((long)0L, (long)timelineEntity.getConfigs().size());
        timelineFilterList.addFilter((TimelineFilter)new TimelinePrefixFilter(TimelineCompareOp.EQUAL, "YARN_AM_NODE_LABEL_EXPRESSION"));
        dataToRetrieve.setConfsToRetrieve(timelineFilterList);
        this.context.setEntityType(TimelineEntityType.YARN_APPLICATION.toString());
        timelineEntity = this.timelineReader.getEntity(this.context, dataToRetrieve);
        Assert.assertTrue((timelineEntity.getConfigs().size() > 0 ? 1 : 0) != 0);
        timelineFilterList.setOperator(TimelineFilterList.Operator.AND);
        timelineEntity = this.timelineReader.getEntity(this.context, dataToRetrieve);
        Assert.assertEquals((long)0L, (long)timelineEntity.getConfigs().size());
        dataToRetrieve.getConfsToRetrieve().getFilterList().remove(0);
        this.context.setEntityType(TimelineEntityType.YARN_APPLICATION.toString());
        timelineEntity = this.timelineReader.getEntity(this.context, dataToRetrieve);
        Assert.assertTrue((timelineEntity.getConfigs().size() > 0 ? 1 : 0) != 0);
    }
}

