/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.documentstore.reader.cosmosdb;

import com.microsoft.azure.cosmosdb.rx.AsyncDocumentClient;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.DocumentStoreUtils;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.reader.cosmosdb.CosmosDBDocumentStoreReader;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineReaderContext;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={DocumentStoreUtils.class})
public class TestCosmosDBDocumentStoreReader {
    @Before
    public void setUp() {
        AsyncDocumentClient asyncDocumentClient = (AsyncDocumentClient)Mockito.mock(AsyncDocumentClient.class);
        PowerMockito.mockStatic(DocumentStoreUtils.class, (Class[])new Class[0]);
        PowerMockito.when((Object)DocumentStoreUtils.getCosmosDBDatabaseName((Configuration)((Configuration)ArgumentMatchers.any(Configuration.class)))).thenReturn((Object)"FooBar");
        PowerMockito.when((Object)DocumentStoreUtils.createCosmosDBAsyncClient((Configuration)((Configuration)ArgumentMatchers.any(Configuration.class)))).thenReturn((Object)asyncDocumentClient);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFailureFOnEmptyPredicates() {
        PowerMockito.when((Object)DocumentStoreUtils.isNullOrEmpty((String[])((String[])ArgumentMatchers.any()))).thenReturn((Object)Boolean.TRUE);
        CosmosDBDocumentStoreReader cosmosDBDocumentStoreReader = new CosmosDBDocumentStoreReader(null);
        cosmosDBDocumentStoreReader.addPredicates(new TimelineReaderContext(null, "", "", null, "", "", null), "DummyCollection", new StringBuilder());
    }
}

