/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.documentstore;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.JsonUtils;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.collection.document.entity.TimelineEntityDocument;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.collection.document.flowactivity.FlowActivityDocument;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.collection.document.flowrun.FlowRunDocument;

public final class DocumentStoreTestUtils {
    private DocumentStoreTestUtils() {
    }

    public static List<TimelineEntity> bakeTimelineEntities() throws IOException {
        String jsonStr = IOUtils.toString((InputStream)DocumentStoreTestUtils.class.getClassLoader().getResourceAsStream("documents/timeline-entities.json"), (String)"UTF-8");
        return JsonUtils.fromJson(jsonStr, new TypeReference<List<TimelineEntity>>(){});
    }

    public static List<TimelineEntityDocument> bakeYarnAppTimelineEntities() throws IOException {
        String jsonStr = IOUtils.toString((InputStream)DocumentStoreTestUtils.class.getClassLoader().getResourceAsStream("documents/test-timeline-entities-doc.json"), (String)"UTF-8");
        return JsonUtils.fromJson(jsonStr, new TypeReference<List<TimelineEntityDocument>>(){});
    }

    public static TimelineEntityDocument bakeTimelineEntityDoc() throws IOException {
        String jsonStr = IOUtils.toString((InputStream)DocumentStoreTestUtils.class.getClassLoader().getResourceAsStream("documents/timeline-app-doc.json"), (String)"UTF-8");
        return JsonUtils.fromJson(jsonStr, new TypeReference<TimelineEntityDocument>(){});
    }

    public static FlowActivityDocument bakeFlowActivityDoc() throws IOException {
        String jsonStr = IOUtils.toString((InputStream)DocumentStoreTestUtils.class.getClassLoader().getResourceAsStream("documents/flowactivity-doc.json"), (String)"UTF-8");
        return JsonUtils.fromJson(jsonStr, new TypeReference<FlowActivityDocument>(){});
    }

    public static FlowRunDocument bakeFlowRunDoc() throws IOException {
        String jsonStr = IOUtils.toString((InputStream)DocumentStoreTestUtils.class.getClassLoader().getResourceAsStream("documents/flowrun-doc.json"), (String)"UTF-8");
        return JsonUtils.fromJson(jsonStr, new TypeReference<FlowRunDocument>(){});
    }
}

