/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timeline;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.timeline.LevelDBCacheTimelineStore;
import org.apache.hadoop.yarn.server.timeline.TimelineStore;
import org.apache.hadoop.yarn.server.timeline.TimelineStoreTestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestLevelDBCacheTimelineStore
extends TimelineStoreTestUtils {
    @BeforeEach
    public void setup() throws Exception {
        this.store = new LevelDBCacheTimelineStore("app1");
        this.store.init((Configuration)new YarnConfiguration());
        this.store.start();
        this.loadTestEntityData();
        this.loadVerificationEntityData();
        this.loadTestDomainData();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.store.stop();
    }

    public TimelineStore getTimelineStore() {
        return this.store;
    }

    @Test
    void testDefaultConstructor() {
        TimelineStore store = null;
        try {
            store = (TimelineStore)ReflectionUtils.newInstance(LevelDBCacheTimelineStore.class, (Configuration)new YarnConfiguration());
        }
        catch (Throwable throwable) {
            Assertions.assertNotNull(store, (String)"LevelDBCacheTimelineStore failed to instantiate");
            throw throwable;
        }
        Assertions.assertNotNull((Object)store, (String)"LevelDBCacheTimelineStore failed to instantiate");
    }

    @Test
    public void testGetSingleEntity() throws IOException {
        super.testGetSingleEntity();
    }

    @Test
    public void testGetEntities() throws IOException {
        super.testGetEntities();
    }

    @Test
    public void testGetEntitiesWithFromId() throws IOException {
        super.testGetEntitiesWithFromId();
    }

    @Test
    public void testGetEntitiesWithFromTs() throws IOException {
        super.testGetEntitiesWithFromTs();
    }

    @Test
    public void testGetEntitiesWithPrimaryFilters() throws IOException {
        super.testGetEntitiesWithPrimaryFilters();
    }

    @Test
    public void testGetEntitiesWithSecondaryFilters() throws IOException {
        super.testGetEntitiesWithSecondaryFilters();
    }

    @Test
    public void testGetEvents() throws IOException {
        super.testGetEvents();
    }

    @Test
    public void testGetDomain() throws IOException {
        super.testGetDomain();
    }

    @Test
    public void testGetDomains() throws IOException {
        super.testGetDomains();
    }
}

