/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.MiniYARNCluster;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestMiniYARNClusterForHA {
    MiniYARNCluster cluster;

    @BeforeEach
    public void setup() throws IOException, InterruptedException {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setBoolean("yarn.webapp.api-service.enable", false);
        conf.setBoolean("yarn.resourcemanager.ha.automatic-failover.enabled", false);
        conf.set("yarn.resourcemanager.webapp.address", "localhost:0");
        this.cluster = new MiniYARNCluster(TestMiniYARNClusterForHA.class.getName(), 2, 1, 1, 1);
        this.cluster.init((Configuration)conf);
        this.cluster.start();
        Assertions.assertFalse((-1 == this.cluster.getActiveRMIndex() ? 1 : 0) != 0, (String)"RM never turned active");
    }

    @Test
    void testClusterWorks() throws YarnException, InterruptedException {
        Assertions.assertTrue((boolean)this.cluster.waitForNodeManagersToConnect(5000L), (String)"NMs fail to connect to the RM");
    }
}

