/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.sharedcachemanager;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.yarn.client.SCMAdmin;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.server.api.SCMAdminProtocol;
import org.apache.hadoop.yarn.server.api.protocolrecords.RunSharedCacheCleanerTaskRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RunSharedCacheCleanerTaskResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.RunSharedCacheCleanerTaskResponsePBImpl;
import org.apache.hadoop.yarn.server.sharedcachemanager.CleanerService;
import org.apache.hadoop.yarn.server.sharedcachemanager.SCMAdminProtocolService;
import org.apache.hadoop.yarn.server.sharedcachemanager.store.InMemorySCMStore;
import org.apache.hadoop.yarn.server.sharedcachemanager.store.SCMStore;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestSCMAdminProtocolService {
    static SCMAdminProtocolService service;
    static SCMAdminProtocol SCMAdminProxy;
    static SCMAdminProtocol mockAdmin;
    static SCMAdmin adminCLI;
    static SCMStore store;
    static CleanerService cleaner;
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);

    @BeforeEach
    public void startUp() {
        Configuration conf = new Configuration();
        conf.set("yarn.sharedcache.store.class", InMemorySCMStore.class.getName());
        cleaner = (CleanerService)Mockito.mock(CleanerService.class);
        service = (SCMAdminProtocolService)Mockito.spy((Object)new SCMAdminProtocolService(cleaner));
        service.init(conf);
        service.start();
        YarnRPC rpc = YarnRPC.create((Configuration)new Configuration());
        InetSocketAddress scmAddress = conf.getSocketAddr("yarn.sharedcache.admin.address", "0.0.0.0:8047", 8047);
        SCMAdminProxy = (SCMAdminProtocol)rpc.getProxy(SCMAdminProtocol.class, scmAddress, conf);
        mockAdmin = (SCMAdminProtocol)Mockito.mock(SCMAdminProtocol.class);
        adminCLI = new SCMAdmin(new Configuration()){

            protected SCMAdminProtocol createSCMAdminProtocol() throws IOException {
                return mockAdmin;
            }
        };
    }

    @AfterEach
    public void cleanUpTest() {
        if (service != null) {
            service.stop();
        }
        if (SCMAdminProxy != null) {
            RPC.stopProxy((Object)SCMAdminProxy);
        }
    }

    @Test
    void testRunCleanerTask() throws Exception {
        ((CleanerService)Mockito.doNothing().when((Object)cleaner)).runCleanerTask();
        RunSharedCacheCleanerTaskRequest request = (RunSharedCacheCleanerTaskRequest)this.recordFactory.newRecordInstance(RunSharedCacheCleanerTaskRequest.class);
        RunSharedCacheCleanerTaskResponse response = SCMAdminProxy.runCleanerTask(request);
        Assertions.assertTrue((boolean)response.getAccepted(), (String)"cleaner task request isn't accepted");
        ((SCMAdminProtocolService)Mockito.verify((Object)service, (VerificationMode)Mockito.times((int)1))).runCleanerTask((RunSharedCacheCleanerTaskRequest)ArgumentMatchers.any(RunSharedCacheCleanerTaskRequest.class));
    }

    @Test
    void testRunCleanerTaskCLI() throws Exception {
        String[] args = new String[]{"-runCleanerTask"};
        RunSharedCacheCleanerTaskResponsePBImpl rp = new RunSharedCacheCleanerTaskResponsePBImpl();
        rp.setAccepted(true);
        Mockito.when((Object)mockAdmin.runCleanerTask((RunSharedCacheCleanerTaskRequest)ArgumentMatchers.isA(RunSharedCacheCleanerTaskRequest.class))).thenReturn((Object)rp);
        Assertions.assertEquals((int)0, (int)adminCLI.run(args));
        rp.setAccepted(false);
        Mockito.when((Object)mockAdmin.runCleanerTask((RunSharedCacheCleanerTaskRequest)ArgumentMatchers.isA(RunSharedCacheCleanerTaskRequest.class))).thenReturn((Object)rp);
        Assertions.assertEquals((int)1, (int)adminCLI.run(args));
        ((SCMAdminProtocol)Mockito.verify((Object)mockAdmin, (VerificationMode)Mockito.times((int)2))).runCleanerTask((RunSharedCacheCleanerTaskRequest)ArgumentMatchers.any(RunSharedCacheCleanerTaskRequest.class));
    }
}

