/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.sharedcachemanager.metrics;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.server.sharedcachemanager.metrics.CleanerMetrics;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestCleanerMetrics {
    Configuration conf = new Configuration();
    CleanerMetrics cleanerMetrics;

    @BeforeEach
    public void init() {
        this.cleanerMetrics = CleanerMetrics.getInstance();
    }

    @Test
    void testMetricsOverMultiplePeriods() {
        this.simulateACleanerRun();
        this.assertMetrics(4, 4, 1, 1);
        this.simulateACleanerRun();
        this.assertMetrics(4, 8, 1, 2);
    }

    public void simulateACleanerRun() {
        this.cleanerMetrics.reportCleaningStart();
        this.cleanerMetrics.reportAFileProcess();
        this.cleanerMetrics.reportAFileDelete();
        this.cleanerMetrics.reportAFileProcess();
        this.cleanerMetrics.reportAFileProcess();
    }

    void assertMetrics(int proc, int totalProc, int del, int totalDel) {
        Assertions.assertEquals((long)proc, (long)this.cleanerMetrics.getProcessedFiles(), (String)"Processed files in the last period are not measured correctly");
        Assertions.assertEquals((long)totalProc, (long)this.cleanerMetrics.getTotalProcessedFiles(), (String)"Total processed files are not measured correctly");
        Assertions.assertEquals((long)del, (long)this.cleanerMetrics.getDeletedFiles(), (String)"Deleted files in the last period are not measured correctly");
        Assertions.assertEquals((long)totalDel, (long)this.cleanerMetrics.getTotalDeletedFiles(), (String)"Total deleted files are not measured correctly");
    }
}

