/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.webapp;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fifo.FifoScheduler;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestRMWithXFSFilter {
    private static MockRM rm;

    private void createMockRm(Boolean xfsEnabled, String xfsHeaderValue) {
        Configuration conf = new Configuration();
        conf.setClass("yarn.resourcemanager.scheduler.class", FifoScheduler.class, ResourceScheduler.class);
        conf.setBoolean("mockrm.webapp.enabled", true);
        if (xfsEnabled != null) {
            conf.setBoolean("yarn.webapp.xfs-filter.enabled", xfsEnabled.booleanValue());
        }
        if (xfsHeaderValue != null) {
            conf.setStrings("yarn.resourcemanager.webapp.xfs-filter.xframe-options", new String[]{xfsHeaderValue});
        }
        rm = new MockRM(conf);
        rm.start();
    }

    @Test
    public void testXFrameOptionsDefaultBehaviour() throws Exception {
        this.createMockRm(null, null);
        URL url = new URL("http://localhost:8088/ws/v1/cluster/info");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        String xfoHeader = conn.getHeaderField("X-FRAME-OPTIONS");
        Assert.assertTrue((boolean)xfoHeader.endsWith(HttpServer2.XFrameOption.SAMEORIGIN.toString()));
    }

    @Test
    public void testXFrameOptionsExplicitlyEnabled() throws Exception {
        this.createMockRm(true, HttpServer2.XFrameOption.SAMEORIGIN.toString());
        URL url = new URL("http://localhost:8088/ws/v1/cluster/info");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        String xfoHeader = conn.getHeaderField("X-FRAME-OPTIONS");
        Assert.assertTrue((boolean)xfoHeader.endsWith(HttpServer2.XFrameOption.SAMEORIGIN.toString()));
    }

    @Test
    public void testXFrameOptionsEnabledDefaultApps() throws Exception {
        this.createMockRm(true, HttpServer2.XFrameOption.SAMEORIGIN.toString());
        URL url = new URL("http://localhost:8088/logs");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        String xfoHeader = conn.getHeaderField("X-FRAME-OPTIONS");
        Assert.assertTrue((boolean)xfoHeader.endsWith(HttpServer2.XFrameOption.SAMEORIGIN.toString()));
    }

    @Test
    public void testXFrameOptionsDisabled() throws Exception {
        this.createMockRm(false, null);
        URL url = new URL("http://localhost:8088/ws/v1/cluster/info");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        String xfoHeader = conn.getHeaderField("X-FRAME-OPTIONS");
        Assert.assertNull((String)"Unexpected X-FRAME-OPTION in header", (Object)xfoHeader);
    }

    @Test
    public void testXFrameOptionsIllegalOption() {
        IllegalArgumentException e = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> this.createMockRm(true, "otherValue"));
    }

    @After
    public void tearDown() throws IOException {
        rm.close();
    }
}

