/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp.dao;

import java.util.Collection;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PlacementManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairSchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.QueueManager;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.FairSchedulerQueueInfo;
import org.apache.hadoop.yarn.util.SystemClock;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestFairSchedulerQueueInfo {
    @Test
    public void testEmptyChildQueues() {
        FairSchedulerConfiguration fsConf = new FairSchedulerConfiguration();
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        PlacementManager placementManager = new PlacementManager();
        SystemClock clock = SystemClock.getInstance();
        FairScheduler scheduler = (FairScheduler)Mockito.mock(FairScheduler.class);
        Mockito.when((Object)scheduler.getConf()).thenReturn((Object)fsConf);
        Mockito.when((Object)scheduler.getConfig()).thenReturn((Object)fsConf);
        Mockito.when((Object)scheduler.getRMContext()).thenReturn((Object)rmContext);
        Mockito.when((Object)rmContext.getQueuePlacementManager()).thenReturn((Object)placementManager);
        Mockito.when((Object)scheduler.getClusterResource()).thenReturn((Object)Resource.newInstance((int)1, (int)1));
        Mockito.when((Object)scheduler.getResourceCalculator()).thenReturn((Object)new DefaultResourceCalculator());
        Mockito.when((Object)scheduler.getClock()).thenReturn((Object)clock);
        AllocationConfiguration allocConf = new AllocationConfiguration(scheduler);
        Mockito.when((Object)scheduler.getAllocationConfiguration()).thenReturn((Object)allocConf);
        QueueManager queueManager = new QueueManager(scheduler);
        queueManager.initialize();
        FSLeafQueue testQueue = queueManager.getLeafQueue("test", true);
        FairSchedulerQueueInfo queueInfo = new FairSchedulerQueueInfo((FSQueue)testQueue, scheduler);
        Collection childQueues = queueInfo.getChildQueues();
        Assert.assertNotNull((Object)childQueues);
        Assert.assertEquals((String)"Child QueueInfo was not empty", (long)0L, (long)childQueues.size());
    }
}

