/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import java.util.HashMap;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfigGeneratorForTest;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.TestWebServiceUtil;
import org.apache.hadoop.yarn.webapp.JerseyTestBase;
import org.junit.Test;

public class TestRMWebServicesCapacitySchedulerMixedMode
extends JerseyTestBase {
    private static final String EXPECTED_FILE_TMPL = "webapp/mixed-%s-%s.json";

    public TestRMWebServicesCapacitySchedulerMixedMode() {
        super(TestWebServiceUtil.createWebAppDescriptor());
    }

    @Test
    public void testSchedulerAbsoluteAndPercentage() throws Exception {
        HashMap<String, String> conf = new HashMap<String, String>();
        conf.put("yarn.scheduler.capacity.legacy-queue-mode.enabled", "false");
        conf.put("yarn.scheduler.capacity.root.queues", "default, test_1, test_2");
        conf.put("yarn.scheduler.capacity.root.test_1.queues", "test_1_1, test_1_2, test_1_3");
        conf.put("yarn.scheduler.capacity.root.default.capacity", "25");
        conf.put("yarn.scheduler.capacity.root.test_1.capacity", "[memory=16384, vcores=16]");
        conf.put("yarn.scheduler.capacity.root.test_2.capacity", "75");
        conf.put("yarn.scheduler.capacity.root.test_1.test_1_1.capacity", "[memory=2048, vcores=2]");
        conf.put("yarn.scheduler.capacity.root.test_1.test_1_2.capacity", "[memory=2048, vcores=2]");
        conf.put("yarn.scheduler.capacity.root.test_1.test_1_3.capacity", "100");
        try (MockRM rm = TestWebServiceUtil.createRM(CapacitySchedulerConfigGeneratorForTest.createConfiguration(conf));){
            TestWebServiceUtil.runTest(EXPECTED_FILE_TMPL, "testSchedulerAbsoluteAndPercentage", rm, this.resource());
        }
    }

    @Test
    public void testSchedulerAbsoluteAndPercentageUsingCapacityVector() throws Exception {
        HashMap<String, String> conf = new HashMap<String, String>();
        conf.put("yarn.scheduler.capacity.legacy-queue-mode.enabled", "false");
        conf.put("yarn.scheduler.capacity.root.queues", "default, test_1, test_2");
        conf.put("yarn.scheduler.capacity.root.test_1.queues", "test_1_1, test_1_2, test_1_3");
        conf.put("yarn.scheduler.capacity.root.default.capacity", "[memory=25%, vcores=25%]");
        conf.put("yarn.scheduler.capacity.root.test_1.capacity", "[memory=16384, vcores=16]");
        conf.put("yarn.scheduler.capacity.root.test_2.capacity", "[memory=75%, vcores=75%]");
        conf.put("yarn.scheduler.capacity.root.test_1.test_1_1.capacity", "[memory=2048, vcores=2]");
        conf.put("yarn.scheduler.capacity.root.test_1.test_1_2.capacity", "[memory=2048, vcores=2]");
        conf.put("yarn.scheduler.capacity.root.test_1.test_1_3.capacity", "[memory=100%, vcores=100%]");
        try (MockRM rm = TestWebServiceUtil.createRM(CapacitySchedulerConfigGeneratorForTest.createConfiguration(conf));){
            TestWebServiceUtil.runTest(EXPECTED_FILE_TMPL, "testSchedulerAbsoluteAndPercentage", rm, this.resource());
        }
    }

    @Test
    public void testSchedulerAbsoluteAndWeight() throws Exception {
        HashMap<String, String> conf = new HashMap<String, String>();
        conf.put("yarn.scheduler.capacity.legacy-queue-mode.enabled", "false");
        conf.put("yarn.scheduler.capacity.root.queues", "default, test_1, test_2");
        conf.put("yarn.scheduler.capacity.root.test_1.queues", "test_1_1, test_1_2, test_1_3");
        conf.put("yarn.scheduler.capacity.root.default.capacity", "1w");
        conf.put("yarn.scheduler.capacity.root.test_1.capacity", "[memory=16384, vcores=16]");
        conf.put("yarn.scheduler.capacity.root.test_2.capacity", "3w");
        conf.put("yarn.scheduler.capacity.root.test_1.test_1_1.capacity", "[memory=2048, vcores=2]");
        conf.put("yarn.scheduler.capacity.root.test_1.test_1_2.capacity", "[memory=2048, vcores=2]");
        conf.put("yarn.scheduler.capacity.root.test_1.test_1_3.capacity", "1w");
        try (MockRM rm = TestWebServiceUtil.createRM(CapacitySchedulerConfigGeneratorForTest.createConfiguration(conf));){
            TestWebServiceUtil.runTest(EXPECTED_FILE_TMPL, "testSchedulerAbsoluteAndWeight", rm, this.resource());
        }
    }

    @Test
    public void testSchedulerAbsoluteAndWeightUsingCapacityVector() throws Exception {
        HashMap<String, String> conf = new HashMap<String, String>();
        conf.put("yarn.scheduler.capacity.legacy-queue-mode.enabled", "false");
        conf.put("yarn.scheduler.capacity.root.queues", "default, test_1, test_2");
        conf.put("yarn.scheduler.capacity.root.test_1.queues", "test_1_1, test_1_2, test_1_3");
        conf.put("yarn.scheduler.capacity.root.default.capacity", "[memory=1w, vcores=1w]");
        conf.put("yarn.scheduler.capacity.root.test_1.capacity", "[memory=16384, vcores=16]");
        conf.put("yarn.scheduler.capacity.root.test_2.capacity", "[memory=3w, vcores=3w]");
        conf.put("yarn.scheduler.capacity.root.test_1.test_1_1.capacity", "[memory=2048, vcores=2]");
        conf.put("yarn.scheduler.capacity.root.test_1.test_1_2.capacity", "[memory=2048, vcores=2]");
        conf.put("yarn.scheduler.capacity.root.test_1.test_1_3.capacity", "[memory=1w, vcores=1w]");
        try (MockRM rm = TestWebServiceUtil.createRM(CapacitySchedulerConfigGeneratorForTest.createConfiguration(conf));){
            TestWebServiceUtil.runTest(EXPECTED_FILE_TMPL, "testSchedulerAbsoluteAndWeight", rm, this.resource());
        }
    }

    @Test
    public void testSchedulerPercentageAndWeight() throws Exception {
        HashMap<String, String> conf = new HashMap<String, String>();
        conf.put("yarn.scheduler.capacity.legacy-queue-mode.enabled", "false");
        conf.put("yarn.scheduler.capacity.root.queues", "default, test_1, test_2");
        conf.put("yarn.scheduler.capacity.root.test_1.queues", "test_1_1, test_1_2, test_1_3");
        conf.put("yarn.scheduler.capacity.root.default.capacity", "1w");
        conf.put("yarn.scheduler.capacity.root.test_1.capacity", "50");
        conf.put("yarn.scheduler.capacity.root.test_2.capacity", "3w");
        conf.put("yarn.scheduler.capacity.root.test_1.test_1_1.capacity", "12.5");
        conf.put("yarn.scheduler.capacity.root.test_1.test_1_2.capacity", "12.5");
        conf.put("yarn.scheduler.capacity.root.test_1.test_1_3.capacity", "1w");
        try (MockRM rm = TestWebServiceUtil.createRM(CapacitySchedulerConfigGeneratorForTest.createConfiguration(conf));){
            TestWebServiceUtil.runTest(EXPECTED_FILE_TMPL, "testSchedulerPercentageAndWeight", rm, this.resource());
        }
    }

    @Test
    public void testSchedulerPercentageAndWeightUsingCapacityVector() throws Exception {
        HashMap<String, String> conf = new HashMap<String, String>();
        conf.put("yarn.scheduler.capacity.legacy-queue-mode.enabled", "false");
        conf.put("yarn.scheduler.capacity.root.queues", "default, test_1, test_2");
        conf.put("yarn.scheduler.capacity.root.test_1.queues", "test_1_1, test_1_2, test_1_3");
        conf.put("yarn.scheduler.capacity.root.default.capacity", "[memory=1w, vcores=1w]");
        conf.put("yarn.scheduler.capacity.root.test_1.capacity", "[memory=50%, vcores=50%]");
        conf.put("yarn.scheduler.capacity.root.test_2.capacity", "[memory=3w, vcores=3w]");
        conf.put("yarn.scheduler.capacity.root.test_1.test_1_1.capacity", "[memory=12.5%, vcores=12.5%]");
        conf.put("yarn.scheduler.capacity.root.test_1.test_1_2.capacity", "[memory=12.5%, vcores=12.5%]");
        conf.put("yarn.scheduler.capacity.root.test_1.test_1_3.capacity", "[memory=1w, vcores=1w]");
        try (MockRM rm = TestWebServiceUtil.createRM(CapacitySchedulerConfigGeneratorForTest.createConfiguration(conf));){
            TestWebServiceUtil.runTest(EXPECTED_FILE_TMPL, "testSchedulerPercentageAndWeight", rm, this.resource());
        }
    }

    @Test
    public void testSchedulerAbsoluteAndPercentageAndWeight() throws Exception {
        HashMap<String, String> conf = new HashMap<String, String>();
        conf.put("yarn.scheduler.capacity.legacy-queue-mode.enabled", "false");
        conf.put("yarn.scheduler.capacity.root.queues", "default, test_1, test_2");
        conf.put("yarn.scheduler.capacity.root.test_1.queues", "test_1_1, test_1_2, test_1_3");
        conf.put("yarn.scheduler.capacity.root.default.capacity", "1w");
        conf.put("yarn.scheduler.capacity.root.test_1.capacity", "[memory=16384, vcores=16]");
        conf.put("yarn.scheduler.capacity.root.test_2.capacity", "75");
        conf.put("yarn.scheduler.capacity.root.test_1.test_1_1.capacity", "50");
        conf.put("yarn.scheduler.capacity.root.test_1.test_1_2.capacity", "1w");
        conf.put("yarn.scheduler.capacity.root.test_1.test_1_3.capacity", "[memory=12288, vcores=12]");
        try (MockRM rm = TestWebServiceUtil.createRM(CapacitySchedulerConfigGeneratorForTest.createConfiguration(conf));){
            TestWebServiceUtil.runTest(EXPECTED_FILE_TMPL, "testSchedulerAbsoluteAndPercentageAndWeight", rm, this.resource());
        }
    }

    @Test
    public void testSchedulerAbsoluteAndPercentageAndWeightUsingCapacityVector() throws Exception {
        HashMap<String, String> conf = new HashMap<String, String>();
        conf.put("yarn.scheduler.capacity.legacy-queue-mode.enabled", "false");
        conf.put("yarn.scheduler.capacity.root.queues", "default, test_1, test_2");
        conf.put("yarn.scheduler.capacity.root.test_1.queues", "test_1_1, test_1_2, test_1_3");
        conf.put("yarn.scheduler.capacity.root.default.capacity", "[memory=1w, vcores=1w]");
        conf.put("yarn.scheduler.capacity.root.test_1.capacity", "[memory=16384, vcores=16]");
        conf.put("yarn.scheduler.capacity.root.test_2.capacity", "[memory=75%, vcores=75%]");
        conf.put("yarn.scheduler.capacity.root.test_1.test_1_1.capacity", "[memory=50%, vcores=50%]");
        conf.put("yarn.scheduler.capacity.root.test_1.test_1_2.capacity", "[memory=1w, vcores=1w]");
        conf.put("yarn.scheduler.capacity.root.test_1.test_1_3.capacity", "[memory=12288, vcores=12]");
        try (MockRM rm = TestWebServiceUtil.createRM(CapacitySchedulerConfigGeneratorForTest.createConfiguration(conf));){
            TestWebServiceUtil.runTest(EXPECTED_FILE_TMPL, "testSchedulerAbsoluteAndPercentageAndWeight", rm, this.resource());
        }
    }

    @Test
    public void testSchedulerAbsoluteAndPercentageAndWeightMixed() throws Exception {
        HashMap<String, String> conf = new HashMap<String, String>();
        conf.put("yarn.scheduler.capacity.legacy-queue-mode.enabled", "false");
        conf.put("yarn.scheduler.capacity.root.queues", "default, test_1, test_2");
        conf.put("yarn.scheduler.capacity.root.test_1.queues", "test_1_1, test_1_2, test_1_3");
        conf.put("yarn.scheduler.capacity.root.default.capacity", "[memory=1w, vcores=4]");
        conf.put("yarn.scheduler.capacity.root.test_1.capacity", "[memory=16384, vcores=100%]");
        conf.put("yarn.scheduler.capacity.root.test_2.capacity", "[memory=3w, vcores=12]");
        conf.put("yarn.scheduler.capacity.root.test_1.test_1_1.capacity", "[memory=1w, vcores=1w]");
        conf.put("yarn.scheduler.capacity.root.test_1.test_1_2.capacity", "[memory=50%, vcores=2]");
        conf.put("yarn.scheduler.capacity.root.test_1.test_1_3.capacity", "[memory=12288, vcores=86%]");
        try (MockRM rm = TestWebServiceUtil.createRM(CapacitySchedulerConfigGeneratorForTest.createConfiguration(conf));){
            TestWebServiceUtil.runTest(EXPECTED_FILE_TMPL, "testSchedulerAbsoluteAndPercentageAndWeightMixed", rm, this.resource());
        }
    }
}

