/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.sun.jersey.api.client.ClientResponse;
import java.util.Arrays;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmissionData;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmitter;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.TestRMWebServices;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.TestWebServiceUtil;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.apache.hadoop.yarn.webapp.JerseyTestBase;
import org.codehaus.jettison.json.JSONObject;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestRMWebServicesCapacitySched
extends JerseyTestBase {
    private final boolean legacyQueueMode;

    @Parameterized.Parameters(name="{index}: legacy-queue-mode={0}")
    public static Collection<Boolean> getParameters() {
        return Arrays.asList(true, false);
    }

    public TestRMWebServicesCapacitySched(boolean legacyQueueMode) {
        super(TestWebServiceUtil.createWebAppDescriptor());
        this.legacyQueueMode = legacyQueueMode;
    }

    @Test
    public void testClusterScheduler() throws Exception {
        try (MockRM rm = TestWebServiceUtil.createRM(this.createConfig());){
            rm.registerNode("h1:1234", 32768, 32);
            TestWebServiceUtil.assertJsonResponse((ClientResponse)this.resource().path("ws/v1/cluster/scheduler").accept(new String[]{"application/json"}).get(ClientResponse.class), "webapp/scheduler-response.json");
            TestWebServiceUtil.assertJsonResponse((ClientResponse)this.resource().path("ws/v1/cluster/scheduler/").accept(new String[]{"application/json"}).get(ClientResponse.class), "webapp/scheduler-response.json");
            TestWebServiceUtil.assertJsonResponse((ClientResponse)this.resource().path("ws/v1/cluster/scheduler").get(ClientResponse.class), "webapp/scheduler-response.json");
            TestWebServiceUtil.assertXmlResponse((ClientResponse)this.resource().path("ws/v1/cluster/scheduler/").accept(new String[]{"application/xml"}).get(ClientResponse.class), "webapp/scheduler-response.xml");
        }
    }

    @Test
    public void testPerUserResources() throws Exception {
        try (MockRM rm = TestWebServiceUtil.createRM(this.createConfig());){
            rm.registerNode("h1:1234", 32768, 32);
            MockRMAppSubmitter.submit(rm, MockRMAppSubmissionData.Builder.createWithMemory(32L, rm).withAppName("app1").withUser("user1").withAcls(null).withQueue("a").withUnmanagedAM(false).build());
            MockRMAppSubmitter.submit(rm, MockRMAppSubmissionData.Builder.createWithMemory(64L, rm).withAppName("app2").withUser("user2").withAcls(null).withQueue("b").withUnmanagedAM(false).build());
            TestWebServiceUtil.assertXmlResponse((ClientResponse)this.resource().path("ws/v1/cluster/scheduler").accept(new String[]{"application/xml"}).get(ClientResponse.class), "webapp/scheduler-response-PerUserResources.xml");
            TestWebServiceUtil.assertJsonResponse((ClientResponse)this.resource().path("ws/v1/cluster/scheduler").accept(new String[]{"application/json"}).get(ClientResponse.class), "webapp/scheduler-response-PerUserResources.json");
        }
    }

    @Test
    public void testNodeLabelDefaultAPI() throws Exception {
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration(this.createConfig());
        conf.setDefaultNodeLabelExpression("root", "ROOT-INHERITED");
        conf.setDefaultNodeLabelExpression("root.a", "root-a-default-label");
        try (MockRM rm = TestWebServiceUtil.createRM((Configuration)conf);){
            rm.registerNode("h1:1234", 32768, 32);
            ClientResponse response = (ClientResponse)this.resource().path("ws/v1/cluster/scheduler").accept(new String[]{"application/xml"}).get(ClientResponse.class);
            TestWebServiceUtil.assertXmlResponse(response, "webapp/scheduler-response-NodeLabelDefaultAPI.xml");
        }
    }

    @Test
    public void testClusterSchedulerOverviewCapacity() throws Exception {
        try (MockRM rm = TestWebServiceUtil.createRM(this.createConfig());){
            rm.registerNode("h1:1234", 32768, 32);
            ClientResponse response = (ClientResponse)this.resource().path("ws/v1/cluster/scheduler-overview").accept(new String[]{"application/json"}).get(ClientResponse.class);
            TestWebServiceUtil.assertJsonType(response);
            JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
            TestRMWebServices.verifyClusterSchedulerOverView(json, "Capacity Scheduler");
        }
    }

    @Test
    public void testResourceInfo() {
        Resource res = Resources.createResource((int)10, (int)1);
        Assert.assertEquals((Object)"<memory:10, vCores:1>", (Object)res.toString());
    }

    private Configuration createConfig() {
        Configuration conf = new Configuration();
        conf.set("yarn.scheduler.capacity.legacy-queue-mode.enabled", String.valueOf(this.legacyQueueMode));
        conf.set("yarn.scheduler.capacity.root.queues", "a, b, c");
        conf.set("yarn.scheduler.capacity.root.a.capacity", "12.5");
        conf.set("yarn.scheduler.capacity.root.a.accessible-node-labels", "root-a-default-label");
        conf.set("yarn.scheduler.capacity.root.a.maximum-capacity", "50");
        conf.set("yarn.scheduler.capacity.root.a.max-parallel-app", "42");
        conf.set("yarn.scheduler.capacity.root.b.capacity", "50");
        conf.set("yarn.scheduler.capacity.root.c.capacity", "37.5");
        return conf;
    }
}

