/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.volume.csi;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableSet;
import org.apache.hadoop.yarn.api.CsiAdaptorProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ResourceTypes;
import org.apache.hadoop.yarn.api.protocolrecords.ValidateVolumeCapabilitiesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ValidateVolumeCapabilitiesResponse;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.api.records.ResourceSizing;
import org.apache.hadoop.yarn.api.records.SchedulingRequest;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmissionData;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmitter;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.NullRMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.volume.csi.VolumeStates;
import org.apache.hadoop.yarn.server.resourcemanager.volume.csi.lifecycle.Volume;
import org.apache.hadoop.yarn.server.resourcemanager.volume.csi.lifecycle.VolumeState;
import org.apache.hadoop.yarn.server.resourcemanager.volume.csi.processor.VolumeAMSProcessor;
import org.apache.hadoop.yarn.server.volume.csi.VolumeId;
import org.apache.hadoop.yarn.server.volume.csi.exception.InvalidVolumeException;
import org.apache.hadoop.yarn.server.volume.csi.exception.VolumeException;
import org.apache.hadoop.yarn.server.volume.csi.exception.VolumeProvisioningException;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestVolumeProcessor {
    private static final int GB = 1024;
    private YarnConfiguration conf;
    private RMNodeLabelsManager mgr;
    private MockRM rm;
    private MockNM[] mockNMS;
    private RMNode[] rmNodes;
    private static final int NUM_OF_NMS = 4;
    private File resourceTypesFile = null;
    private static final String VOLUME_RESOURCE_NAME = "yarn.io/csi-volume";

    @Before
    public void setUp() throws Exception {
        this.conf = new YarnConfiguration();
        this.resourceTypesFile = new File(this.conf.getClassLoader().getResource(".").getPath(), "resource-types.xml");
        this.writeTmpResourceTypesFile(this.resourceTypesFile);
        this.conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        this.conf.set("yarn.resourcemanager.placement-constraints.handler", "scheduler");
        this.conf.set("yarn.scheduler.capacity.resource-calculator", "org.apache.hadoop.yarn.util.resource.DominantResourceCalculator");
        this.conf.set("yarn.scheduler.capacity.root.default.ordering-policy", "fair");
        this.conf.set("yarn.resourcemanager.application-master-service.processors", VolumeAMSProcessor.class.getName());
        this.mgr = new NullRMNodeLabelsManager();
        this.mgr.init((Configuration)this.conf);
        this.rm = new MockRM((Configuration)this.conf){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestVolumeProcessor.this.mgr;
            }
        };
        this.rm.getRMContext().setNodeLabelManager(this.mgr);
        this.rm.start();
        this.mockNMS = new MockNM[4];
        this.rmNodes = new RMNode[4];
        for (int i = 0; i < 4; ++i) {
            this.mockNMS[i] = this.rm.registerNode("192.168.0." + i + ":1234", 10240);
            this.rmNodes[i] = (RMNode)this.rm.getRMContext().getRMNodes().get(this.mockNMS[i].getNodeId());
        }
    }

    @After
    public void tearDown() {
        if (this.resourceTypesFile != null && this.resourceTypesFile.exists()) {
            this.resourceTypesFile.delete();
        }
    }

    private void writeTmpResourceTypesFile(File tmpFile) throws IOException {
        YarnConfiguration yarnConf = new YarnConfiguration();
        yarnConf.set("yarn.resource-types", VOLUME_RESOURCE_NAME);
        yarnConf.set("yarn.resource-types.yarn.io/csi-volume.units", "Mi");
        yarnConf.set("yarn.resource-types.yarn.io/csi-volume.tags", "system:csi-volume");
        try (FileWriter fw = new FileWriter(tmpFile);){
            yarnConf.writeXml((Writer)fw);
        }
    }

    @Test(timeout=10000L)
    public void testVolumeProvisioning() throws Exception {
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, this.rm).withAppName("app").withUser("user").withAcls(null).withQueue("default").withUnmanagedAM(false).build();
        RMApp app1 = MockRMAppSubmitter.submit(this.rm, data);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, this.rm, this.mockNMS[0]);
        Resource resource = Resource.newInstance((int)1024, (int)1);
        ResourceInformation volumeResource = ResourceInformation.newInstance((String)VOLUME_RESOURCE_NAME, (String)"Mi", (long)1024L, (ResourceTypes)ResourceTypes.COUNTABLE, (long)0L, (long)Long.MAX_VALUE, (Set)ImmutableSet.of((Object)"system:csi-volume"), (Map)ImmutableMap.of((Object)"volume.id", (Object)"test-vol-000001", (Object)"driver.name", (Object)"hostpath", (Object)"volume.mount", (Object)"/mnt/data"));
        resource.setResourceInformation(VOLUME_RESOURCE_NAME, volumeResource);
        SchedulingRequest sc = SchedulingRequest.newBuilder().allocationRequestId(0L).resourceSizing(ResourceSizing.newInstance((int)1, (Resource)resource)).build();
        AllocateRequest ar = AllocateRequest.newBuilder().schedulingRequests(Arrays.asList(sc)).build();
        CsiAdaptorProtocol mockedClient = (CsiAdaptorProtocol)Mockito.mock(CsiAdaptorProtocol.class);
        this.rm.getRMContext().getVolumeManager().registerCsiDriverAdaptor("hostpath", mockedClient);
        ((CsiAdaptorProtocol)Mockito.doReturn((Object)ValidateVolumeCapabilitiesResponse.newInstance((boolean)true, (String)"")).when((Object)mockedClient)).validateVolumeCapacity((ValidateVolumeCapabilitiesRequest)ArgumentMatchers.any(ValidateVolumeCapabilitiesRequest.class));
        am1.allocate(ar);
        VolumeStates volumeStates = this.rm.getRMContext().getVolumeManager().getVolumeStates();
        Assert.assertNotNull((Object)volumeStates);
        VolumeState volumeState = VolumeState.NEW;
        while (volumeState != VolumeState.NODE_READY) {
            Volume volume = volumeStates.getVolume(new VolumeId("test-vol-000001"));
            if (volume != null) {
                volumeState = volume.getVolumeState();
            }
            am1.doHeartbeat();
            this.mockNMS[0].nodeHeartbeat(true);
            Thread.sleep(500L);
        }
        this.rm.stop();
    }

    @Test(timeout=30000L)
    public void testInvalidRequest() throws Exception {
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, this.rm).withAppName("app").withUser("user").withAcls(null).withQueue("default").withUnmanagedAM(false).build();
        RMApp app1 = MockRMAppSubmitter.submit(this.rm, data);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, this.rm, this.mockNMS[0]);
        Resource resource = Resource.newInstance((int)1024, (int)1);
        ResourceInformation volumeResource = ResourceInformation.newInstance((String)VOLUME_RESOURCE_NAME, (String)"Mi", (long)1024L, (ResourceTypes)ResourceTypes.COUNTABLE, (long)0L, (long)Long.MAX_VALUE, (Set)ImmutableSet.of((Object)"system:csi-volume"), (Map)ImmutableMap.of((Object)"volume.name", (Object)"test-vol-000001", (Object)"driver.name", (Object)"hostpath", (Object)"volume.mount", (Object)"/mnt/data"));
        resource.setResourceInformation(VOLUME_RESOURCE_NAME, volumeResource);
        SchedulingRequest sc = SchedulingRequest.newBuilder().allocationRequestId(0L).resourceSizing(ResourceSizing.newInstance((int)1, (Resource)resource)).build();
        AllocateRequest ar = AllocateRequest.newBuilder().schedulingRequests(Arrays.asList(sc)).build();
        try {
            am1.allocate(ar);
            Assert.fail((String)"allocate should fail because invalid request received");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof InvalidVolumeException));
        }
        this.rm.stop();
    }

    @Test(timeout=30000L)
    public void testProvisioningFailures() throws Exception {
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, this.rm).withAppName("app").withUser("user").withAcls(null).withQueue("default").withUnmanagedAM(false).build();
        RMApp app1 = MockRMAppSubmitter.submit(this.rm, data);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, this.rm, this.mockNMS[0]);
        CsiAdaptorProtocol mockedClient = (CsiAdaptorProtocol)Mockito.mock(CsiAdaptorProtocol.class);
        this.rm.getRMContext().getVolumeManager().registerCsiDriverAdaptor("hostpath", mockedClient);
        ((CsiAdaptorProtocol)Mockito.doThrow((Throwable[])new Throwable[]{new VolumeException("failed")}).when((Object)mockedClient)).validateVolumeCapacity((ValidateVolumeCapabilitiesRequest)ArgumentMatchers.any(ValidateVolumeCapabilitiesRequest.class));
        Resource resource = Resource.newInstance((int)1024, (int)1);
        ResourceInformation volumeResource = ResourceInformation.newInstance((String)VOLUME_RESOURCE_NAME, (String)"Mi", (long)1024L, (ResourceTypes)ResourceTypes.COUNTABLE, (long)0L, (long)Long.MAX_VALUE, (Set)ImmutableSet.of((Object)"system:csi-volume"), (Map)ImmutableMap.of((Object)"volume.id", (Object)"test-vol-000001", (Object)"driver.name", (Object)"hostpath", (Object)"volume.mount", (Object)"/mnt/data"));
        resource.setResourceInformation(VOLUME_RESOURCE_NAME, volumeResource);
        SchedulingRequest sc = SchedulingRequest.newBuilder().allocationRequestId(0L).resourceSizing(ResourceSizing.newInstance((int)1, (Resource)resource)).build();
        AllocateRequest ar = AllocateRequest.newBuilder().schedulingRequests(Arrays.asList(sc)).build();
        try {
            am1.allocate(ar);
            Assert.fail((String)"allocate should fail");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof VolumeProvisioningException));
        }
        this.rm.stop();
    }

    @Test(timeout=10000L)
    public void testVolumeResourceAllocate() throws Exception {
        RMApp app1 = MockRMAppSubmitter.submit(this.rm, MockRMAppSubmissionData.Builder.createWithMemory(1024L, this.rm).withAppName("app").withUser("user").withAcls(null).withQueue("default").build());
        MockAM am1 = MockRM.launchAndRegisterAM(app1, this.rm, this.mockNMS[0]);
        Resource resource = Resource.newInstance((int)1024, (int)1);
        ResourceInformation volumeResource = ResourceInformation.newInstance((String)VOLUME_RESOURCE_NAME, (String)"Mi", (long)1024L, (ResourceTypes)ResourceTypes.COUNTABLE, (long)0L, (long)Long.MAX_VALUE, (Set)ImmutableSet.of((Object)"system:csi-volume"), (Map)ImmutableMap.of((Object)"volume.id", (Object)"test-vol-000001", (Object)"driver.name", (Object)"hostpath", (Object)"volume.mount", (Object)"/mnt/data"));
        resource.setResourceInformation(VOLUME_RESOURCE_NAME, volumeResource);
        SchedulingRequest sc = SchedulingRequest.newBuilder().allocationRequestId(0L).resourceSizing(ResourceSizing.newInstance((int)1, (Resource)resource)).build();
        CsiAdaptorProtocol mockedClient = (CsiAdaptorProtocol)Mockito.mock(CsiAdaptorProtocol.class);
        this.rm.getRMContext().getVolumeManager().registerCsiDriverAdaptor("hostpath", mockedClient);
        ((CsiAdaptorProtocol)Mockito.doReturn((Object)ValidateVolumeCapabilitiesResponse.newInstance((boolean)true, (String)"")).when((Object)mockedClient)).validateVolumeCapacity((ValidateVolumeCapabilitiesRequest)ArgumentMatchers.any(ValidateVolumeCapabilitiesRequest.class));
        am1.addSchedulingRequest((List<SchedulingRequest>)ImmutableList.of((Object)sc));
        ArrayList allocated = new ArrayList();
        while (allocated.size() != 1) {
            AllocateResponse response = am1.schedule();
            this.mockNMS[0].nodeHeartbeat(true);
            allocated.addAll(response.getAllocatedContainers());
            Thread.sleep(500L);
        }
        Assert.assertEquals((long)1L, (long)allocated.size());
        Container alloc = (Container)allocated.get(0);
        Assertions.assertThat((long)alloc.getResource().getMemorySize()).isEqualTo(1024L);
        Assertions.assertThat((int)alloc.getResource().getVirtualCores()).isEqualTo(1);
        ResourceInformation allocatedVolume = alloc.getResource().getResourceInformation(VOLUME_RESOURCE_NAME);
        Assert.assertNotNull((Object)allocatedVolume);
        Assertions.assertThat((long)allocatedVolume.getValue()).isEqualTo(1024L);
        Assertions.assertThat((String)allocatedVolume.getUnits()).isEqualTo((Object)"Mi");
        this.rm.stop();
    }
}

