/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.security;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.User;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.rpcauth.KerberosAuthMethod;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.yarn.api.protocolrecords.GetDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetDelegationTokenResponse;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.MockMemoryRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMSecretManagerService;
import org.apache.hadoop.yarn.server.resourcemanager.TestRMRestart;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.MemoryRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMDelegationTokenSecretManager;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.event.Level;

public class TestRMDelegationTokens {
    private YarnConfiguration testConf;

    @Before
    public void setup() {
        GenericTestUtils.setRootLogLevel((Level)Level.DEBUG);
        ExitUtil.disableSystemExit();
        this.testConf = new YarnConfiguration();
        this.testConf.set("yarn.resourcemanager.store.class", MemoryRMStateStore.class.getName());
        UserGroupInformation.setLoginUser(null);
        UserGroupInformation.setConfiguration((Configuration)this.testConf);
    }

    private static void assertMasterKeysAreSaved(Set<DelegationKey> rmDTMasterKeyState, RMDelegationTokenSecretManager dtSecretManager) {
        dtSecretManager.getAllMasterKeys().forEach(managerKey -> {
            int keyId = managerKey.getKeyId();
            boolean found = false;
            for (DelegationKey stateKey : rmDTMasterKeyState) {
                if (stateKey.getKeyId() != keyId) continue;
                found = true;
                break;
            }
            Assert.assertTrue((String)("Master key not found: " + keyId), (boolean)found);
        });
    }

    @Test(timeout=15000L)
    public void testRMDTMasterKeyStateOnRollingMasterKey() throws Exception {
        Configuration conf = new Configuration((Configuration)this.testConf);
        conf.set("hadoop.security.authentication", "kerberos");
        conf.set("hadoop.security.custom.auth.principal.class", User.class.getName());
        conf.set("hadoop.security.custom.rpc.auth.method.class", KerberosAuthMethod.class.getName());
        UserGroupInformation.setConfiguration((Configuration)conf);
        UserGroupInformation.getLoginUser().setAuthenticationMethod(UserGroupInformation.AuthenticationMethod.KERBEROS);
        MockMemoryRMStateStore memStore = new MockMemoryRMStateStore();
        memStore.init(conf);
        RMStateStore.RMState rmState = memStore.getState();
        Map rmDTState = rmState.getRMDTSecretManagerState().getTokenState();
        Set rmDTMasterKeyState = rmState.getRMDTSecretManagerState().getMasterKeyState();
        MyMockRM rm1 = new MyMockRM(conf, (RMStateStore)memStore);
        rm1.start();
        RMDelegationTokenSecretManager dtSecretManager = rm1.getRMContext().getRMDelegationTokenSecretManager();
        TestRMDelegationTokens.assertMasterKeysAreSaved(rmDTMasterKeyState, dtSecretManager);
        GetDelegationTokenRequest request = (GetDelegationTokenRequest)Mockito.mock(GetDelegationTokenRequest.class);
        Mockito.when((Object)request.getRenewer()).thenReturn((Object)"renewer1");
        GetDelegationTokenResponse response = rm1.getClientRMService().getDelegationToken(request);
        org.apache.hadoop.yarn.api.records.Token delegationToken = response.getRMDelegationToken();
        Token token1 = ConverterUtils.convertFromYarn((org.apache.hadoop.yarn.api.records.Token)delegationToken, (Text)null);
        RMDelegationTokenIdentifier dtId1 = (RMDelegationTokenIdentifier)token1.decodeIdentifier();
        while (((TestRMDelegationTokenSecretManager)dtSecretManager).numUpdatedKeys.get() < 3) {
            ((TestRMDelegationTokenSecretManager)dtSecretManager).checkCurrentKeyInStateStore(rmDTMasterKeyState);
            Thread.sleep(100L);
        }
        for (int count = 0; rmDTState.containsKey(dtId1) && count < 100; ++count) {
            Thread.sleep(100L);
        }
        rm1.stop();
    }

    @Test(timeout=15000L)
    public void testRemoveExpiredMasterKeyInRMStateStore() throws Exception {
        MockMemoryRMStateStore memStore = new MockMemoryRMStateStore();
        memStore.init((Configuration)this.testConf);
        RMStateStore.RMState rmState = memStore.getState();
        Set rmDTMasterKeyState = rmState.getRMDTSecretManagerState().getMasterKeyState();
        MyMockRM rm1 = new MyMockRM((Configuration)this.testConf, (RMStateStore)memStore);
        rm1.start();
        RMDelegationTokenSecretManager dtSecretManager = rm1.getRMContext().getRMDelegationTokenSecretManager();
        TestRMDelegationTokens.assertMasterKeysAreSaved(rmDTMasterKeyState, dtSecretManager);
        HashSet expiringKeys = new HashSet();
        expiringKeys.addAll(dtSecretManager.getAllMasterKeys());
        while (true) {
            boolean allExpired = true;
            for (DelegationKey key : expiringKeys) {
                if (!rmDTMasterKeyState.contains(key)) continue;
                allExpired = false;
            }
            if (allExpired) break;
            Thread.sleep(500L);
        }
        rm1.stop();
    }

    @Test(timeout=15000L)
    public void testUnknownKeyTokensOnRecover() throws Exception {
        int masterID = 1234;
        int sequenceNumber = 1000;
        MockMemoryRMStateStore memStore = new MockMemoryRMStateStore();
        memStore.init((Configuration)this.testConf);
        MyMockRM rm1 = new MyMockRM((Configuration)this.testConf, (RMStateStore)memStore);
        rm1.start();
        RMDelegationTokenSecretManager dtSecretManager = rm1.getRMContext().getRMDelegationTokenSecretManager();
        final RMStateStore.RMState rmState = memStore.getState();
        final RMDelegationTokenIdentifier rmDT = new RMDelegationTokenIdentifier(new Text("owner"), new Text("renewer"), new Text("realuser"));
        rmDT.setMasterKeyId(1234);
        rmDT.setSequenceNumber(1000);
        long tokenTime = Time.now() + 60000L;
        rmDT.setMaxDate(tokenTime);
        dtSecretManager.storeNewToken(rmDT, tokenTime);
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return rmState.getRMDTSecretManagerState().getTokenState().containsKey(rmDT);
            }
        }, (long)10L, (long)2000L);
        dtSecretManager.stopThreads();
        dtSecretManager.reset();
        Assert.assertEquals((String)"Secret manager should have no tokens", (long)dtSecretManager.getAllTokens().size(), (long)0L);
        Assert.assertEquals((String)"Secret manager should have no keys", (long)dtSecretManager.getAllMasterKeys().size(), (long)0L);
        dtSecretManager.recover(rmState);
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return rmState.getRMDTSecretManagerState().getTokenState().containsKey(rmDT);
            }
        }, (long)10L, (long)2000L);
        Assert.assertEquals((String)"Token should have been expired but is not", (long)0L, (long)dtSecretManager.getRenewDate(rmDT));
        dtSecretManager.startThreads();
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return !rmState.getRMDTSecretManagerState().getTokenState().containsKey(rmDT);
            }
        }, (long)10L, (long)2000L);
        rm1.stop();
    }

    public class TestRMDelegationTokenSecretManager
    extends RMDelegationTokenSecretManager {
        public AtomicInteger numUpdatedKeys;

        public TestRMDelegationTokenSecretManager(long delegationKeyUpdateInterval, long delegationTokenMaxLifetime, long delegationTokenRenewInterval, long delegationTokenRemoverScanInterval, RMContext rmContext) {
            super(delegationKeyUpdateInterval, delegationTokenMaxLifetime, delegationTokenRenewInterval, delegationTokenRemoverScanInterval, rmContext);
            this.numUpdatedKeys = new AtomicInteger(0);
        }

        protected void storeNewMasterKey(DelegationKey newKey) {
            super.storeNewMasterKey(newKey);
            this.numUpdatedKeys.incrementAndGet();
        }

        public synchronized DelegationKey checkCurrentKeyInStateStore(Set<DelegationKey> rmDTMasterKeyState) {
            Iterator iterator = this.allKeys.keySet().iterator();
            while (iterator.hasNext()) {
                int keyId = (Integer)iterator.next();
                if (keyId != this.currentId) continue;
                DelegationKey currentKey = (DelegationKey)this.allKeys.get(keyId);
                boolean found = false;
                for (DelegationKey k : rmDTMasterKeyState) {
                    if (k.getKeyId() != keyId) continue;
                    found = true;
                    break;
                }
                Assert.assertTrue((boolean)found);
                return currentKey;
            }
            return null;
        }
    }

    class MyMockRM
    extends TestRMRestart.TestSecurityMockRM {
        public MyMockRM(Configuration conf, RMStateStore store) {
            super(conf, store);
        }

        protected RMSecretManagerService createRMSecretManagerService() {
            return new RMSecretManagerService((Configuration)TestRMDelegationTokens.this.testConf, this.rmContext){

                protected RMDelegationTokenSecretManager createRMDelegationTokenSecretManager(Configuration conf, RMContext rmContext) {
                    return new TestRMDelegationTokenSecretManager(1000L, 1000L, 2000L, 1000L, rmContext);
                }
            };
        }
    }
}

