/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.security;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.User;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.rpcauth.KerberosAuthMethod;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.yarn.api.ApplicationMasterProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterRequest;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmitter;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMSecretManagerService;
import org.apache.hadoop.yarn.server.resourcemanager.TestAMAuthorization;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptContainerFinishedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.security.AMRMTokenSecretManager;
import org.apache.hadoop.yarn.server.security.MasterKeyData;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.Records;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class TestAMRMTokens {
    private static final Logger LOG = LoggerFactory.getLogger(TestAMRMTokens.class);
    private final Configuration conf;
    private static final int maxWaitAttempts = 50;
    private static final int rolling_interval_sec = 13;
    private static final long am_expire_ms = 4000L;

    @Parameterized.Parameters
    public static Collection<Object[]> configs() {
        Configuration conf = new Configuration();
        Configuration confWithSecurity = new Configuration();
        confWithSecurity.set("hadoop.security.authentication", "kerberos");
        confWithSecurity.set("hadoop.security.custom.auth.principal.class", User.class.getName());
        confWithSecurity.set("hadoop.security.custom.rpc.auth.method.class", KerberosAuthMethod.class.getName());
        return Arrays.asList({conf}, {confWithSecurity});
    }

    public TestAMRMTokens(Configuration conf) {
        this.conf = conf;
        UserGroupInformation.setConfiguration((Configuration)conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTokenExpiry() throws Exception {
        this.conf.setLong("yarn.resourcemanager.am-rm-tokens.master-key-rolling-interval-secs", 86400L);
        this.conf.setLong("yarn.am.liveness-monitor.expiry-interval-ms", YarnConfiguration.DEFAULT_RM_AM_EXPIRY_INTERVAL_MS);
        this.conf.set("yarn.resourcemanager.scheduler.address", "0.0.0.0:0");
        TestAMAuthorization.MyContainerManager containerManager = new TestAMAuthorization.MyContainerManager();
        TestAMAuthorization.MockRMWithAMS rm = new TestAMAuthorization.MockRMWithAMS(this.conf, containerManager);
        rm.start();
        Configuration conf = rm.getConfig();
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        ApplicationMasterProtocol rmClient = null;
        try {
            MockNM nm1 = rm.registerNode("localhost:1234", 5120);
            RMApp app = MockRMAppSubmitter.submitWithMemory(1024L, rm);
            nm1.nodeHeartbeat(true);
            int waitCount = 0;
            while (containerManager.containerTokens == null && waitCount++ < 20) {
                LOG.info("Waiting for AM Launch to happen..");
                Thread.sleep(1000L);
            }
            Assert.assertNotNull((Object)containerManager.containerTokens);
            RMAppAttempt attempt = app.getCurrentAppAttempt();
            ApplicationAttemptId applicationAttemptId = attempt.getAppAttemptId();
            UserGroupInformation currentUser = UserGroupInformation.createRemoteUser((String)applicationAttemptId.toString());
            Credentials credentials = containerManager.getContainerCredentials();
            InetSocketAddress rmBindAddress = rm.getApplicationMasterService().getBindAddress();
            Token<? extends TokenIdentifier> amRMToken = TestAMAuthorization.MockRMWithAMS.setupAndReturnAMRMToken(rmBindAddress, credentials.getAllTokens());
            currentUser.addToken(amRMToken);
            rmClient = this.createRMClient(rm, conf, rpc, currentUser);
            RegisterApplicationMasterRequest request = (RegisterApplicationMasterRequest)Records.newRecord(RegisterApplicationMasterRequest.class);
            rmClient.registerApplicationMaster(request);
            FinishApplicationMasterRequest finishAMRequest = (FinishApplicationMasterRequest)Records.newRecord(FinishApplicationMasterRequest.class);
            finishAMRequest.setFinalApplicationStatus(FinalApplicationStatus.SUCCEEDED);
            finishAMRequest.setDiagnostics("diagnostics");
            finishAMRequest.setTrackingUrl("url");
            rmClient.finishApplicationMaster(finishAMRequest);
            ContainerStatus containerStatus = BuilderUtils.newContainerStatus((ContainerId)attempt.getMasterContainer().getId(), (ContainerState)ContainerState.COMPLETE, (String)"AM Container Finished", (int)0, (Resource)attempt.getMasterContainer().getResource());
            rm.getRMContext().getDispatcher().getEventHandler().handle((Event)new RMAppAttemptContainerFinishedEvent(applicationAttemptId, containerStatus, nm1.getNodeId()));
            for (int count = 0; attempt.getState() != RMAppAttemptState.FINISHED && count < 50; ++count) {
                Thread.sleep(100L);
            }
            Assert.assertTrue((attempt.getState() == RMAppAttemptState.FINISHED ? 1 : 0) != 0);
            rpc.stopProxy((Object)rmClient, conf);
            rmClient = this.createRMClient(rm, conf, rpc, currentUser);
            AllocateRequest allocateRequest = (AllocateRequest)Records.newRecord(AllocateRequest.class);
            try {
                rmClient.allocate(allocateRequest);
                Assert.fail((String)"You got to be kidding me! Using App tokens after app-finish should fail!");
            }
            catch (Throwable t) {
                LOG.info("Exception found is ", t);
                Assert.assertTrue((boolean)t.getCause().getMessage().contains(applicationAttemptId.toString() + " not found in AMRMTokenSecretManager."));
            }
        }
        catch (Throwable throwable) {
            rm.stop();
            if (rmClient != null) {
                rpc.stopProxy(rmClient, conf);
            }
            throw throwable;
        }
        rm.stop();
        if (rmClient != null) {
            rpc.stopProxy((Object)rmClient, conf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMasterKeyRollOver() throws Exception {
        this.conf.setLong("yarn.resourcemanager.am-rm-tokens.master-key-rolling-interval-secs", 13L);
        this.conf.setLong("yarn.am.liveness-monitor.expiry-interval-ms", 4000L);
        this.conf.set("yarn.resourcemanager.scheduler.address", "0.0.0.0:0");
        TestAMAuthorization.MyContainerManager containerManager = new TestAMAuthorization.MyContainerManager();
        TestAMAuthorization.MockRMWithAMS rm = new TestAMAuthorization.MockRMWithAMS(this.conf, containerManager);
        rm.start();
        Long startTime = System.currentTimeMillis();
        Configuration conf = rm.getConfig();
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        ApplicationMasterProtocol rmClient = null;
        AMRMTokenSecretManager appTokenSecretManager = rm.getRMContext().getAMRMTokenSecretManager();
        MasterKeyData oldKey = appTokenSecretManager.getMasterKey();
        Assert.assertNotNull((Object)oldKey);
        try {
            MockNM nm1 = rm.registerNode("localhost:1234", 5120);
            RMApp app = MockRMAppSubmitter.submitWithMemory(1024L, rm);
            nm1.nodeHeartbeat(true);
            int waitCount = 0;
            while (containerManager.containerTokens == null && waitCount++ < 50) {
                LOG.info("Waiting for AM Launch to happen..");
                Thread.sleep(1000L);
            }
            Assert.assertNotNull((Object)containerManager.containerTokens);
            RMAppAttempt attempt = app.getCurrentAppAttempt();
            ApplicationAttemptId applicationAttemptId = attempt.getAppAttemptId();
            UserGroupInformation currentUser = UserGroupInformation.createRemoteUser((String)applicationAttemptId.toString());
            Credentials credentials = containerManager.getContainerCredentials();
            InetSocketAddress rmBindAddress = rm.getApplicationMasterService().getBindAddress();
            Token<? extends TokenIdentifier> amRMToken = TestAMAuthorization.MockRMWithAMS.setupAndReturnAMRMToken(rmBindAddress, credentials.getAllTokens());
            currentUser.addToken(amRMToken);
            rmClient = this.createRMClient(rm, conf, rpc, currentUser);
            RegisterApplicationMasterRequest request = (RegisterApplicationMasterRequest)Records.newRecord(RegisterApplicationMasterRequest.class);
            rmClient.registerApplicationMaster(request);
            AllocateRequest allocateRequest = (AllocateRequest)Records.newRecord(AllocateRequest.class);
            Assert.assertTrue((rmClient.allocate(allocateRequest).getAMCommand() == null ? 1 : 0) != 0);
            while (System.currentTimeMillis() - startTime < 13000L) {
                rmClient.allocate(allocateRequest);
                Thread.sleep(500L);
            }
            MasterKeyData newKey = appTokenSecretManager.getMasterKey();
            Assert.assertNotNull((Object)newKey);
            Assert.assertFalse((String)"Master key should have changed!", (boolean)oldKey.equals(newKey));
            rpc.stopProxy((Object)rmClient, conf);
            rmClient = this.createRMClient(rm, conf, rpc, currentUser);
            Assert.assertTrue((rmClient.allocate(allocateRequest).getAMCommand() == null ? 1 : 0) != 0);
            waitCount = 0;
            while (waitCount++ <= 50 && appTokenSecretManager.getCurrnetMasterKeyData() == oldKey) {
                try {
                    rmClient.allocate(allocateRequest);
                }
                catch (Exception ex) {
                    break;
                }
                Thread.sleep(200L);
            }
            Assert.assertTrue((boolean)appTokenSecretManager.getCurrnetMasterKeyData().equals(newKey));
            Assert.assertTrue((boolean)appTokenSecretManager.getMasterKey().equals(newKey));
            Assert.assertTrue((appTokenSecretManager.getNextMasterKeyData() == null ? 1 : 0) != 0);
            Token newToken = appTokenSecretManager.createAndGetAMRMToken(applicationAttemptId);
            SecurityUtil.setTokenService((Token)newToken, (InetSocketAddress)rmBindAddress);
            currentUser.addToken(newToken);
            rpc.stopProxy((Object)rmClient, conf);
            rmClient = this.createRMClient(rm, conf, rpc, currentUser);
            allocateRequest = (AllocateRequest)Records.newRecord(AllocateRequest.class);
            Assert.assertTrue((rmClient.allocate(allocateRequest).getAMCommand() == null ? 1 : 0) != 0);
            rpc.stopProxy((Object)rmClient, conf);
            try {
                currentUser.addToken(amRMToken);
                rmClient = this.createRMClient(rm, conf, rpc, currentUser);
                allocateRequest = (AllocateRequest)Records.newRecord(AllocateRequest.class);
                Assert.assertTrue((rmClient.allocate(allocateRequest).getAMCommand() == null ? 1 : 0) != 0);
                Assert.fail((String)"The old Token should not work");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        catch (Throwable throwable) {
            rm.stop();
            if (rmClient != null) {
                rpc.stopProxy(rmClient, conf);
            }
            throw throwable;
        }
        rm.stop();
        if (rmClient != null) {
            rpc.stopProxy((Object)rmClient, conf);
        }
    }

    @Test(timeout=20000L)
    public void testAMRMMasterKeysUpdate() throws Exception {
        final AtomicReference spySecretMgrRef = new AtomicReference();
        MockRM rm = new MockRM(this.conf){

            protected void doSecureLogin() throws IOException {
            }

            protected RMSecretManagerService createRMSecretManagerService() {
                return new RMSecretManagerService(TestAMRMTokens.this.conf, this.rmContext){

                    protected AMRMTokenSecretManager createAMRMTokenSecretManager(Configuration conf, RMContext rmContext) {
                        AMRMTokenSecretManager spySecretMgr = (AMRMTokenSecretManager)Mockito.spy((Object)super.createAMRMTokenSecretManager(conf, rmContext));
                        spySecretMgrRef.set(spySecretMgr);
                        return spySecretMgr;
                    }
                };
            }
        };
        rm.start();
        MockNM nm = rm.registerNode("127.0.0.1:1234", 8000);
        RMApp app = MockRMAppSubmitter.submitWithMemory(200L, rm);
        MockAM am = MockRM.launchAndRegisterAM(app, rm, nm);
        AMRMTokenSecretManager spySecretMgr = (AMRMTokenSecretManager)spySecretMgrRef.get();
        AllocateResponse response = am.allocate((AllocateRequest)Records.newRecord(AllocateRequest.class));
        Assert.assertNull((Object)response.getAMRMToken());
        Token oldToken = ((RMApp)rm.getRMContext().getRMApps().get(app.getApplicationId())).getRMAppAttempt(am.getApplicationAttemptId()).getAMRMToken();
        rm.getRMContext().getAMRMTokenSecretManager().rollMasterKey();
        response = am.allocate((AllocateRequest)Records.newRecord(AllocateRequest.class));
        Assert.assertNotNull((Object)response.getAMRMToken());
        Token amrmToken = ConverterUtils.convertFromYarn((org.apache.hadoop.yarn.api.records.Token)response.getAMRMToken(), (Text)new Text(response.getAMRMToken().getService()));
        Assert.assertEquals((long)((AMRMTokenIdentifier)amrmToken.decodeIdentifier()).getKeyId(), (long)rm.getRMContext().getAMRMTokenSecretManager().getMasterKey().getMasterKey().getKeyId());
        Mockito.reset((Object[])new AMRMTokenSecretManager[]{spySecretMgr});
        UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)am.getApplicationAttemptId().toString(), (String[])new String[0]);
        ugi.addTokenIdentifier(oldToken.decodeIdentifier());
        response = am.doAllocateAs(ugi, (AllocateRequest)Records.newRecord(AllocateRequest.class));
        Assert.assertNotNull((Object)response.getAMRMToken());
        ((AMRMTokenSecretManager)Mockito.verify((Object)spySecretMgr, (VerificationMode)Mockito.never())).createAndGetAMRMToken((ApplicationAttemptId)Mockito.isA(ApplicationAttemptId.class));
        response = am.allocate((AllocateRequest)Records.newRecord(AllocateRequest.class));
        Assert.assertNull((Object)response.getAMRMToken());
        rm.getRMContext().getAMRMTokenSecretManager().activateNextMasterKey();
        response = am.allocate((AllocateRequest)Records.newRecord(AllocateRequest.class));
        Assert.assertNull((Object)response.getAMRMToken());
        rm.stop();
    }

    private ApplicationMasterProtocol createRMClient(final MockRM rm, final Configuration conf, final YarnRPC rpc, UserGroupInformation currentUser) {
        return (ApplicationMasterProtocol)currentUser.doAs((PrivilegedAction)new PrivilegedAction<ApplicationMasterProtocol>(){

            @Override
            public ApplicationMasterProtocol run() {
                return (ApplicationMasterProtocol)rpc.getProxy(ApplicationMasterProtocol.class, rm.getApplicationMasterService().getBindAddress(), conf);
            }
        });
    }
}

