/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.weightconversion;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePath;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.weightconversion.WeightConverterTestBase;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.weightconversion.WeightToPercentConverter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestWeightToPercentageConverter
extends WeightConverterTestBase {
    private WeightToPercentConverter converter;
    private CapacitySchedulerConfiguration csConfig;

    @Before
    public void setup() {
        this.converter = new WeightToPercentConverter();
        this.csConfig = new CapacitySchedulerConfiguration(new Configuration(false));
    }

    @Test
    public void testSingleWeightConversion() {
        FSQueue root = this.createFSQueues(1);
        this.converter.convertWeightsForChildQueues(root, this.csConfig);
        Assert.assertFalse((String)"Capacity zerosum allowed", (boolean)this.csConfig.getAllowZeroCapacitySum("root"));
        Assert.assertEquals((String)"root.a capacity", (float)100.0f, (float)this.csConfig.getNonLabeledQueueCapacity(new QueuePath("root.a")), (float)0.0f);
    }

    @Test
    public void testNoChildQueueConversion() {
        FSQueue root = this.createFSQueues(new int[0]);
        this.converter.convertWeightsForChildQueues(root, this.csConfig);
        Assert.assertEquals((String)"Converted items", (long)21L, (long)this.csConfig.getPropsWithPrefix("yarn.scheduler.capacity.").size());
    }

    @Test
    public void testMultiWeightConversion() {
        FSQueue root = this.createFSQueues(1, 2, 3);
        this.converter.convertWeightsForChildQueues(root, this.csConfig);
        Assert.assertEquals((String)"Number of properties", (long)24L, (long)this.csConfig.getPropsWithPrefix("yarn.scheduler.capacity.").size());
        Assert.assertEquals((String)"root.a capacity", (float)16.667f, (float)this.csConfig.getNonLabeledQueueCapacity(new QueuePath("root.a")), (float)0.0f);
        Assert.assertEquals((String)"root.b capacity", (float)33.333f, (float)this.csConfig.getNonLabeledQueueCapacity(new QueuePath("root.b")), (float)0.0f);
        Assert.assertEquals((String)"root.c capacity", (float)50.0f, (float)this.csConfig.getNonLabeledQueueCapacity(new QueuePath("root.c")), (float)0.0f);
    }

    @Test
    public void testMultiWeightConversionWhenOfThemIsZero() {
        FSQueue root = this.createFSQueues(0, 1, 1);
        this.converter.convertWeightsForChildQueues(root, this.csConfig);
        Assert.assertFalse((String)"Capacity zerosum allowed", (boolean)this.csConfig.getAllowZeroCapacitySum("root"));
        Assert.assertEquals((String)"Number of properties", (long)24L, (long)this.csConfig.getPropsWithPrefix("yarn.scheduler.capacity.").size());
        Assert.assertEquals((String)"root.a capacity", (float)0.0f, (float)this.csConfig.getNonLabeledQueueCapacity(new QueuePath("root.a")), (float)0.0f);
        Assert.assertEquals((String)"root.b capacity", (float)50.0f, (float)this.csConfig.getNonLabeledQueueCapacity(new QueuePath("root.b")), (float)0.0f);
        Assert.assertEquals((String)"root.c capacity", (float)50.0f, (float)this.csConfig.getNonLabeledQueueCapacity(new QueuePath("root.c")), (float)0.0f);
    }

    @Test
    public void testMultiWeightConversionWhenAllOfThemAreZero() {
        FSQueue root = this.createFSQueues(0, 0, 0);
        this.converter.convertWeightsForChildQueues(root, this.csConfig);
        Assert.assertEquals((String)"Number of properties", (long)25L, (long)this.csConfig.getPropsWithPrefix("yarn.scheduler.capacity.").size());
        Assert.assertTrue((String)"Capacity zerosum allowed", (boolean)this.csConfig.getAllowZeroCapacitySum("root"));
        Assert.assertEquals((String)"root.a capacity", (float)0.0f, (float)this.csConfig.getNonLabeledQueueCapacity(new QueuePath("root.a")), (float)0.0f);
        Assert.assertEquals((String)"root.b capacity", (float)0.0f, (float)this.csConfig.getNonLabeledQueueCapacity(new QueuePath("root.b")), (float)0.0f);
        Assert.assertEquals((String)"root.c capacity", (float)0.0f, (float)this.csConfig.getNonLabeledQueueCapacity(new QueuePath("root.c")), (float)0.0f);
    }

    @Test
    public void testCapacityFixingWithThreeQueues() {
        FSQueue root = this.createFSQueues(1, 1, 1);
        this.converter.convertWeightsForChildQueues(root, this.csConfig);
        Assert.assertEquals((String)"Number of properties", (long)24L, (long)this.csConfig.getPropsWithPrefix("yarn.scheduler.capacity.").size());
        Assert.assertEquals((String)"root.a capacity", (float)33.334f, (float)this.csConfig.getNonLabeledQueueCapacity(new QueuePath("root.a")), (float)0.0f);
        Assert.assertEquals((String)"root.b capacity", (float)33.333f, (float)this.csConfig.getNonLabeledQueueCapacity(new QueuePath("root.b")), (float)0.0f);
        Assert.assertEquals((String)"root.c capacity", (float)33.333f, (float)this.csConfig.getNonLabeledQueueCapacity(new QueuePath("root.c")), (float)0.0f);
    }

    @Test
    public void testCapacityFixingWhenTotalCapacityIsGreaterThanHundred() {
        HashMap<String, BigDecimal> capacities = new HashMap<String, BigDecimal>();
        capacities.put("root.a", new BigDecimal("50.001"));
        capacities.put("root.b", new BigDecimal("25.500"));
        capacities.put("root.c", new BigDecimal("25.500"));
        this.testCapacityFixing(capacities, new BigDecimal("100.001"));
    }

    @Test
    public void testCapacityFixWhenTotalCapacityIsLessThanHundred() {
        HashMap<String, BigDecimal> capacities = new HashMap<String, BigDecimal>();
        capacities.put("root.a", new BigDecimal("49.999"));
        capacities.put("root.b", new BigDecimal("25.500"));
        capacities.put("root.c", new BigDecimal("25.500"));
        this.testCapacityFixing(capacities, new BigDecimal("99.999"));
    }

    private void testCapacityFixing(Map<String, BigDecimal> capacities, BigDecimal total) {
        boolean needCapacityValidationRelax = this.converter.fixCapacities(capacities, total);
        Assert.assertFalse((String)"Capacity zerosum allowed", (boolean)needCapacityValidationRelax);
        Assert.assertEquals((String)"root.a capacity", (Object)new BigDecimal("50.000"), (Object)capacities.get("root.a"));
        Assert.assertEquals((String)"root.b capacity", (Object)new BigDecimal("25.500"), (Object)capacities.get("root.b"));
        Assert.assertEquals((String)"root.c capacity", (Object)new BigDecimal("25.500"), (Object)capacities.get("root.c"));
    }
}

