/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint;

import java.util.HashMap;
import java.util.Set;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableSet;
import org.apache.hadoop.util.Sets;
import org.apache.hadoop.yarn.api.records.AllocationTagNamespaceType;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.InvalidAllocationTagsQueryException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.TargetApplications;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.TargetApplicationsNamespace;
import org.junit.Assert;
import org.junit.Test;

public class TestAllocationTagsNamespace {
    @Test
    public void testNamespaceParse() throws InvalidAllocationTagsQueryException {
        String namespaceStr = "self";
        TargetApplicationsNamespace namespace = TargetApplicationsNamespace.parse((String)namespaceStr);
        Assert.assertEquals((Object)AllocationTagNamespaceType.SELF, (Object)namespace.getNamespaceType());
        namespaceStr = "not-self";
        namespace = TargetApplicationsNamespace.parse((String)namespaceStr);
        Assert.assertEquals((Object)AllocationTagNamespaceType.NOT_SELF, (Object)namespace.getNamespaceType());
        namespaceStr = "all";
        namespace = TargetApplicationsNamespace.parse((String)namespaceStr);
        Assert.assertEquals((Object)AllocationTagNamespaceType.ALL, (Object)namespace.getNamespaceType());
        namespaceStr = "app-tag/spark-jobs";
        namespace = TargetApplicationsNamespace.parse((String)namespaceStr);
        Assert.assertEquals((Object)AllocationTagNamespaceType.APP_TAG, (Object)namespace.getNamespaceType());
        try {
            namespaceStr = "app-tag/tag123/tag234";
            TargetApplicationsNamespace.parse((String)namespaceStr);
            Assert.fail((String)"Parsing should fail as the given namespace is invalid");
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.assertTrue((boolean)(e instanceof InvalidAllocationTagsQueryException));
            Assert.assertTrue((boolean)e.getMessage().startsWith("Invalid namespace string"));
        }
        ApplicationId applicationId = ApplicationId.newInstance((long)12345L, (int)1);
        namespaceStr = "app-id/" + applicationId.toString();
        namespace = TargetApplicationsNamespace.parse((String)namespaceStr);
        Assert.assertEquals((Object)AllocationTagNamespaceType.APP_ID, (Object)namespace.getNamespaceType());
        try {
            namespaceStr = "app-id/apppppp_12345_99999";
            TargetApplicationsNamespace.parse((String)namespaceStr);
            Assert.fail((String)"Parsing should fail as the given app ID is invalid");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof InvalidAllocationTagsQueryException));
            Assert.assertTrue((boolean)e.getMessage().startsWith("Invalid application ID for app-id"));
        }
        try {
            namespaceStr = "app-id";
            TargetApplicationsNamespace.parse((String)namespaceStr);
            Assert.fail((String)"Parsing should fail as the given namespace is missing application ID");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof InvalidAllocationTagsQueryException));
            Assert.assertTrue((boolean)e.getMessage().startsWith("Missing the application ID in the namespace string"));
        }
        try {
            namespaceStr = "non_exist_ns";
            TargetApplicationsNamespace.parse((String)namespaceStr);
            Assert.fail((String)"Parsing should fail as the giving type is not supported.");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof InvalidAllocationTagsQueryException));
            Assert.assertTrue((boolean)e.getMessage().startsWith("Invalid namespace prefix"));
        }
    }

    @Test
    public void testNamespaceEvaluation() throws InvalidAllocationTagsQueryException {
        ApplicationId app1 = ApplicationId.newInstance((long)10000L, (int)1);
        ApplicationId app2 = ApplicationId.newInstance((long)10000L, (int)2);
        ApplicationId app3 = ApplicationId.newInstance((long)10000L, (int)3);
        ApplicationId app4 = ApplicationId.newInstance((long)10000L, (int)4);
        ApplicationId app5 = ApplicationId.newInstance((long)10000L, (int)5);
        String namespaceStr = "self";
        TargetApplicationsNamespace namespace = TargetApplicationsNamespace.parse((String)namespaceStr);
        try {
            namespace.getNamespaceScope();
            Assert.fail((String)"Call getNamespaceScope before evaluate is not allowed.");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IllegalStateException));
            Assert.assertTrue((boolean)e.getMessage().contains("Evaluate must be called before a namespace can be consumed."));
        }
        namespaceStr = "self";
        namespace = TargetApplicationsNamespace.parse((String)namespaceStr);
        TargetApplications targetApplications = new TargetApplications(app1, (Set)ImmutableSet.of((Object)app1));
        namespace.evaluate(targetApplications);
        Assert.assertEquals((long)1L, (long)namespace.getNamespaceScope().size());
        Assert.assertEquals((Object)app1, namespace.getNamespaceScope().iterator().next());
        namespaceStr = "not-self";
        namespace = TargetApplicationsNamespace.parse((String)namespaceStr);
        targetApplications = new TargetApplications(app1, (Set)ImmutableSet.of((Object)app1));
        namespace.evaluate(targetApplications);
        Assert.assertEquals((long)0L, (long)namespace.getNamespaceScope().size());
        targetApplications = new TargetApplications(app1, (Set)ImmutableSet.of((Object)app1, (Object)app2, (Object)app3));
        namespace.evaluate(targetApplications);
        Assert.assertEquals((long)2L, (long)namespace.getNamespaceScope().size());
        Assert.assertFalse((boolean)namespace.getNamespaceScope().contains(app1));
        namespaceStr = "all";
        namespace = TargetApplicationsNamespace.parse((String)namespaceStr);
        Assert.assertEquals((Object)AllocationTagNamespaceType.ALL, (Object)namespace.getNamespaceType());
        namespaceStr = "app-id/" + app2.toString();
        namespace = TargetApplicationsNamespace.parse((String)namespaceStr);
        targetApplications = new TargetApplications(app1, (Set)ImmutableSet.of((Object)app1, (Object)app2, (Object)app3, (Object)app4, (Object)app5));
        namespace.evaluate(targetApplications);
        Assert.assertEquals((long)1L, (long)namespace.getNamespaceScope().size());
        Assert.assertEquals((Object)app2, namespace.getNamespaceScope().iterator().next());
        HashMap<ApplicationId, ImmutableSet> appsWithTags = new HashMap<ApplicationId, ImmutableSet>();
        appsWithTags.put(app1, ImmutableSet.of((Object)"A", (Object)"B"));
        appsWithTags.put(app2, ImmutableSet.of((Object)"A"));
        appsWithTags.put(app3, ImmutableSet.of());
        appsWithTags.put(app4, ImmutableSet.of((Object)"C"));
        appsWithTags.put(app5, ImmutableSet.of((Object)"A", (Object)"B", (Object)"C"));
        namespaceStr = "app-tag/A";
        namespace = TargetApplicationsNamespace.parse((String)namespaceStr);
        targetApplications = new TargetApplications(app1, appsWithTags);
        namespace.evaluate(targetApplications);
        Assert.assertEquals((long)3L, (long)namespace.getNamespaceScope().size());
        Assert.assertTrue((boolean)Sets.difference((Set)namespace.getNamespaceScope(), (Set)ImmutableSet.of((Object)app1, (Object)app2, (Object)app5)).isEmpty());
        namespaceStr = "app-tag/B";
        namespace = TargetApplicationsNamespace.parse((String)namespaceStr);
        namespace.evaluate(targetApplications);
        Assert.assertEquals((long)2L, (long)namespace.getNamespaceScope().size());
        Assert.assertTrue((boolean)Sets.difference((Set)namespace.getNamespaceScope(), (Set)ImmutableSet.of((Object)app1, (Object)app5)).isEmpty());
        namespaceStr = "app-tag/xyz";
        namespace = TargetApplicationsNamespace.parse((String)namespaceStr);
        namespace.evaluate(targetApplications);
        Assert.assertEquals((long)0L, (long)namespace.getNamespaceScope().size());
    }
}

