/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.policy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableSet;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueResourceQuotas;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueCapacities;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.policy.PriorityUtilizationQueueOrderingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.policy.QueueOrderingPolicy;
import org.junit.Assert;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.mockito.Mockito;

public class TestPriorityUtilizationQueueOrderingPolicy {
    private List<CSQueue> mockCSQueues(String[] queueNames, int[] priorities, float[] utilizations, float[] absCapacities, String partition) {
        assert (queueNames != null && priorities != null && utilizations != null && queueNames.length > 0 && queueNames.length == priorities.length && priorities.length == utilizations.length);
        ArrayList<CSQueue> list = new ArrayList<CSQueue>();
        for (int i = 0; i < queueNames.length; ++i) {
            CSQueue q = (CSQueue)Mockito.mock(CSQueue.class);
            Mockito.when((Object)q.getQueuePath()).thenReturn((Object)queueNames[i]);
            QueueCapacities qc = new QueueCapacities(false);
            qc.setAbsoluteCapacity(partition, absCapacities[i]);
            qc.setUsedCapacity(partition, utilizations[i]);
            Mockito.when((Object)q.getQueueCapacities()).thenReturn((Object)qc);
            Mockito.when((Object)q.getPriority()).thenReturn((Object)Priority.newInstance((int)priorities[i]));
            QueueResourceQuotas qr = new QueueResourceQuotas();
            Mockito.when((Object)q.getQueueResourceQuotas()).thenReturn((Object)qr);
            list.add(q);
        }
        return list;
    }

    private void verifyOrder(QueueOrderingPolicy orderingPolicy, String partition, String[] expectedOrder) {
        Iterator iter = orderingPolicy.getAssignmentIterator(partition);
        int i = 0;
        while (iter.hasNext()) {
            CSQueue q = (CSQueue)iter.next();
            Assert.assertEquals((Object)expectedOrder[i], (Object)q.getQueuePath());
            ++i;
        }
        assert (i == expectedOrder.length);
    }

    @Test
    public void testUtilizationOrdering() {
        PriorityUtilizationQueueOrderingPolicy policy = new PriorityUtilizationQueueOrderingPolicy(false);
        policy.setQueues(this.mockCSQueues(new String[]{"a"}, new int[]{0}, new float[]{0.1f}, new float[]{0.2f}, ""));
        this.verifyOrder((QueueOrderingPolicy)policy, "", new String[]{"a"});
        policy.setQueues(this.mockCSQueues(new String[]{"a", "b"}, new int[]{0, 0}, new float[]{0.1f, 0.0f}, new float[]{0.2f, 0.3f}, ""));
        this.verifyOrder((QueueOrderingPolicy)policy, "", new String[]{"b", "a"});
        policy.setQueues(this.mockCSQueues(new String[]{"a", "b", "c"}, new int[]{0, 0, 0}, new float[]{0.1f, 0.0f, 0.2f}, new float[]{0.2f, 0.3f, 0.4f}, ""));
        this.verifyOrder((QueueOrderingPolicy)policy, "", new String[]{"b", "a", "c"});
        policy.setQueues(this.mockCSQueues(new String[]{"a", "b", "c"}, new int[]{2, 1, 0}, new float[]{0.1f, 0.0f, 0.2f}, new float[]{0.2f, 0.3f, 0.4f}, ""));
        this.verifyOrder((QueueOrderingPolicy)policy, "", new String[]{"b", "a", "c"});
        policy.setQueues(this.mockCSQueues(new String[]{"a", "b", "c"}, new int[]{2, 1, 0}, new float[]{0.1f, 0.0f, 0.2f}, new float[]{0.2f, 0.3f, 0.4f}, "x"));
        this.verifyOrder((QueueOrderingPolicy)policy, "", new String[]{"a", "b", "c"});
        policy.setQueues(this.mockCSQueues(new String[]{"a", "b", "c"}, new int[]{2, 1, 0}, new float[]{0.1f, 0.0f, 0.2f}, new float[]{0.2f, 0.3f, 0.4f}, "x"));
        this.verifyOrder((QueueOrderingPolicy)policy, "x", new String[]{"b", "a", "c"});
        List<CSQueue> queues = this.mockCSQueues(new String[]{"a", "b", "c"}, new int[]{2, 1, 0}, new float[]{0.1f, 0.0f, 0.2f}, new float[]{0.2f, 0.3f, 0.4f}, "x");
        Mockito.when((Object)queues.get(0).getAccessibleNodeLabels()).thenReturn((Object)ImmutableSet.of((Object)"x", (Object)"y"));
        Mockito.when((Object)queues.get(2).getAccessibleNodeLabels()).thenReturn((Object)ImmutableSet.of((Object)"x", (Object)"y"));
        policy.setQueues(queues);
        this.verifyOrder((QueueOrderingPolicy)policy, "x", new String[]{"a", "c", "b"});
    }

    @Test
    public void testPriorityUtilizationOrdering() {
        PriorityUtilizationQueueOrderingPolicy policy = new PriorityUtilizationQueueOrderingPolicy(true);
        policy.setQueues(this.mockCSQueues(new String[]{"a"}, new int[]{1}, new float[]{0.1f}, new float[]{0.2f}, ""));
        this.verifyOrder((QueueOrderingPolicy)policy, "", new String[]{"a"});
        policy.setQueues(this.mockCSQueues(new String[]{"a", "b"}, new int[]{1, 1}, new float[]{0.2f, 0.1f}, new float[]{0.2f, 0.3f}, ""));
        this.verifyOrder((QueueOrderingPolicy)policy, "", new String[]{"b", "a"});
        policy.setQueues(this.mockCSQueues(new String[]{"a", "b"}, new int[]{1, 1}, new float[]{1.1f, 1.2f}, new float[]{0.2f, 0.3f}, ""));
        this.verifyOrder((QueueOrderingPolicy)policy, "", new String[]{"a", "b"});
        policy.setQueues(this.mockCSQueues(new String[]{"a", "b"}, new int[]{1, 1}, new float[]{0.1f, 1.2f}, new float[]{0.2f, 0.3f}, ""));
        this.verifyOrder((QueueOrderingPolicy)policy, "", new String[]{"a", "b"});
        policy.setQueues(this.mockCSQueues(new String[]{"a", "b"}, new int[]{1, 2}, new float[]{1.1f, 1.2f}, new float[]{0.2f, 0.3f}, ""));
        this.verifyOrder((QueueOrderingPolicy)policy, "", new String[]{"b", "a"});
        policy.setQueues(this.mockCSQueues(new String[]{"a", "b"}, new int[]{1, 2}, new float[]{0.1f, 0.2f}, new float[]{0.2f, 0.3f}, ""));
        this.verifyOrder((QueueOrderingPolicy)policy, "", new String[]{"b", "a"});
        policy.setQueues(this.mockCSQueues(new String[]{"a", "b"}, new int[]{1, 2}, new float[]{0.1f, 1.2f}, new float[]{0.2f, 0.3f}, ""));
        this.verifyOrder((QueueOrderingPolicy)policy, "", new String[]{"a", "b"});
        policy.setQueues(this.mockCSQueues(new String[]{"a", "b"}, new int[]{2, 1}, new float[]{0.1f, 1.2f}, new float[]{0.2f, 0.3f}, ""));
        this.verifyOrder((QueueOrderingPolicy)policy, "", new String[]{"a", "b"});
        policy.setQueues(this.mockCSQueues(new String[]{"a", "b"}, new int[]{1, 2}, new float[]{0.1f, 1.0f}, new float[]{0.2f, 0.3f}, ""));
        this.verifyOrder((QueueOrderingPolicy)policy, "", new String[]{"a", "b"});
        policy.setQueues(this.mockCSQueues(new String[]{"a", "b"}, new int[]{2, 1}, new float[]{0.1f, 1.0f}, new float[]{0.2f, 0.3f}, ""));
        this.verifyOrder((QueueOrderingPolicy)policy, "", new String[]{"a", "b"});
        policy.setQueues(this.mockCSQueues(new String[]{"a", "b"}, new int[]{1, 1}, new float[]{0.1f, 1.0f}, new float[]{0.2f, 0.3f}, ""));
        this.verifyOrder((QueueOrderingPolicy)policy, "", new String[]{"a", "b"});
        policy.setQueues(this.mockCSQueues(new String[]{"a", "b"}, new int[]{1, 2}, new float[]{1.0f, 1.0f}, new float[]{0.2f, 0.3f}, ""));
        this.verifyOrder((QueueOrderingPolicy)policy, "", new String[]{"b", "a"});
        policy.setQueues(this.mockCSQueues(new String[]{"a", "b", "c", "d", "e"}, new int[]{1, 2, 0, 0, 3}, new float[]{1.2f, 1.0f, 0.2f, 1.1f, 0.2f}, new float[]{0.2f, 0.1f, 0.1f, 0.3f, 0.3f}, ""));
        this.verifyOrder((QueueOrderingPolicy)policy, "", new String[]{"e", "c", "b", "a", "d"});
        policy.setQueues(this.mockCSQueues(new String[]{"a", "b", "c", "d", "e"}, new int[]{1, 2, 0, 0, 3}, new float[]{1.2f, 1.0f, 0.2f, 1.1f, 0.2f}, new float[]{0.2f, 0.1f, 0.1f, 0.3f, 0.3f}, "x"));
        this.verifyOrder((QueueOrderingPolicy)policy, "", new String[]{"e", "b", "a", "c", "d"});
        policy.setQueues(this.mockCSQueues(new String[]{"a", "b", "c", "d", "e"}, new int[]{1, 2, 0, 0, 3}, new float[]{1.2f, 1.0f, 0.2f, 1.1f, 0.2f}, new float[]{0.2f, 0.1f, 0.1f, 0.3f, 0.3f}, "x"));
        this.verifyOrder((QueueOrderingPolicy)policy, "x", new String[]{"e", "c", "b", "a", "d"});
        List<CSQueue> queues = this.mockCSQueues(new String[]{"a", "b", "c", "d", "e"}, new int[]{1, 2, 0, 0, 3}, new float[]{1.2f, 1.0f, 0.2f, 1.1f, 0.2f}, new float[]{0.2f, 0.1f, 0.1f, 0.3f, 0.3f}, "x");
        Mockito.when((Object)queues.get(0).getAccessibleNodeLabels()).thenReturn((Object)ImmutableSet.of((Object)"x"));
        Mockito.when((Object)queues.get(3).getAccessibleNodeLabels()).thenReturn((Object)ImmutableSet.of((Object)"x"));
        policy.setQueues(queues);
        this.verifyOrder((QueueOrderingPolicy)policy, "x", new String[]{"a", "d", "e", "c", "b"});
        policy.setQueues(this.mockCSQueues(new String[]{"a", "b"}, new int[]{1, 1}, new float[]{0.1f, 1.2f}, new float[]{0.0f, 0.3f}, ""));
        this.verifyOrder((QueueOrderingPolicy)policy, "", new String[]{"b", "a"});
        policy.setQueues(this.mockCSQueues(new String[]{"a", "b"}, new int[]{1, 1}, new float[]{0.1f, 1.2f}, new float[]{0.3f, 0.0f}, ""));
        this.verifyOrder((QueueOrderingPolicy)policy, "", new String[]{"a", "b"});
        policy.setQueues(this.mockCSQueues(new String[]{"a", "b", "c", "d", "e"}, new int[]{1, 2, 0, 0, 3}, new float[]{1.2f, 1.0f, 0.2f, 1.1f, 0.2f}, new float[]{0.0f, 0.0f, 0.1f, 0.3f, 0.3f}, "x"));
        this.verifyOrder((QueueOrderingPolicy)policy, "x", new String[]{"e", "c", "d", "b", "a"});
    }

    @Test
    public void testComparatorDoesNotValidateGeneralContract() {
        String[] nodeLabels = new String[]{"x", "y", "z"};
        PriorityUtilizationQueueOrderingPolicy policy = new PriorityUtilizationQueueOrderingPolicy(true);
        String partition = nodeLabels[TestPriorityUtilizationQueueOrderingPolicy.randInt(0, nodeLabels.length - 1)];
        ArrayList<CSQueue> list = new ArrayList<CSQueue>();
        for (int i = 0; i < 1000; ++i) {
            CSQueue q = (CSQueue)Mockito.mock(CSQueue.class);
            Mockito.when((Object)q.getQueuePath()).thenReturn((Object)String.format("%d", i));
            Mockito.when((Object)q.getQueueCapacities()).thenReturn((Object)this.randomQueueCapacities(partition)).thenReturn((Object)this.randomQueueCapacities(partition)).thenReturn((Object)this.randomQueueCapacities(partition)).thenReturn((Object)this.randomQueueCapacities(partition)).thenReturn((Object)this.randomQueueCapacities(partition));
            Mockito.when((Object)q.getPriority()).thenReturn((Object)Priority.newInstance((int)TestPriorityUtilizationQueueOrderingPolicy.randInt(0, 10))).thenReturn((Object)Priority.newInstance((int)TestPriorityUtilizationQueueOrderingPolicy.randInt(0, 10))).thenReturn((Object)Priority.newInstance((int)TestPriorityUtilizationQueueOrderingPolicy.randInt(0, 10))).thenReturn((Object)Priority.newInstance((int)TestPriorityUtilizationQueueOrderingPolicy.randInt(0, 10))).thenReturn((Object)Priority.newInstance((int)TestPriorityUtilizationQueueOrderingPolicy.randInt(0, 10)));
            if (TestPriorityUtilizationQueueOrderingPolicy.randInt(0, nodeLabels.length) == 1) {
                Mockito.when((Object)q.getAccessibleNodeLabels()).thenReturn(this.randomNodeLabels(nodeLabels)).thenReturn(this.randomNodeLabels(nodeLabels)).thenReturn(this.randomNodeLabels(nodeLabels)).thenReturn(this.randomNodeLabels(nodeLabels)).thenReturn(this.randomNodeLabels(nodeLabels));
            }
            Mockito.when((Object)q.getQueueResourceQuotas()).thenReturn((Object)this.randomResourceQuotas(partition)).thenReturn((Object)this.randomResourceQuotas(partition)).thenReturn((Object)this.randomResourceQuotas(partition)).thenReturn((Object)this.randomResourceQuotas(partition)).thenReturn((Object)this.randomResourceQuotas(partition));
            list.add(q);
        }
        policy.setQueues(list);
        Assertions.assertDoesNotThrow(() -> policy.getAssignmentIterator(partition));
    }

    @Test
    public void testComparatorClassDoesNotViolateTimSortContract() {
        String partition = "testPartition";
        ArrayList<PriorityUtilizationQueueOrderingPolicy.PriorityQueueResourcesForSorting> queues = new ArrayList<PriorityUtilizationQueueOrderingPolicy.PriorityQueueResourcesForSorting>();
        for (int i = 0; i < 1000; ++i) {
            queues.add(this.createMockPriorityQueueResourcesForSorting(partition));
        }
        Collections.shuffle(queues);
        Assertions.assertDoesNotThrow(() -> queues.sort((Comparator<PriorityUtilizationQueueOrderingPolicy.PriorityQueueResourcesForSorting>)new PriorityUtilizationQueueOrderingPolicy.PriorityQueueComparator(new PriorityUtilizationQueueOrderingPolicy(true), partition)));
    }

    private PriorityUtilizationQueueOrderingPolicy.PriorityQueueResourcesForSorting createMockPriorityQueueResourcesForSorting(String partition) {
        QueueResourceQuotas resourceQuotas = this.randomResourceQuotas(partition);
        boolean isZeroResource = ThreadLocalRandom.current().nextBoolean();
        if (isZeroResource) {
            resourceQuotas.setConfiguredMinResource(partition, Resource.newInstance((int)0, (int)0));
        }
        QueueCapacities mockQueueCapacities = (QueueCapacities)Mockito.mock(QueueCapacities.class);
        Mockito.when((Object)Float.valueOf(mockQueueCapacities.getAbsoluteUsedCapacity(partition))).thenReturn((Object)Float.valueOf(4.2f));
        Mockito.when((Object)Float.valueOf(mockQueueCapacities.getUsedCapacity(partition))).thenReturn((Object)Float.valueOf(1.0f));
        Mockito.when((Object)Float.valueOf(mockQueueCapacities.getAbsoluteCapacity(partition))).thenReturn((Object)Float.valueOf(6.2f));
        CSQueue mockQueue = (CSQueue)Mockito.mock(CSQueue.class);
        Mockito.when((Object)mockQueue.getQueueCapacities()).thenReturn((Object)mockQueueCapacities);
        Mockito.when((Object)mockQueue.getPriority()).thenReturn((Object)Priority.newInstance((int)7));
        Mockito.when((Object)mockQueue.getAccessibleNodeLabels()).thenReturn(Collections.singleton(partition));
        Mockito.when((Object)mockQueue.getQueueResourceQuotas()).thenReturn((Object)resourceQuotas);
        return new PriorityUtilizationQueueOrderingPolicy.PriorityQueueResourcesForSorting(mockQueue, partition);
    }

    private QueueCapacities randomQueueCapacities(String partition) {
        QueueCapacities qc = new QueueCapacities(false);
        qc.setAbsoluteCapacity(partition, (float)TestPriorityUtilizationQueueOrderingPolicy.randFloat(0.0, 100.0));
        qc.setUsedCapacity(partition, (float)TestPriorityUtilizationQueueOrderingPolicy.randFloat(0.0, 100.0));
        qc.setAbsoluteUsedCapacity(partition, (float)TestPriorityUtilizationQueueOrderingPolicy.randFloat(0.0, 100.0));
        return qc;
    }

    private Set<String> randomNodeLabels(String[] availableNodeLabels) {
        HashSet<String> nodeLabels = new HashSet<String>();
        for (String label : availableNodeLabels) {
            if (TestPriorityUtilizationQueueOrderingPolicy.randInt(0, 1) != 1) continue;
            nodeLabels.add(label);
        }
        return nodeLabels;
    }

    private QueueResourceQuotas randomResourceQuotas(String partition) {
        QueueResourceQuotas qr = new QueueResourceQuotas();
        qr.setConfiguredMinResource(partition, Resource.newInstance((int)(TestPriorityUtilizationQueueOrderingPolicy.randInt(1, 10) * 1024), (int)TestPriorityUtilizationQueueOrderingPolicy.randInt(1, 10)));
        return qr;
    }

    private static double randFloat(double min, double max) {
        return min + (double)ThreadLocalRandom.current().nextFloat() * (max - min);
    }

    private static int randInt(int min, int max) {
        return ThreadLocalRandom.current().nextInt(min, max + 1);
    }
}

