/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.placement.converter;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule.MappingRule;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.placement.converter.LegacyMappingRuleToJson;
import org.junit.Assert;
import org.junit.Test;

public class TestLegacyMappingRuleToJson {
    void validateConversion(String legacyUserGroup, String legacyAppName) throws IOException {
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        conf.set("yarn.scheduler.capacity.mapping-rule-format", "legacy");
        conf.set("yarn.scheduler.capacity.queue-mappings", legacyUserGroup);
        conf.set("yarn.scheduler.queue-placement-rules.app-name", legacyAppName);
        List legacyRules = conf.getMappingRules();
        LegacyMappingRuleToJson converter = new LegacyMappingRuleToJson();
        String json = converter.setUserGroupMappingRules(legacyUserGroup).setAppNameMappingRules(legacyAppName).convert();
        conf.set("yarn.scheduler.capacity.mapping-rule-format", "json");
        conf.set("yarn.scheduler.capacity.mapping-rule-json", json);
        List jsonRules = conf.getMappingRules();
        Assert.assertEquals((String)"Number of rules should mach", (long)legacyRules.size(), (long)jsonRules.size());
        for (int i = 0; i < legacyRules.size(); ++i) {
            Assert.assertEquals((String)("Rule #" + i + " should match"), (Object)((MappingRule)legacyRules.get(i)).toString(), (Object)((MappingRule)jsonRules.get(i)).toString());
            Assert.assertEquals((String)("Rule #" + i + " fallback should match"), (Object)((MappingRule)legacyRules.get(i)).getFallback().toString(), (Object)((MappingRule)jsonRules.get(i)).getFallback().toString());
        }
    }

    @Test
    public void testApplicationNameMappingConversion() throws IOException {
        String appMapping = String.join((CharSequence)",", "namedMatch:simple", "namedMatch:root.deep", "namedMatch:%application", "namedMatch:root.deep.%application", "%application:simple", "%application:root.deep", "%application:%application", "%application:root.deep.%application");
        this.validateConversion("", appMapping);
    }

    @Test
    public void testGroupMappingConversion() throws IOException {
        String groupMapping = String.join((CharSequence)",", "g:testers:simple", "g:developers:root.very.deep", "g:users:%user", "g:testers:root.very.deep.%user");
        this.validateConversion(groupMapping, "");
    }

    @Test
    public void testUserMappingConversion() throws IOException {
        String groupMapping = String.join((CharSequence)",", "u:alice:alice", "u:beatrix:root.beatrix", "u:claire:%primary_group", "u:donna:root.deep.%primary_group", "u:emily:%secondary_group", "u:felicity:root.deep.%secondary_group", "u:%user:simple", "u:%user:root.deep", "u:%user:%primary_group", "u:%user:%secondary_group", "u:%user:root.deep.%primary_group", "u:%user:root.deep.%secondary_group", "u:%user:%primary_group.%user", "u:%user:root.%primary_group.%user", "u:%user:root.deep.%primary_group.%user", "u:%user:%secondary_group.%user", "u:%user:root.%secondary_group.%user", "u:%user:root.deep.%secondary_group.%user", "u:%user:%user", "u:%user:root.deep.%user");
        this.validateConversion(groupMapping, "");
    }

    @Test
    public void testTotalConversion() throws IOException {
        String appMapping = String.join((CharSequence)",", "namedMatch:simple", "namedMatch:root.deep", "namedMatch:%application", "namedMatch:root.deep.%application", "%application:simple", "%application:root.deep", "%application:%application", "%application:root.deep.%application");
        String userGroupMapping = String.join((CharSequence)",", "u:alice:alice", "u:beatrix:root.beatrix", "u:claire:%primary_group", "u:donna:root.deep.%primary_group", "u:emily:%secondary_group", "u:felicity:root.deep.%secondary_group", "u:%user:simple", "u:%user:root.deep", "g:testers:simple", "g:developers:root.very.deep", "g:users:%user", "g:testers:root.very.deep.%user", "u:%user:%primary_group", "u:%user:%secondary_group", "u:%user:root.deep.%primary_group", "u:%user:root.deep.%secondary_group", "u:%user:%primary_group.%user", "u:%user:root.%primary_group.%user", "u:%user:root.deep.%primary_group.%user", "u:%user:%secondary_group.%user", "u:%user:root.%secondary_group.%user", "u:%user:root.deep.%secondary_group.%user", "u:%user:%user", "u:%user:root.%user.something", "u:%user:root.deep.%user");
        this.validateConversion(userGroupMapping, appMapping);
    }

    @Test
    public void testErrorHandling() {
        LegacyMappingRuleToJson converter = new LegacyMappingRuleToJson();
        Assert.assertNull((Object)converter.convert());
        converter.setAppNameMappingRules("").setUserGroupMappingRules("");
        Assert.assertNull((Object)converter.convert());
        converter.setAppNameMappingRules((Collection)null).setUserGroupMappingRules((Collection)null);
        Assert.assertNull((Object)converter.convert());
        try {
            converter.setAppNameMappingRules("%application:").setUserGroupMappingRules("").convert();
            Assert.fail((String)"Empty app name mapping part should throw exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            converter.setAppNameMappingRules("%application:sdfsdf:sdfsfd").setUserGroupMappingRules("").convert();
            Assert.fail((String)"Incorrect number of app name mapping parts should throw exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            converter.setAppNameMappingRules("").setUserGroupMappingRules("u::root.default").convert();
            Assert.fail((String)"Empty user group mapping part should throw exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            converter.setAppNameMappingRules("").setUserGroupMappingRules("u:bob").convert();
            Assert.fail((String)"Incorrect number of user group mapping parts should throw exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            converter.setAppNameMappingRules("").setUserGroupMappingRules("X:bob:root.bob").convert();
            Assert.fail((String)"Invalid user group mapping prefix should throw exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

