/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.server.records.Version;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.MutableConfScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.MutableConfigurationProvider;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.LeveldbConfigurationStore;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.MutableCSConfigurationProvider;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.PersistentConfigurationStoreBaseTest;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.YarnConfStoreVersionIncompatibleException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.YarnConfigurationStore;
import org.apache.hadoop.yarn.webapp.dao.SchedConfUpdateInfo;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.DBIterator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestLeveldbConfigurationStore
extends PersistentConfigurationStoreBaseTest {
    public static final Logger LOG = LoggerFactory.getLogger(TestLeveldbConfigurationStore.class);
    private static final File TEST_DIR = new File(System.getProperty("test.build.data", System.getProperty("java.io.tmpdir")), TestLeveldbConfigurationStore.class.getName());

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        FileUtil.fullyDelete((File)TEST_DIR);
        this.conf.set("yarn.scheduler.configuration.store.class", "leveldb");
        this.conf.set("yarn.scheduler.configuration.leveldb-store.path", TEST_DIR.toString());
    }

    @Test(expected=YarnConfStoreVersionIncompatibleException.class)
    public void testIncompatibleVersion() throws Exception {
        try {
            this.confStore.initialize(this.conf, this.schedConf, this.rmContext);
            Version otherVersion = Version.newInstance((int)1, (int)1);
            ((LeveldbConfigurationStore)this.confStore).storeVersion(otherVersion);
            Assert.assertEquals((String)"The configuration store should have stored the newversion.", (Object)otherVersion, (Object)this.confStore.getConfStoreVersion());
            this.confStore.checkVersion();
        }
        finally {
            this.confStore.close();
        }
    }

    @Test
    public void testDisableAuditLogs() throws Exception {
        this.conf.setLong("yarn.scheduler.configuration.store.max-logs", 0L);
        this.confStore.initialize(this.conf, this.schedConf, this.rmContext);
        this.prepareLogMutation("key1", "val1");
        boolean logKeyPresent = false;
        DB db = ((LeveldbConfigurationStore)this.confStore).getDB();
        DBIterator itr = db.iterator();
        itr.seekToFirst();
        while (itr.hasNext()) {
            Map.Entry entry = (Map.Entry)itr.next();
            String key = new String((byte[])entry.getKey(), StandardCharsets.UTF_8);
            if (!key.equals("log")) continue;
            logKeyPresent = true;
            break;
        }
        Assert.assertFalse((String)"Audit Log is not disabled", (boolean)logKeyPresent);
        this.confStore.close();
    }

    @Test
    public void testRestartReadsFromUpdatedStore() throws Exception {
        MockRM rm1 = new MockRM(this.conf);
        rm1.start();
        Assert.assertNull((Object)((MutableConfScheduler)rm1.getResourceScheduler()).getConfiguration().get("key"));
        SchedConfUpdateInfo schedConfUpdateInfo = new SchedConfUpdateInfo();
        schedConfUpdateInfo.getGlobalParams().put("key", "val");
        MutableConfigurationProvider confProvider = ((MutableConfScheduler)rm1.getResourceScheduler()).getMutableConfProvider();
        UserGroupInformation user = UserGroupInformation.createUserForTesting((String)"testUser", (String[])new String[0]);
        YarnConfigurationStore.LogMutation log = confProvider.logAndApplyMutation(user, schedConfUpdateInfo);
        rm1.getResourceScheduler().reinitialize(this.conf, rm1.getRMContext());
        Assert.assertEquals((Object)"val", (Object)((MutableConfScheduler)rm1.getResourceScheduler()).getConfiguration().get("key"));
        confProvider.confirmPendingMutation(log, true);
        Assert.assertEquals((Object)"val", (Object)((MutableCSConfigurationProvider)confProvider).getConfStore().retrieve().get("key"));
        schedConfUpdateInfo.getGlobalParams().put("key", "badVal");
        confProvider.logAndApplyMutation(user, schedConfUpdateInfo);
        rm1.close();
        MockRM rm2 = new MockRM(this.conf);
        rm2.start();
        Assert.assertEquals((Object)"val", (Object)((MutableCSConfigurationProvider)((CapacityScheduler)rm2.getResourceScheduler()).getMutableConfProvider()).getConfStore().retrieve().get("key"));
        Assert.assertEquals((Object)"val", (Object)((MutableConfScheduler)rm2.getResourceScheduler()).getConfiguration().get("key"));
        rm2.close();
    }

    @Override
    public YarnConfigurationStore createConfStore() {
        return new LeveldbConfigurationStore();
    }

    @Override
    Version getVersion() {
        return LeveldbConfigurationStore.CURRENT_VERSION_INFO;
    }
}

