/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.util.Iterator;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePath;
import org.junit.Assert;
import org.junit.Test;

public class TestQueuePath {
    private static final String TEST_QUEUE = "root.level_1.level_2.level_3";

    @Test
    public void testCreation() {
        QueuePath queuePath = new QueuePath(TEST_QUEUE);
        Assert.assertEquals((Object)TEST_QUEUE, (Object)queuePath.getFullPath());
        Assert.assertEquals((Object)"root.level_1.level_2", (Object)queuePath.getParent());
        Assert.assertEquals((Object)"level_3", (Object)queuePath.getLeafName());
        QueuePath rootPath = new QueuePath("root");
        Assert.assertNull((Object)rootPath.getParent());
        QueuePath appendedPath = queuePath.createNewLeaf("level_4");
        Assert.assertEquals((Object)"root.level_1.level_2.level_3.level_4", (Object)appendedPath.getFullPath());
        Assert.assertEquals((Object)TEST_QUEUE, (Object)appendedPath.getParent());
        Assert.assertEquals((Object)"level_4", (Object)appendedPath.getLeafName());
    }

    @Test
    public void testEmptyPart() {
        QueuePath queuePathWithEmptyPart = new QueuePath("root..level_2");
        QueuePath queuePathWithEmptyLeaf = new QueuePath("root.level_1.");
        QueuePath queuePathWithoutEmptyPart = new QueuePath(TEST_QUEUE);
        Assert.assertTrue((boolean)queuePathWithEmptyPart.hasEmptyPart());
        Assert.assertTrue((boolean)queuePathWithEmptyLeaf.hasEmptyPart());
        Assert.assertFalse((boolean)queuePathWithoutEmptyPart.hasEmptyPart());
    }

    @Test
    public void testNullPath() {
        QueuePath queuePathWithNullPath = new QueuePath(null);
        Assert.assertNull((Object)queuePathWithNullPath.getParent());
        Assert.assertEquals((Object)"", (Object)queuePathWithNullPath.getLeafName());
        Assert.assertEquals((Object)"", (Object)queuePathWithNullPath.getFullPath());
        Assert.assertFalse((boolean)queuePathWithNullPath.isRoot());
    }

    @Test
    public void testIterator() {
        QueuePath queuePath = new QueuePath(TEST_QUEUE);
        QueuePath queuePathWithEmptyPart = new QueuePath("root..level_2");
        QueuePath rootPath = new QueuePath("root");
        ImmutableList queuePathCollection = ImmutableList.copyOf((Iterator)queuePath.iterator());
        ImmutableList queuePathWithEmptyPartCollection = ImmutableList.copyOf((Iterator)queuePathWithEmptyPart.iterator());
        ImmutableList rootPathCollection = ImmutableList.copyOf((Iterator)rootPath.iterator());
        Assert.assertEquals((long)4L, (long)queuePathCollection.size());
        Assert.assertEquals((Object)"root", queuePathCollection.get(0));
        Assert.assertEquals((Object)"level_3", queuePathCollection.get(3));
        Assert.assertEquals((long)3L, (long)queuePathWithEmptyPartCollection.size());
        Assert.assertEquals((Object)"root", queuePathWithEmptyPartCollection.get(0));
        Assert.assertEquals((Object)"level_2", queuePathWithEmptyPartCollection.get(2));
        Assert.assertEquals((long)1L, (long)rootPathCollection.size());
        Assert.assertEquals((Object)"root", rootPathCollection.get(0));
    }

    @Test
    public void testReversePathIterator() {
        QueuePath queuePath = new QueuePath(TEST_QUEUE);
        QueuePath queuePathWithEmptyPart = new QueuePath("root..level_2");
        QueuePath rootPath = new QueuePath("root");
        ImmutableList queuePathCollection = ImmutableList.copyOf((Iterator)queuePath.reverseIterator());
        ImmutableList queuePathWithEmptyPartCollection = ImmutableList.copyOf((Iterator)queuePathWithEmptyPart.reverseIterator());
        ImmutableList rootPathCollection = ImmutableList.copyOf((Iterator)rootPath.reverseIterator());
        Assert.assertEquals((long)4L, (long)queuePathCollection.size());
        Assert.assertEquals((Object)"root", queuePathCollection.get(3));
        Assert.assertEquals((Object)TEST_QUEUE, queuePathCollection.get(0));
        Assert.assertEquals((long)3L, (long)queuePathWithEmptyPartCollection.size());
        Assert.assertEquals((Object)"root", queuePathWithEmptyPartCollection.get(2));
        Assert.assertEquals((Object)"root..level_2", queuePathWithEmptyPartCollection.get(0));
        Assert.assertEquals((long)1L, (long)rootPathCollection.size());
        Assert.assertEquals((Object)"root", rootPathCollection.get(0));
    }

    @Test
    public void testEquals() {
        QueuePath queuePath = new QueuePath(TEST_QUEUE);
        QueuePath queuePathSame = new QueuePath(TEST_QUEUE);
        QueuePath empty = new QueuePath("");
        QueuePath emptySame = new QueuePath("");
        Assert.assertEquals((Object)queuePath, (Object)queuePathSame);
        Assert.assertEquals((Object)empty, (Object)emptySame);
        Assert.assertNotEquals(null, (Object)queuePath);
    }
}

