/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ConfigurationProperties;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestConfigurationProperties {
    private static final Map<String, String> PROPERTIES = new HashMap<String, String>();

    @BeforeClass
    public static void setUpClass() throws Exception {
        PROPERTIES.put("root.1.2.3", "TEST_VALUE_1");
        PROPERTIES.put("root.1", "TEST_VALUE_2");
        PROPERTIES.put("root.1.2", "TEST_VALUE_3");
        PROPERTIES.put("root.1.2.4", "TEST_VALUE_3_1");
        PROPERTIES.put("root.1.2.4.5", "TEST_VALUE_3_2");
        PROPERTIES.put("root", "TEST_VALUE_4");
        PROPERTIES.put("2", "TEST_VALUE_5");
        PROPERTIES.put("2.3", "TEST_VALUE_5");
    }

    @Test
    public void testGetPropertiesWithPrefix() {
        ConfigurationProperties configurationProperties = new ConfigurationProperties(PROPERTIES);
        Map props = configurationProperties.getPropertiesWithPrefix("root.1.2");
        Assert.assertEquals((long)4L, (long)props.size());
        Assert.assertTrue((boolean)props.containsKey(""));
        Assert.assertEquals((Object)"TEST_VALUE_3", props.get(""));
        Assert.assertTrue((boolean)props.containsKey("4"));
        Assert.assertEquals((Object)"TEST_VALUE_3_1", props.get("4"));
        Assert.assertTrue((boolean)props.containsKey("3"));
        Assert.assertEquals((Object)"TEST_VALUE_1", props.get("3"));
        Assert.assertTrue((boolean)props.containsKey("4.5"));
        Assert.assertEquals((Object)"TEST_VALUE_3_2", props.get("4.5"));
        props = configurationProperties.getPropertiesWithPrefix("root.1.2.4.");
        Assert.assertEquals((long)2L, (long)props.size());
        Assert.assertTrue((boolean)props.containsKey(""));
        Assert.assertEquals((Object)"TEST_VALUE_3_1", props.get(""));
        Assert.assertTrue((boolean)props.containsKey("5"));
        Assert.assertEquals((Object)"TEST_VALUE_3_2", props.get("5"));
        Map propsWithRootPrefix = configurationProperties.getPropertiesWithPrefix("root");
        Assert.assertEquals((long)6L, (long)propsWithRootPrefix.size());
        Assert.assertTrue((boolean)propsWithRootPrefix.containsKey(""));
        Assert.assertEquals((Object)"TEST_VALUE_4", propsWithRootPrefix.get(""));
        Assert.assertTrue((boolean)propsWithRootPrefix.containsKey("1.2.3"));
        Assert.assertEquals((Object)"TEST_VALUE_1", propsWithRootPrefix.get("1.2.3"));
        Assert.assertTrue((boolean)propsWithRootPrefix.containsKey("1"));
        Assert.assertEquals((Object)"TEST_VALUE_2", propsWithRootPrefix.get("1"));
        Assert.assertTrue((boolean)propsWithRootPrefix.containsKey("1.2"));
        Assert.assertEquals((Object)"TEST_VALUE_3", propsWithRootPrefix.get("1.2"));
        Assert.assertTrue((boolean)propsWithRootPrefix.containsKey("1.2.4"));
        Assert.assertEquals((Object)"TEST_VALUE_3_1", propsWithRootPrefix.get("1.2.4"));
        Assert.assertTrue((boolean)propsWithRootPrefix.containsKey("1.2.4.5"));
        Assert.assertEquals((Object)"TEST_VALUE_3_2", propsWithRootPrefix.get("1.2.4.5"));
    }

    @Test
    public void testGetPropertiesWithFullyQualifiedName() {
        ConfigurationProperties configurationProperties = new ConfigurationProperties(PROPERTIES);
        Map props = configurationProperties.getPropertiesWithPrefix("root.1.2", true);
        Assert.assertEquals((long)4L, (long)props.size());
        Assert.assertTrue((boolean)props.containsKey("root.1.2.3"));
        Assert.assertEquals((Object)"TEST_VALUE_1", props.get("root.1.2.3"));
        Assert.assertTrue((boolean)props.containsKey("root.1.2"));
        Assert.assertEquals((Object)"TEST_VALUE_3", props.get("root.1.2"));
        Assert.assertTrue((boolean)props.containsKey("root.1.2.4.5"));
        Assert.assertEquals((Object)"TEST_VALUE_3_2", props.get("root.1.2.4.5"));
        Assert.assertTrue((boolean)props.containsKey("root.1.2.4"));
        Assert.assertEquals((Object)"TEST_VALUE_3_1", props.get("root.1.2.4"));
    }

    @Test
    public void testGetPropertiesWithPrefixEmptyResult() {
        ConfigurationProperties configurationProperties = new ConfigurationProperties(PROPERTIES);
        Map propsEmptyPrefix = configurationProperties.getPropertiesWithPrefix("");
        Map propsLongPrefix = configurationProperties.getPropertiesWithPrefix("root.1.2.4.5.6");
        Map propsNonExistingRootPrefix = configurationProperties.getPropertiesWithPrefix("3");
        Assert.assertEquals((long)0L, (long)propsEmptyPrefix.size());
        Assert.assertEquals((long)0L, (long)propsLongPrefix.size());
        Assert.assertEquals((long)0L, (long)propsNonExistingRootPrefix.size());
    }
}

