/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivitiesManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSMaxRunningAppsEnforcer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerQueueContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerQueueManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.preemption.PreemptionManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.security.AppPriorityACLsManager;
import org.apache.hadoop.yarn.util.ControlledClock;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestCSMaxRunningAppsEnforcer {
    private CapacitySchedulerQueueManager queueManager;
    private CSMaxRunningAppsEnforcer maxAppsEnforcer;
    private int appNum;
    private ControlledClock clock;
    private RMContext rmContext;
    private CapacityScheduler scheduler;
    private ActivitiesManager activitiesManager;
    private CapacitySchedulerConfiguration csConfig;

    @Before
    public void setup() throws IOException {
        this.csConfig = new CapacitySchedulerConfiguration();
        this.rmContext = (RMContext)Mockito.mock(RMContext.class);
        Mockito.when((Object)this.rmContext.getYarnConfiguration()).thenReturn((Object)this.csConfig);
        Mockito.when((Object)this.rmContext.getRMApps()).thenReturn(new ConcurrentHashMap());
        this.clock = new ControlledClock();
        this.scheduler = (CapacityScheduler)Mockito.mock(CapacityScheduler.class);
        Mockito.when((Object)this.rmContext.getScheduler()).thenReturn((Object)this.scheduler);
        Mockito.when((Object)this.scheduler.getConf()).thenReturn((Object)this.csConfig);
        Mockito.when((Object)this.scheduler.getConfig()).thenReturn((Object)this.csConfig);
        Mockito.when((Object)this.scheduler.getConfiguration()).thenReturn((Object)this.csConfig);
        Mockito.when((Object)this.scheduler.getResourceCalculator()).thenReturn((Object)new DefaultResourceCalculator());
        Mockito.when((Object)this.scheduler.getRMContext()).thenReturn((Object)this.rmContext);
        Resource clusterResource = Resource.newInstance((int)16384, (int)8);
        Mockito.when((Object)this.scheduler.getClusterResource()).thenReturn((Object)clusterResource);
        Mockito.when((Object)this.scheduler.getMinimumAllocation()).thenReturn((Object)Resource.newInstance((int)1024, (int)1));
        Mockito.when((Object)this.scheduler.getMinimumResourceCapability()).thenReturn((Object)Resource.newInstance((int)1024, (int)1));
        this.activitiesManager = (ActivitiesManager)Mockito.mock(ActivitiesManager.class);
        this.maxAppsEnforcer = new CSMaxRunningAppsEnforcer(this.scheduler);
        this.appNum = 0;
        this.setupQueues(this.csConfig);
        RMNodeLabelsManager labelManager = (RMNodeLabelsManager)Mockito.mock(RMNodeLabelsManager.class);
        AppPriorityACLsManager appPriorityACLManager = (AppPriorityACLsManager)Mockito.mock(AppPriorityACLsManager.class);
        Mockito.when((Object)this.rmContext.getNodeLabelManager()).thenReturn((Object)labelManager);
        Mockito.when((Object)labelManager.getResourceByLabel((String)ArgumentMatchers.any(), (Resource)ArgumentMatchers.any(Resource.class))).thenReturn((Object)clusterResource);
        PreemptionManager preemptionManager = (PreemptionManager)Mockito.mock(PreemptionManager.class);
        Mockito.when((Object)preemptionManager.getKillableResource((String)ArgumentMatchers.any(), ArgumentMatchers.anyString())).thenReturn((Object)Resource.newInstance((int)0, (int)0));
        Mockito.when((Object)this.scheduler.getPreemptionManager()).thenReturn((Object)preemptionManager);
        Mockito.when((Object)this.scheduler.getActivitiesManager()).thenReturn((Object)this.activitiesManager);
        this.queueManager = new CapacitySchedulerQueueManager((Configuration)this.csConfig, labelManager, appPriorityACLManager);
        this.queueManager.setCapacitySchedulerContext((CapacitySchedulerContext)this.scheduler);
        Mockito.when((Object)this.scheduler.getCapacitySchedulerQueueManager()).thenReturn((Object)this.queueManager);
        CapacitySchedulerQueueContext queueContext = new CapacitySchedulerQueueContext((CapacitySchedulerContext)this.scheduler);
        Mockito.when((Object)this.scheduler.getQueueContext()).thenReturn((Object)queueContext);
        this.queueManager.initializeQueues(this.csConfig);
    }

    private void setupQueues(CapacitySchedulerConfiguration config) {
        config.setQueues("root", new String[]{"queue1", "queue2"});
        config.setQueues("root.queue1", new String[]{"subqueue1", "subqueue2"});
        config.setQueues("root.queue1.subqueue1", new String[]{"leaf1"});
        config.setQueues("root.queue1.subqueue2", new String[]{"leaf2"});
        config.setFloat("yarn.scheduler.capacity.root.capacity", 100.0f);
        config.setFloat("yarn.scheduler.capacity.root.queue1.capacity", 50.0f);
        config.setFloat("yarn.scheduler.capacity.root.queue2.capacity", 50.0f);
        config.setFloat("yarn.scheduler.capacity.root.queue1.subqueue1.capacity", 50.0f);
        config.setFloat("yarn.scheduler.capacity.root.queue1.subqueue2.capacity", 50.0f);
        config.setFloat("yarn.scheduler.capacity.root.queue1.subqueue1.leaf1.capacity", 100.0f);
        config.setFloat("yarn.scheduler.capacity.root.queue1.subqueue2.leaf2.capacity", 100.0f);
    }

    private FiCaSchedulerApp addApp(LeafQueue queue, String user) {
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)this.appNum++);
        ApplicationAttemptId attId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0);
        FiCaSchedulerApp attempt = new FiCaSchedulerApp(attId, user, (Queue)queue, queue.getAbstractUsersManager(), this.rmContext, Priority.newInstance((int)0), false, this.activitiesManager){
            private final long startTime;
            {
                this.startTime = TestCSMaxRunningAppsEnforcer.this.clock.getTime();
            }

            public long getStartTime() {
                return this.startTime;
            }
        };
        this.maxAppsEnforcer.checkRunnabilityWithUpdate(attempt);
        this.maxAppsEnforcer.trackApp(attempt);
        queue.submitApplicationAttempt(attempt, attempt.getUser());
        return attempt;
    }

    private void removeApp(FiCaSchedulerApp attempt) {
        AbstractLeafQueue queue = attempt.getCSLeafQueue();
        queue.finishApplicationAttempt(attempt, queue.getQueuePath());
        this.maxAppsEnforcer.untrackApp(attempt);
        this.maxAppsEnforcer.updateRunnabilityOnAppRemoval(attempt);
    }

    @Test
    public void testRemoveDoesNotEnableAnyApp() {
        ParentQueue root = (ParentQueue)this.queueManager.getRootQueue();
        LeafQueue leaf1 = (LeafQueue)this.queueManager.getQueueByFullName("root.queue1.subqueue1.leaf1");
        LeafQueue leaf2 = (LeafQueue)this.queueManager.getQueueByFullName("root.queue1.subqueue2.leaf2");
        root.setMaxParallelApps(2);
        leaf1.setMaxParallelApps(1);
        leaf2.setMaxParallelApps(1);
        FiCaSchedulerApp app1 = this.addApp(leaf1, "user");
        this.addApp(leaf2, "user");
        this.addApp(leaf2, "user");
        Assert.assertEquals((long)1L, (long)leaf1.getNumRunnableApps());
        Assert.assertEquals((long)1L, (long)leaf2.getNumRunnableApps());
        Assert.assertEquals((long)1L, (long)leaf2.getNumNonRunnableApps());
        this.removeApp(app1);
        Assert.assertEquals((long)0L, (long)leaf1.getNumRunnableApps());
        Assert.assertEquals((long)1L, (long)leaf2.getNumRunnableApps());
        Assert.assertEquals((long)1L, (long)leaf2.getNumNonRunnableApps());
    }

    @Test
    public void testRemoveEnablesAppOnCousinQueue() {
        LeafQueue leaf1 = (LeafQueue)this.queueManager.getQueueByFullName("root.queue1.subqueue1.leaf1");
        LeafQueue leaf2 = (LeafQueue)this.queueManager.getQueueByFullName("root.queue1.subqueue2.leaf2");
        ParentQueue queue1 = (ParentQueue)this.queueManager.getQueueByFullName("root.queue1");
        queue1.setMaxParallelApps(2);
        FiCaSchedulerApp app1 = this.addApp(leaf1, "user");
        this.addApp(leaf2, "user");
        this.addApp(leaf2, "user");
        Assert.assertEquals((long)1L, (long)leaf1.getNumRunnableApps());
        Assert.assertEquals((long)1L, (long)leaf2.getNumRunnableApps());
        Assert.assertEquals((long)1L, (long)leaf2.getNumNonRunnableApps());
        this.removeApp(app1);
        Assert.assertEquals((long)0L, (long)leaf1.getNumRunnableApps());
        Assert.assertEquals((long)2L, (long)leaf2.getNumRunnableApps());
        Assert.assertEquals((long)0L, (long)leaf2.getNumNonRunnableApps());
    }

    @Test
    public void testRemoveEnablesOneByQueueOneByUser() {
        LeafQueue leaf1 = (LeafQueue)this.queueManager.getQueueByFullName("root.queue1.subqueue1.leaf1");
        LeafQueue leaf2 = (LeafQueue)this.queueManager.getQueueByFullName("root.queue1.subqueue2.leaf2");
        leaf1.setMaxParallelApps(2);
        this.csConfig.setInt("yarn.scheduler.capacity.user.user1.max-parallel-apps", 1);
        FiCaSchedulerApp app1 = this.addApp(leaf1, "user1");
        this.addApp(leaf1, "user2");
        this.addApp(leaf1, "user3");
        this.addApp(leaf2, "user1");
        Assert.assertEquals((long)2L, (long)leaf1.getNumRunnableApps());
        Assert.assertEquals((long)1L, (long)leaf1.getNumNonRunnableApps());
        Assert.assertEquals((long)1L, (long)leaf2.getNumNonRunnableApps());
        this.removeApp(app1);
        Assert.assertEquals((long)2L, (long)leaf1.getNumRunnableApps());
        Assert.assertEquals((long)1L, (long)leaf2.getNumRunnableApps());
        Assert.assertEquals((long)0L, (long)leaf1.getNumNonRunnableApps());
        Assert.assertEquals((long)0L, (long)leaf2.getNumNonRunnableApps());
    }

    @Test
    public void testRemoveEnablingOrderedByStartTime() {
        LeafQueue leaf1 = (LeafQueue)this.queueManager.getQueueByFullName("root.queue1.subqueue1.leaf1");
        LeafQueue leaf2 = (LeafQueue)this.queueManager.getQueueByFullName("root.queue1.subqueue2.leaf2");
        ParentQueue queue1 = (ParentQueue)this.queueManager.getQueueByFullName("root.queue1");
        queue1.setMaxParallelApps(2);
        FiCaSchedulerApp app1 = this.addApp(leaf1, "user");
        this.addApp(leaf2, "user");
        this.addApp(leaf2, "user");
        this.clock.tickSec(20);
        this.addApp(leaf1, "user");
        Assert.assertEquals((long)1L, (long)leaf1.getNumRunnableApps());
        Assert.assertEquals((long)1L, (long)leaf2.getNumRunnableApps());
        Assert.assertEquals((long)1L, (long)leaf1.getNumNonRunnableApps());
        Assert.assertEquals((long)1L, (long)leaf2.getNumNonRunnableApps());
        this.removeApp(app1);
        Assert.assertEquals((long)0L, (long)leaf1.getNumRunnableApps());
        Assert.assertEquals((long)2L, (long)leaf2.getNumRunnableApps());
        Assert.assertEquals((long)0L, (long)leaf2.getNumNonRunnableApps());
    }

    @Test
    public void testMultipleAppsWaitingOnCousinQueue() {
        LeafQueue leaf1 = (LeafQueue)this.queueManager.getQueueByFullName("root.queue1.subqueue1.leaf1");
        LeafQueue leaf2 = (LeafQueue)this.queueManager.getQueueByFullName("root.queue1.subqueue2.leaf2");
        ParentQueue queue1 = (ParentQueue)this.queueManager.getQueueByFullName("root.queue1");
        queue1.setMaxParallelApps(2);
        FiCaSchedulerApp app1 = this.addApp(leaf1, "user");
        this.addApp(leaf2, "user");
        this.addApp(leaf2, "user");
        this.addApp(leaf2, "user");
        Assert.assertEquals((long)1L, (long)leaf1.getNumRunnableApps());
        Assert.assertEquals((long)1L, (long)leaf2.getNumRunnableApps());
        Assert.assertEquals((long)2L, (long)leaf2.getNumNonRunnableApps());
        this.removeApp(app1);
        Assert.assertEquals((long)0L, (long)leaf1.getNumRunnableApps());
        Assert.assertEquals((long)2L, (long)leaf2.getNumRunnableApps());
        Assert.assertEquals((long)1L, (long)leaf2.getNumNonRunnableApps());
    }

    @Test
    public void testMultiListStartTimeIteratorEmptyAppLists() {
        ArrayList<List<FiCaSchedulerApp>> lists = new ArrayList<List<FiCaSchedulerApp>>();
        lists.add(Arrays.asList(this.mockAppAttempt(1L)));
        lists.add(Arrays.asList(this.mockAppAttempt(2L)));
        CSMaxRunningAppsEnforcer.MultiListStartTimeIterator iter = new CSMaxRunningAppsEnforcer.MultiListStartTimeIterator(lists);
        Assert.assertEquals((long)1L, (long)((FiCaSchedulerApp)iter.next()).getStartTime());
        Assert.assertEquals((long)2L, (long)((FiCaSchedulerApp)iter.next()).getStartTime());
    }

    private FiCaSchedulerApp mockAppAttempt(long startTime) {
        FiCaSchedulerApp schedApp = (FiCaSchedulerApp)Mockito.mock(FiCaSchedulerApp.class);
        Mockito.when((Object)schedApp.getStartTime()).thenReturn((Object)startTime);
        return schedApp;
    }
}

