/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.reservation;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.hadoop.yarn.api.records.ReservationDefinition;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.ReservationRequest;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.InMemoryReservationAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationInterval;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSystemTestUtil;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSystemUtil;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestInMemoryReservationAllocation {
    private String user = "yarn";
    private String planName = "test-reservation";
    private ResourceCalculator resCalc;
    private Resource minAlloc;
    private Random rand = new Random();

    @Before
    public void setUp() {
        this.resCalc = new DefaultResourceCalculator();
        this.minAlloc = Resource.newInstance((int)1, (int)1);
    }

    @After
    public void tearDown() {
        this.user = null;
        this.planName = null;
        this.resCalc = null;
        this.minAlloc = null;
    }

    @Test
    public void testBlocks() {
        ReservationId reservationID = ReservationId.newInstance((long)this.rand.nextLong(), (long)this.rand.nextLong());
        int[] alloc = new int[]{10, 10, 10, 10, 10, 10};
        int start = 100;
        ReservationDefinition rDef = ReservationSystemTestUtil.createSimpleReservationDefinition(start, start + alloc.length + 1, alloc.length);
        Map<ReservationInterval, Resource> allocations = this.generateAllocation(start, alloc, false, false);
        InMemoryReservationAllocation rAllocation = new InMemoryReservationAllocation(reservationID, rDef, this.user, this.planName, (long)start, (long)(start + alloc.length + 1), allocations, this.resCalc, this.minAlloc);
        this.doAssertions((ReservationAllocation)rAllocation, reservationID, rDef, allocations, start, alloc);
        Assert.assertFalse((boolean)rAllocation.containsGangs());
        for (int i = 0; i < alloc.length; ++i) {
            Assert.assertEquals((Object)Resource.newInstance((int)(1024 * alloc[i]), (int)alloc[i]), (Object)rAllocation.getResourcesAtTime((long)(start + i)));
        }
    }

    @Test
    public void testSteps() {
        ReservationId reservationID = ReservationId.newInstance((long)this.rand.nextLong(), (long)this.rand.nextLong());
        int[] alloc = new int[]{10, 10, 10, 10, 10, 10};
        int start = 100;
        ReservationDefinition rDef = ReservationSystemTestUtil.createSimpleReservationDefinition(start, start + alloc.length + 1, alloc.length);
        Map<ReservationInterval, Resource> allocations = this.generateAllocation(start, alloc, true, false);
        InMemoryReservationAllocation rAllocation = new InMemoryReservationAllocation(reservationID, rDef, this.user, this.planName, (long)start, (long)(start + alloc.length + 1), allocations, this.resCalc, this.minAlloc);
        this.doAssertions((ReservationAllocation)rAllocation, reservationID, rDef, allocations, start, alloc);
        Assert.assertFalse((boolean)rAllocation.containsGangs());
        for (int i = 0; i < alloc.length; ++i) {
            Assert.assertEquals((Object)Resource.newInstance((int)(1024 * (alloc[i] + i)), (int)(alloc[i] + i)), (Object)rAllocation.getResourcesAtTime((long)(start + i)));
        }
    }

    @Test
    public void testSkyline() {
        ReservationId reservationID = ReservationId.newInstance((long)this.rand.nextLong(), (long)this.rand.nextLong());
        int[] alloc = new int[]{0, 5, 10, 10, 5, 0};
        int start = 100;
        ReservationDefinition rDef = ReservationSystemTestUtil.createSimpleReservationDefinition(start, start + alloc.length + 1, alloc.length);
        Map<ReservationInterval, Resource> allocations = this.generateAllocation(start, alloc, true, false);
        InMemoryReservationAllocation rAllocation = new InMemoryReservationAllocation(reservationID, rDef, this.user, this.planName, (long)start, (long)(start + alloc.length + 1), allocations, this.resCalc, this.minAlloc);
        this.doAssertions((ReservationAllocation)rAllocation, reservationID, rDef, allocations, start, alloc);
        Assert.assertFalse((boolean)rAllocation.containsGangs());
        for (int i = 0; i < alloc.length; ++i) {
            Assert.assertEquals((Object)Resource.newInstance((int)(1024 * (alloc[i] + i)), (int)(alloc[i] + i)), (Object)rAllocation.getResourcesAtTime((long)(start + i)));
        }
    }

    @Test
    public void testZeroAlloaction() {
        ReservationId reservationID = ReservationId.newInstance((long)this.rand.nextLong(), (long)this.rand.nextLong());
        int[] alloc = new int[]{};
        long start = 0L;
        ReservationDefinition rDef = ReservationSystemTestUtil.createSimpleReservationDefinition(start, start + (long)alloc.length + 1L, alloc.length);
        HashMap<ReservationInterval, Resource> allocations = new HashMap<ReservationInterval, Resource>();
        InMemoryReservationAllocation rAllocation = new InMemoryReservationAllocation(reservationID, rDef, this.user, this.planName, start, start + (long)alloc.length + 1L, allocations, this.resCalc, this.minAlloc);
        this.doAssertions((ReservationAllocation)rAllocation, reservationID, rDef, allocations, (int)start, alloc);
        Assert.assertFalse((boolean)rAllocation.containsGangs());
    }

    @Test
    public void testGangAlloaction() {
        ReservationId reservationID = ReservationId.newInstance((long)this.rand.nextLong(), (long)this.rand.nextLong());
        int[] alloc = new int[]{10, 10, 10, 10, 10, 10};
        int start = 100;
        ReservationDefinition rDef = ReservationSystemTestUtil.createSimpleReservationDefinition(start, start + alloc.length + 1, alloc.length);
        boolean isGang = true;
        Map<ReservationInterval, Resource> allocations = this.generateAllocation(start, alloc, false, isGang);
        InMemoryReservationAllocation rAllocation = new InMemoryReservationAllocation(reservationID, rDef, this.user, this.planName, (long)start, (long)(start + alloc.length + 1), allocations, this.resCalc, this.minAlloc, isGang);
        this.doAssertions((ReservationAllocation)rAllocation, reservationID, rDef, allocations, start, alloc);
        Assert.assertTrue((boolean)rAllocation.containsGangs());
        for (int i = 0; i < alloc.length; ++i) {
            Assert.assertEquals((Object)Resource.newInstance((int)(1024 * alloc[i]), (int)alloc[i]), (Object)rAllocation.getResourcesAtTime((long)(start + i)));
        }
    }

    private void doAssertions(ReservationAllocation rAllocation, ReservationId reservationID, ReservationDefinition rDef, Map<ReservationInterval, Resource> allocations, int start, int[] alloc) {
        Assert.assertEquals((Object)reservationID, (Object)rAllocation.getReservationId());
        Assert.assertEquals((Object)rDef, (Object)rAllocation.getReservationDefinition());
        Assert.assertEquals(allocations, (Object)rAllocation.getAllocationRequests());
        Assert.assertEquals((Object)this.user, (Object)rAllocation.getUser());
        Assert.assertEquals((Object)this.planName, (Object)rAllocation.getPlanName());
        Assert.assertEquals((long)start, (long)rAllocation.getStartTime());
        Assert.assertEquals((long)(start + alloc.length + 1), (long)rAllocation.getEndTime());
    }

    private Map<ReservationInterval, Resource> generateAllocation(int startTime, int[] alloc, boolean isStep, boolean isGang) {
        HashMap<ReservationInterval, Resource> req = new HashMap<ReservationInterval, Resource>();
        int numContainers = 0;
        for (int i = 0; i < alloc.length; ++i) {
            numContainers = isStep ? alloc[i] + i : alloc[i];
            ReservationRequest rr = ReservationRequest.newInstance((Resource)Resource.newInstance((int)1024, (int)1), (int)numContainers);
            if (isGang) {
                rr.setConcurrency(numContainers);
            }
            req.put(new ReservationInterval((long)(startTime + i), (long)(startTime + i + 1)), ReservationSystemUtil.toResource((ReservationRequest)rr));
        }
        return req;
    }
}

