/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.reservation;

import java.io.IOException;
import java.util.Map;
import junit.framework.TestCase;
import net.jcip.annotations.NotThreadSafe;
import org.apache.hadoop.yarn.api.records.ReservationDefinition;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.InMemoryPlan;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.InMemoryReservationAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.PeriodicRLESparseResourceAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.RLESparseResourceAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationInterval;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSystemTestUtil;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.SharingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.exceptions.PlanningException;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.planning.ReservationAgent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.Assert;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
@NotThreadSafe
public abstract class BaseSharingPolicyTest {
    @Parameterized.Parameter(value=0)
    public long duration;
    @Parameterized.Parameter(value=1)
    public double height;
    @Parameterized.Parameter(value=2)
    public int numSubmissions;
    @Parameterized.Parameter(value=3)
    public String recurrenceExpression;
    @Parameterized.Parameter(value=4)
    public Class expectedError;
    private long step;
    private long initTime;
    private InMemoryPlan plan;
    private ReservationAgent mAgent;
    private Resource minAlloc;
    private ResourceCalculator res;
    private Resource maxAlloc;
    private int totCont = 1000;
    protected ReservationSchedulerConfiguration conf;

    @Before
    public void setup() {
        this.step = 1000L;
        this.initTime = System.currentTimeMillis();
        this.minAlloc = Resource.newInstance((int)1024, (int)1);
        this.res = new DefaultResourceCalculator();
        this.maxAlloc = Resource.newInstance((int)8192, (int)8);
        this.mAgent = (ReservationAgent)Mockito.mock(ReservationAgent.class);
        QueueMetrics rootQueueMetrics = (QueueMetrics)Mockito.mock(QueueMetrics.class);
        Resource clusterResource = ReservationSystemTestUtil.calculateClusterResource(this.totCont);
        SharingPolicy policy = this.getInitializedPolicy();
        RMContext context = ReservationSystemTestUtil.createMockRMContext();
        this.plan = new InMemoryPlan(rootQueueMetrics, policy, this.mAgent, clusterResource, this.step, this.res, this.minAlloc, this.maxAlloc, "dedicated", null, true, context);
    }

    public void runTest() throws IOException, PlanningException {
        block7: {
            long period = 1L;
            if (this.recurrenceExpression != null) {
                period = Long.parseLong(this.recurrenceExpression);
            }
            try {
                Map<ReservationInterval, Resource> reservationIntervalResourceMap;
                RLESparseResourceAllocation rle = this.generateRLEAlloc(period);
                if (period > 1L) {
                    rle = new PeriodicRLESparseResourceAllocation(rle, Long.valueOf(period));
                    reservationIntervalResourceMap = ReservationSystemTestUtil.toAllocation(rle, 0L, period);
                } else {
                    reservationIntervalResourceMap = ReservationSystemTestUtil.toAllocation(rle, Long.MIN_VALUE, Long.MAX_VALUE);
                }
                ReservationDefinition rDef = ReservationSystemTestUtil.createSimpleReservationDefinition(this.initTime % period, this.initTime % period + this.duration + 1L, this.duration, 1, this.recurrenceExpression);
                for (int i = 0; i < this.numSubmissions; ++i) {
                    long rstart = rle.getEarliestStartTime();
                    long rend = rle.getLatestNonNullTime();
                    InMemoryReservationAllocation resAlloc = new InMemoryReservationAllocation(ReservationSystemTestUtil.getNewReservationId(), rDef, "u1", "dedicated", rstart, rend, reservationIntervalResourceMap, this.res, this.minAlloc);
                    Assert.assertTrue((String)this.plan.toString(), (boolean)this.plan.addReservation((ReservationAllocation)resAlloc, false));
                }
                if (this.expectedError != null) {
                    System.out.println(this.plan.toString());
                    TestCase.fail();
                }
            }
            catch (Exception e) {
                if (this.expectedError != null && e.getClass().getCanonicalName().equals(this.expectedError.getCanonicalName())) break block7;
                throw e;
            }
        }
    }

    private RLESparseResourceAllocation generateRLEAlloc(long period) {
        RLESparseResourceAllocation rle = new RLESparseResourceAllocation((ResourceCalculator)new DefaultResourceCalculator());
        Resource alloc = Resources.multiply((Resource)this.minAlloc, (double)(this.height * (double)this.totCont));
        long rStart = this.initTime % period;
        long rEnd = this.initTime % period + this.duration;
        if (period > 1L && rEnd > period) {
            long diff = rEnd - period;
            rEnd = period;
            if (this.duration > period) {
                rle.addInterval(new ReservationInterval(0L, period), Resources.multiply((Resource)alloc, (double)(this.duration / period - 1L)));
                rle.addInterval(new ReservationInterval(0L, diff % period), alloc);
            } else {
                rle.addInterval(new ReservationInterval(0L, diff), alloc);
            }
        }
        if (rStart > rEnd) {
            rle.addInterval(new ReservationInterval(rStart, period), alloc);
            rle.addInterval(new ReservationInterval(0L, rEnd), alloc);
        } else {
            rle.addInterval(new ReservationInterval(rStart, rEnd), alloc);
        }
        return rle;
    }

    public abstract SharingPolicy getInitializedPolicy();
}

