/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule;

import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.placement.MockQueueHierarchyBuilder;
import org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule.MappingRuleValidationContext;
import org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule.MappingRuleValidationContextImpl;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerQueueManager;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestMappingRuleValidationContextImpl {
    @Test
    public void testContextVariables() throws YarnException {
        CapacitySchedulerQueueManager qm = (CapacitySchedulerQueueManager)Mockito.mock(CapacitySchedulerQueueManager.class);
        MockQueueHierarchyBuilder.create().withQueueManager(qm).withQueue("root.unmanaged").build();
        Mockito.when((Object)qm.getQueue((String)ArgumentMatchers.isNull())).thenReturn(null);
        MappingRuleValidationContextImpl ctx = new MappingRuleValidationContextImpl(qm);
        Assert.assertEquals((long)0L, (long)ctx.getVariables().size());
        Assert.assertTrue((boolean)ctx.isPathStatic("root.%user"));
        try {
            ctx.addVariable("%user");
            ctx.addVariable("%user");
            Assert.assertEquals((long)1L, (long)ctx.getVariables().size());
            Assert.assertFalse((boolean)ctx.isPathStatic("root.%user"));
            ctx.addVariable("%primary_group");
            ctx.addVariable("%default");
        }
        catch (YarnException e) {
            Assert.fail((String)("We don't expect the add variable to fail: " + e.getMessage()));
        }
        Assert.assertEquals((long)3L, (long)ctx.getVariables().size());
        Assert.assertFalse((boolean)ctx.isPathStatic("root.%primary_group.something"));
        Assert.assertFalse((boolean)ctx.isPathStatic("root.something.%default"));
        Assert.assertTrue((boolean)ctx.isPathStatic("root.static"));
        Assert.assertTrue((boolean)ctx.isPathStatic("root.static.%nothing"));
        Assert.assertTrue((boolean)ctx.isPathStatic("root"));
        Assert.assertTrue((boolean)ctx.getVariables().contains("%user"));
        Assert.assertTrue((boolean)ctx.getVariables().contains("%primary_group"));
        Assert.assertTrue((boolean)ctx.getVariables().contains("%default"));
        Assert.assertFalse((boolean)ctx.getVariables().contains("%nothing"));
    }

    void assertValidPath(MappingRuleValidationContext ctx, String path) {
        try {
            ctx.validateQueuePath(path);
        }
        catch (YarnException e) {
            Assert.fail((String)("Path '" + path + "' should be VALID: " + (Object)((Object)e)));
        }
    }

    void assertInvalidPath(MappingRuleValidationContext ctx, String path) {
        try {
            ctx.validateQueuePath(path);
            Assert.fail((String)("Path '" + path + "' should be INVALID"));
        }
        catch (YarnException yarnException) {
            // empty catch block
        }
    }

    @Test
    public void testManagedQueueValidation() {
        CapacitySchedulerQueueManager qm = (CapacitySchedulerQueueManager)Mockito.mock(CapacitySchedulerQueueManager.class);
        MockQueueHierarchyBuilder.create().withQueueManager(qm).withQueue("root.unmanaged").withManagedParentQueue("root.managed").withQueue("root.unmanagedwithchild.child").withQueue("root.leaf").build();
        Mockito.when((Object)qm.getQueue((String)ArgumentMatchers.isNull())).thenReturn(null);
        MappingRuleValidationContextImpl ctx = new MappingRuleValidationContextImpl(qm);
        try {
            ctx.addVariable("%dynamic");
            ctx.addVariable("%user");
        }
        catch (YarnException e) {
            Assert.fail((String)("We don't expect the add variable to fail: " + e.getMessage()));
        }
        this.assertValidPath((MappingRuleValidationContext)ctx, "%dynamic");
        this.assertValidPath((MappingRuleValidationContext)ctx, "root.%dynamic");
        this.assertValidPath((MappingRuleValidationContext)ctx, "%user.%dynamic");
        this.assertValidPath((MappingRuleValidationContext)ctx, "root.managed.%dynamic");
        this.assertValidPath((MappingRuleValidationContext)ctx, "managed.%dynamic");
        this.assertInvalidPath((MappingRuleValidationContext)ctx, "root.invalid.%dynamic");
        this.assertInvalidPath((MappingRuleValidationContext)ctx, "root.unmanaged.%dynamic");
        this.assertValidPath((MappingRuleValidationContext)ctx, "root.unmanagedwithchild.%user");
        this.assertValidPath((MappingRuleValidationContext)ctx, "unmanagedwithchild.%user");
    }

    @Test
    public void testDynamicQueueValidation() {
        CapacitySchedulerQueueManager qm = (CapacitySchedulerQueueManager)Mockito.mock(CapacitySchedulerQueueManager.class);
        MockQueueHierarchyBuilder.create().withQueueManager(qm).withQueue("root.unmanaged").withDynamicParentQueue("root.managed").withQueue("root.unmanagedwithchild.child").withQueue("root.leaf").build();
        Mockito.when((Object)qm.getQueue((String)ArgumentMatchers.isNull())).thenReturn(null);
        MappingRuleValidationContextImpl ctx = new MappingRuleValidationContextImpl(qm);
        try {
            ctx.addVariable("%dynamic");
            ctx.addVariable("%user");
        }
        catch (YarnException e) {
            Assert.fail((String)("We don't expect the add variable to fail: " + e.getMessage()));
        }
        this.assertValidPath((MappingRuleValidationContext)ctx, "%dynamic");
        this.assertValidPath((MappingRuleValidationContext)ctx, "root.%dynamic");
        this.assertValidPath((MappingRuleValidationContext)ctx, "%user.%dynamic");
        this.assertValidPath((MappingRuleValidationContext)ctx, "root.managed.%dynamic");
        this.assertValidPath((MappingRuleValidationContext)ctx, "managed.%dynamic");
        this.assertValidPath((MappingRuleValidationContext)ctx, "managed.static");
        this.assertValidPath((MappingRuleValidationContext)ctx, "managed.static.%dynamic");
        this.assertValidPath((MappingRuleValidationContext)ctx, "managed.static.%dynamic.%dynamic");
        this.assertInvalidPath((MappingRuleValidationContext)ctx, "root.invalid.%dynamic");
        this.assertInvalidPath((MappingRuleValidationContext)ctx, "root.unmanaged.%dynamic");
        this.assertValidPath((MappingRuleValidationContext)ctx, "root.unmanagedwithchild.%user");
        this.assertValidPath((MappingRuleValidationContext)ctx, "unmanagedwithchild.%user");
    }

    @Test
    public void testStaticQueueValidation() {
        CapacitySchedulerQueueManager qm = (CapacitySchedulerQueueManager)Mockito.mock(CapacitySchedulerQueueManager.class);
        MockQueueHierarchyBuilder.create().withQueueManager(qm).withQueue("root.unmanaged").withManagedParentQueue("root.managed").withQueue("root.deep.queue.path").withQueue("root.ambi.ambileaf").withQueue("root.deep.ambi.ambileaf").withQueue("root.deep.ambi.very.deeepleaf").withDynamicParentQueue("root.dynamic").withQueue("root.dynamic.static.static").build();
        Mockito.when((Object)qm.getQueue((String)ArgumentMatchers.isNull())).thenReturn(null);
        MappingRuleValidationContextImpl ctx = new MappingRuleValidationContextImpl(qm);
        this.assertValidPath((MappingRuleValidationContext)ctx, "root.unmanaged");
        this.assertValidPath((MappingRuleValidationContext)ctx, "unmanaged");
        this.assertInvalidPath((MappingRuleValidationContext)ctx, "root");
        this.assertInvalidPath((MappingRuleValidationContext)ctx, "managed");
        this.assertInvalidPath((MappingRuleValidationContext)ctx, "root.managed");
        this.assertInvalidPath((MappingRuleValidationContext)ctx, "fail");
        this.assertInvalidPath((MappingRuleValidationContext)ctx, "ambi");
        this.assertInvalidPath((MappingRuleValidationContext)ctx, "ambileaf");
        this.assertInvalidPath((MappingRuleValidationContext)ctx, "ambi.ambileaf");
        this.assertValidPath((MappingRuleValidationContext)ctx, "root.ambi.ambileaf");
        this.assertInvalidPath((MappingRuleValidationContext)ctx, "root.dynamic.static");
        this.assertValidPath((MappingRuleValidationContext)ctx, "root.dynamic.static.static");
        this.assertInvalidPath((MappingRuleValidationContext)ctx, "root.dynamic.static.any");
        this.assertValidPath((MappingRuleValidationContext)ctx, "root.dynamic.any.thing");
        this.assertInvalidPath((MappingRuleValidationContext)ctx, "root.dynamic.any.thing.deep");
        this.assertValidPath((MappingRuleValidationContext)ctx, "root.managed.a");
        this.assertInvalidPath((MappingRuleValidationContext)ctx, "root.deep");
        this.assertInvalidPath((MappingRuleValidationContext)ctx, "deep");
        this.assertInvalidPath((MappingRuleValidationContext)ctx, "deep.queue");
        this.assertInvalidPath((MappingRuleValidationContext)ctx, "root.deep.queue");
        this.assertValidPath((MappingRuleValidationContext)ctx, "deep.queue.path");
        this.assertInvalidPath((MappingRuleValidationContext)ctx, "ambi.very.deeepleaf");
        this.assertValidPath((MappingRuleValidationContext)ctx, "queue.path");
        this.assertInvalidPath((MappingRuleValidationContext)ctx, "queue.invalidPath");
        this.assertValidPath((MappingRuleValidationContext)ctx, "path");
        this.assertValidPath((MappingRuleValidationContext)ctx, "root.deep.queue.path");
    }

    @Test
    public void testImmutableVariablesInContext() {
        CapacitySchedulerQueueManager qm = (CapacitySchedulerQueueManager)Mockito.mock(CapacitySchedulerQueueManager.class);
        MappingRuleValidationContextImpl ctx = new MappingRuleValidationContextImpl(qm);
        try {
            ctx.addVariable("mutable");
            ctx.addVariable("mutable");
        }
        catch (YarnException e) {
            Assert.fail((String)("We should be able to add a mutable variable multiple times: " + e.getMessage()));
        }
        try {
            ctx.addImmutableVariable("mutable");
            Assert.fail((String)"We should receive an exception if an already added mutable variable is being marked as immutable");
        }
        catch (YarnException e) {
            // empty catch block
        }
        try {
            ctx.addImmutableVariable("immutable");
            ctx.addImmutableVariable("immutable");
        }
        catch (YarnException e) {
            Assert.fail((String)("We should be able to add a immutable variable multiple times: " + e.getMessage()));
        }
        try {
            ctx.addVariable("immutable");
            Assert.fail((String)"We should receive an exception if we try to add a variable as mutable when it was previously added as immutable");
        }
        catch (YarnException yarnException) {
            // empty catch block
        }
    }
}

