/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule;

import org.apache.hadoop.yarn.server.resourcemanager.placement.VariableContext;
import org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule.MappingRuleAction;
import org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule.MappingRuleActions;
import org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule.MappingRuleResult;
import org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule.MappingRuleResultType;
import org.junit.Assert;
import org.junit.Test;

public class TestMappingRuleActions {
    void assertRejectResult(MappingRuleResult result) {
        Assert.assertSame((Object)MappingRuleResultType.REJECT, (Object)result.getResult());
    }

    void assertSkipResult(MappingRuleResult result) {
        Assert.assertSame((Object)MappingRuleResultType.SKIP, (Object)result.getResult());
    }

    void assertPlaceDefaultResult(MappingRuleResult result) {
        Assert.assertSame((Object)MappingRuleResultType.PLACE_TO_DEFAULT, (Object)result.getResult());
    }

    void assertPlaceResult(MappingRuleResult result, String queue) {
        Assert.assertSame((Object)MappingRuleResultType.PLACE, (Object)result.getResult());
        Assert.assertEquals((Object)queue, (Object)result.getQueue());
    }

    @Test
    public void testRejectAction() {
        VariableContext variables = new VariableContext();
        MappingRuleActions.RejectAction reject = new MappingRuleActions.RejectAction();
        MappingRuleAction rejectHelper = MappingRuleActions.createRejectAction();
        this.assertRejectResult(reject.execute(variables));
        this.assertRejectResult(rejectHelper.execute(variables));
    }

    @Test
    public void testActionFallbacks() {
        MappingRuleActions.PlaceToQueueAction action = new MappingRuleActions.PlaceToQueueAction("a", true);
        action.setFallbackDefaultPlacement();
        this.assertPlaceDefaultResult(action.getFallback());
        action.setFallbackReject();
        this.assertRejectResult(action.getFallback());
        action.setFallbackSkip();
        this.assertSkipResult(action.getFallback());
    }

    @Test
    public void testVariableUpdateAction() {
        VariableContext variables = new VariableContext();
        variables.put("%default", "root.default");
        variables.put("%immutable", "immutable");
        variables.put("%empty", "");
        variables.put("%null", null);
        variables.put("%sub", "xxx");
        variables.setImmutables(new String[]{"%immutable"});
        MappingRuleActions.VariableUpdateAction updateDefaultManual = new MappingRuleActions.VariableUpdateAction("%default", "root.%sub");
        MappingRuleAction updateDefaultHelper = MappingRuleActions.createUpdateDefaultAction((String)"root.%sub%sub");
        MappingRuleActions.VariableUpdateAction updateImmutable = new MappingRuleActions.VariableUpdateAction("%immutable", "changed");
        MappingRuleActions.VariableUpdateAction updateEmpty = new MappingRuleActions.VariableUpdateAction("%empty", "something");
        MappingRuleActions.VariableUpdateAction updateNull = new MappingRuleActions.VariableUpdateAction("%null", "non-null");
        MappingRuleResult result = updateDefaultManual.execute(variables);
        this.assertSkipResult(result);
        Assert.assertEquals((Object)"root.xxx", (Object)variables.get("%default"));
        result = updateDefaultHelper.execute(variables);
        this.assertSkipResult(result);
        Assert.assertEquals((Object)"root.xxxxxx", (Object)variables.get("%default"));
        result = updateEmpty.execute(variables);
        this.assertSkipResult(result);
        Assert.assertEquals((Object)"something", (Object)variables.get("%empty"));
        result = updateNull.execute(variables);
        this.assertSkipResult(result);
        Assert.assertEquals((Object)"non-null", (Object)variables.get("%null"));
        try {
            updateImmutable.execute(variables);
            Assert.fail((String)"Should've failed with exception");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IllegalStateException));
        }
    }

    @Test
    public void testPlaceToQueueAction() {
        VariableContext variables = new VariableContext();
        variables.put("%default", "root.default");
        variables.put("%immutable", "immutable");
        variables.put("%empty", "");
        variables.put("%null", null);
        variables.put("%sub", "xxx");
        variables.setImmutables(new String[]{"%immutable"});
        MappingRuleActions.PlaceToQueueAction placeToStatic = new MappingRuleActions.PlaceToQueueAction("root.static.queue", true);
        MappingRuleActions.PlaceToQueueAction placeToDynamic = new MappingRuleActions.PlaceToQueueAction("root.%sub.%immutable", true);
        MappingRuleAction placeToDynamicDoubleSub = MappingRuleActions.createPlaceToQueueAction((String)"root.%sub%sub.%immutable", (boolean)true);
        MappingRuleAction placeToNull = MappingRuleActions.createPlaceToQueueAction(null, (boolean)true);
        MappingRuleAction placeToEmpty = MappingRuleActions.createPlaceToQueueAction((String)"", (boolean)true);
        MappingRuleActions.PlaceToQueueAction placeToNulRef = new MappingRuleActions.PlaceToQueueAction("%null", true);
        MappingRuleActions.PlaceToQueueAction placeToEmptyRef = new MappingRuleActions.PlaceToQueueAction("%empty", true);
        MappingRuleActions.PlaceToQueueAction placeToDefaultRef = new MappingRuleActions.PlaceToQueueAction("%default", true);
        this.assertPlaceResult(placeToStatic.execute(variables), "root.static.queue");
        this.assertPlaceResult(placeToDynamic.execute(variables), "root.xxx.immutable");
        this.assertPlaceResult(placeToDynamicDoubleSub.execute(variables), "root.%sub%sub.immutable");
        this.assertPlaceResult(placeToNull.execute(variables), "");
        this.assertPlaceResult(placeToEmpty.execute(variables), "");
        this.assertPlaceResult(placeToNulRef.execute(variables), "");
        this.assertPlaceResult(placeToEmptyRef.execute(variables), "");
        this.assertPlaceResult(placeToDefaultRef.execute(variables), "root.default");
    }

    @Test
    public void testToStrings() {
        MappingRuleActions.PlaceToQueueAction place = new MappingRuleActions.PlaceToQueueAction("queue", true);
        MappingRuleActions.VariableUpdateAction varUpdate = new MappingRuleActions.VariableUpdateAction("%var", "value");
        MappingRuleActions.RejectAction reject = new MappingRuleActions.RejectAction();
        Assert.assertEquals((Object)"PlaceToQueueAction{queueName='queue',allowCreate=true}", (Object)place.toString());
        Assert.assertEquals((Object)"VariableUpdateAction{variableName='%var', variableValue='value'}", (Object)varUpdate.toString());
        Assert.assertEquals((Object)"RejectAction", (Object)reject.toString());
    }
}

