/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.placement;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.util.XMLUtils;
import org.apache.hadoop.yarn.server.resourcemanager.placement.DefaultPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.FSPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PlacementFactory;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PrimaryGroupPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.RejectPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.SecondaryGroupExistingPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.SpecifiedPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.UserPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairSchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.QueueManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TestPlacementRuleFS {
    private static final List<Class<? extends PlacementRule>> CONFIG_RULES = new ArrayList<Class<? extends PlacementRule>>(){
        {
            this.add(DefaultPlacementRule.class);
            this.add(PrimaryGroupPlacementRule.class);
            this.add(SecondaryGroupExistingPlacementRule.class);
            this.add(SpecifiedPlacementRule.class);
            this.add(UserPlacementRule.class);
        }
    };
    private static final List<Class<? extends PlacementRule>> NO_CONFIG_RULES = new ArrayList<Class<? extends PlacementRule>>(){
        {
            this.add(RejectPlacementRule.class);
        }
    };
    private static final FairSchedulerConfiguration CONF = new FairSchedulerConfiguration();
    private FairScheduler scheduler;
    private QueueManager queueManager;

    @Before
    public void initTest() {
        this.scheduler = (FairScheduler)Mockito.mock(FairScheduler.class);
        Mockito.when((Object)this.scheduler.getConfig()).thenReturn((Object)CONF);
        this.queueManager = new QueueManager(this.scheduler);
        Mockito.when((Object)this.scheduler.getQueueManager()).thenReturn((Object)this.queueManager);
    }

    @After
    public void cleanTest() {
        this.queueManager = null;
        this.scheduler = null;
    }

    @Test
    public void testRuleSetups() {
        for (Class<? extends PlacementRule> ruleClass : CONFIG_RULES) {
            this.ruleCreateNoConfig(ruleClass);
            this.ruleCreateWrongObject(ruleClass);
            this.ruleCreateBoolean(ruleClass);
            this.ruleCreateElement(ruleClass);
            this.ruleInit(ruleClass);
        }
    }

    @Test
    public void testRuleInitOnly() {
        for (Class<? extends PlacementRule> ruleClass : NO_CONFIG_RULES) {
            this.ruleInit(ruleClass);
        }
    }

    private void ruleCreateNoConfig(Class<? extends PlacementRule> ruleClass) {
        PlacementRule rule = PlacementFactory.getPlacementRule(ruleClass, null);
        String name = ruleClass.getName();
        Assert.assertNotNull((String)("Rule object should not be null for " + name), (Object)rule);
    }

    private void ruleCreateWrongObject(Class<? extends PlacementRule> ruleClass) {
        PlacementRule rule = PlacementFactory.getPlacementRule(ruleClass, (Object)"a string object");
        String name = ruleClass.getName();
        Assert.assertNotNull((String)("Rule object should not be null for " + name), (Object)rule);
    }

    private void ruleCreateBoolean(Class<? extends PlacementRule> ruleClass) {
        PlacementRule rule = PlacementFactory.getPlacementRule(ruleClass, (Object)true);
        String name = ruleClass.getName();
        Assert.assertNotNull((String)("Rule object should not be null for " + name), (Object)rule);
        Assert.assertTrue((String)("Create flag was not set to true on " + name), (boolean)this.getCreateFlag(rule));
        rule = PlacementFactory.getPlacementRule(ruleClass, (Object)false);
        Assert.assertNotNull((String)("Rule object should not be null for " + name), (Object)rule);
        Assert.assertFalse((String)("Create flag was not set to false on " + name), (boolean)this.getCreateFlag(rule));
    }

    private void ruleCreateElement(Class<? extends PlacementRule> ruleClass) {
        String str = "<rule name='not used' create=\"true\" />";
        Element conf = this.createConf(str);
        PlacementRule rule = PlacementFactory.getPlacementRule(ruleClass, (Object)conf);
        String name = ruleClass.getName();
        Assert.assertNotNull((String)("Rule object should not be null for " + name), (Object)rule);
        Assert.assertTrue((String)("Create flag was not set to true on " + name), (boolean)this.getCreateFlag(rule));
        str = "<rule name='not used' create=\"false\" />";
        conf = this.createConf(str);
        rule = PlacementFactory.getPlacementRule(ruleClass, (Object)conf);
        Assert.assertNotNull((String)("Rule object should not be null for " + name), (Object)rule);
        Assert.assertFalse((String)("Create flag was not set to false on " + name), (boolean)this.getCreateFlag(rule));
    }

    private void ruleInit(Class<? extends PlacementRule> ruleClass) {
        PlacementRule rule = PlacementFactory.getPlacementRule(ruleClass, null);
        String name = ruleClass.getName();
        Assert.assertNotNull((String)("Rule object should not be null for " + name), (Object)rule);
        try {
            rule.initialize((ResourceScheduler)this.scheduler);
        }
        catch (IOException ioe) {
            Assert.fail((String)("Unexpected exception on initialize of rule " + name));
        }
        ((FSPlacementRule)rule).setParentRule(rule);
        boolean exceptionThrown = false;
        try {
            rule.initialize((ResourceScheduler)this.scheduler);
        }
        catch (IOException ioe) {
            exceptionThrown = true;
        }
        Assert.assertTrue((String)("Initialize with parent rule should have thrown exception " + name), (boolean)exceptionThrown);
    }

    private Element createConf(String str) {
        Document doc = null;
        try {
            DocumentBuilderFactory docBuilderFactory = XMLUtils.newSecureDocumentBuilderFactory();
            docBuilderFactory.setIgnoringComments(true);
            DocumentBuilder builder = docBuilderFactory.newDocumentBuilder();
            doc = builder.parse(IOUtils.toInputStream((String)str, (Charset)StandardCharsets.UTF_8));
        }
        catch (Exception ex) {
            Assert.fail((String)"Element creation failed, failing test");
        }
        return doc.getDocumentElement();
    }

    private boolean getCreateFlag(PlacementRule rule) {
        if (rule instanceof FSPlacementRule) {
            return ((FSPlacementRule)rule).createQueue;
        }
        Assert.fail((String)"Rule is not a FSPlacementRule");
        return false;
    }
}

