/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.placement;

import java.io.IOException;
import java.util.Collections;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.GroupMappingServiceProvider;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.placement.ApplicationPlacementContext;
import org.apache.hadoop.yarn.server.resourcemanager.placement.CSMappingPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.MockQueueHierarchyBuilder;
import org.apache.hadoop.yarn.server.resourcemanager.placement.QueueMapping;
import org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule.MappingRule;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerQueueManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.SimpleGroupsMapping;
import org.apache.hadoop.yarn.util.Records;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestAppNameMappingPlacementRule {
    private static final String ROOT_QUEUE = "root";
    private static final String Q2_QUEUE = "q2";
    private static final String Q1_QUEUE = "q1";
    private static final String USER_NAME = "user";
    private static final String DEFAULT_QUEUE = "default";
    private static final String APPLICATION_PLACEHOLDER = "%application";
    private static final String AMBIGUOUS_QUEUE = "ambiguousQueue";
    private static final String APP_NAME = "DistributedShell";
    private static final String MAPREDUCE_APP_NAME = "MAPREDUCE";
    private YarnConfiguration conf = new YarnConfiguration();

    @Before
    public void setup() {
        this.conf.setClass("hadoop.security.group.mapping", SimpleGroupsMapping.class, GroupMappingServiceProvider.class);
    }

    private void createQueueHierarchy(CapacitySchedulerQueueManager queueManager) {
        MockQueueHierarchyBuilder.create().withQueueManager(queueManager).withQueue("root.q1").withQueue("root.q2").withQueue("root.default").withQueue("root.ambiguousQueue").withQueue("root.user.ambiguousQueue").build();
        Mockito.when((Object)queueManager.getQueue((String)ArgumentMatchers.isNull())).thenReturn(null);
    }

    private void verifyQueueMapping(QueueMapping queueMapping, String user, String expectedQueue) throws IOException, YarnException {
        this.verifyQueueMapping(queueMapping, user, queueMapping.getQueue(), expectedQueue, false);
    }

    private void verifyQueueMapping(QueueMapping queueMapping, String user, String inputQueue, String expectedQueue, boolean overwrite) throws IOException, YarnException {
        MappingRule rule = MappingRule.createLegacyRule((String)queueMapping.getType().toString(), (String)queueMapping.getSource(), (String)queueMapping.getFullPath());
        CSMappingPlacementRule engine = this.setupEngine(rule, overwrite);
        ApplicationSubmissionContext asc = (ApplicationSubmissionContext)Records.newRecord(ApplicationSubmissionContext.class);
        if (inputQueue.equals(APPLICATION_PLACEHOLDER)) {
            inputQueue = APP_NAME;
        }
        asc.setQueue(inputQueue);
        String appName = queueMapping.getSource();
        if (appName.equals(APPLICATION_PLACEHOLDER) || appName.equals(MAPREDUCE_APP_NAME)) {
            appName = APP_NAME;
        }
        asc.setApplicationName(appName);
        ApplicationPlacementContext ctx = engine.getPlacementForApp(asc, user);
        Assert.assertEquals((Object)expectedQueue, (Object)(ctx != null ? ctx.getQueue() : inputQueue));
    }

    CSMappingPlacementRule setupEngine(MappingRule rule, boolean override) throws IOException {
        CapacitySchedulerConfiguration csConf = (CapacitySchedulerConfiguration)Mockito.mock(CapacitySchedulerConfiguration.class);
        Mockito.when((Object)csConf.getMappingRules()).thenReturn(Collections.singletonList(rule));
        Mockito.when((Object)csConf.getOverrideWithQueueMappings()).thenReturn((Object)override);
        CapacitySchedulerQueueManager queueManager = (CapacitySchedulerQueueManager)Mockito.mock(CapacitySchedulerQueueManager.class);
        this.createQueueHierarchy(queueManager);
        CSMappingPlacementRule engine = new CSMappingPlacementRule();
        Groups groups = new Groups((Configuration)this.conf);
        CapacityScheduler cs = (CapacityScheduler)Mockito.mock(CapacityScheduler.class);
        Mockito.when((Object)cs.getConfiguration()).thenReturn((Object)csConf);
        Mockito.when((Object)cs.getCapacitySchedulerQueueManager()).thenReturn((Object)queueManager);
        engine.setGroups(groups);
        engine.setFailOnConfigError(false);
        engine.initialize((ResourceScheduler)cs);
        return engine;
    }

    public QueueMapping getQueueMapping(String source, String queue) {
        return this.getQueueMapping(source, null, queue);
    }

    public QueueMapping getQueueMapping(String source, String parent, String queue) {
        return QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.APPLICATION).source(source).queue(queue).parentQueue(parent).build();
    }

    @Test
    public void testSpecificAppNameMappedToDefinedQueue() throws IOException, YarnException {
        this.verifyQueueMapping(this.getQueueMapping(APP_NAME, Q1_QUEUE), USER_NAME, Q1_QUEUE);
    }

    @Test
    public void testPlaceholderAppSourceMappedToQueue() throws IOException, YarnException {
        this.verifyQueueMapping(this.getQueueMapping(APPLICATION_PLACEHOLDER, Q2_QUEUE), USER_NAME, Q2_QUEUE);
    }

    @Test
    public void testPlaceHolderAppSourceAndQueueMappedToAppNameQueue() throws IOException, YarnException {
        this.verifyQueueMapping(this.getQueueMapping(APPLICATION_PLACEHOLDER, APPLICATION_PLACEHOLDER), USER_NAME, APP_NAME);
    }

    @Test
    public void testQueueInMappingOverridesSpecifiedQueue() throws IOException, YarnException {
        this.verifyQueueMapping(this.getQueueMapping(APP_NAME, Q1_QUEUE), USER_NAME, Q2_QUEUE, Q1_QUEUE, true);
    }

    @Test
    public void testQueueInMappingDoesNotOverrideSpecifiedQueue() throws IOException, YarnException {
        this.verifyQueueMapping(this.getQueueMapping(APP_NAME, Q1_QUEUE), USER_NAME, Q2_QUEUE, Q2_QUEUE, false);
    }

    @Test
    public void testDefaultQueueInMappingIsNotUsedWithoutOverride() throws IOException, YarnException {
        this.verifyQueueMapping(this.getQueueMapping(APP_NAME, DEFAULT_QUEUE), USER_NAME, Q2_QUEUE, Q2_QUEUE, false);
    }

    @Test
    public void testDefaultQueueInMappingEqualsToInputQueue() throws IOException, YarnException {
        this.verifyQueueMapping(this.getQueueMapping(APP_NAME, DEFAULT_QUEUE), USER_NAME, DEFAULT_QUEUE, DEFAULT_QUEUE, false);
    }

    @Test
    public void testMappingSourceDiffersFromInputQueue() throws IOException, YarnException {
        this.verifyQueueMapping(this.getQueueMapping(MAPREDUCE_APP_NAME, Q1_QUEUE), USER_NAME, DEFAULT_QUEUE, DEFAULT_QUEUE, false);
    }

    @Test
    public void testMappingContainsAmbiguousLeafQueueWithoutParent() throws IOException, YarnException {
        this.verifyQueueMapping(this.getQueueMapping(APP_NAME, AMBIGUOUS_QUEUE), USER_NAME, DEFAULT_QUEUE, DEFAULT_QUEUE, false);
    }

    @Test
    public void testMappingContainsAmbiguousLeafQueueWithParent() throws IOException, YarnException {
        this.verifyQueueMapping(this.getQueueMapping(APP_NAME, ROOT_QUEUE, AMBIGUOUS_QUEUE), USER_NAME, DEFAULT_QUEUE, AMBIGUOUS_QUEUE, false);
    }
}

