/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.metrics.TimelineServiceV1Publisher;
import org.apache.hadoop.yarn.server.resourcemanager.metrics.TimelineServiceV2Publisher;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.MemoryRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.timelineservice.storage.FileSystemTimelineWriterImpl;
import org.apache.hadoop.yarn.server.timelineservice.storage.TimelineWriter;
import org.junit.Assert;
import org.junit.Test;

public class TestRMTimelineService {
    private static MockRM rm;

    private void setup(boolean v1Enabled, boolean v2Enabled, boolean systemMetricEnabled) {
        YarnConfiguration conf = new YarnConfiguration(new Configuration(false));
        Assert.assertFalse((boolean)YarnConfiguration.timelineServiceEnabled((Configuration)conf));
        conf.setBoolean("yarn.system-metrics-publisher.enabled", systemMetricEnabled);
        if (v1Enabled || v2Enabled) {
            conf.setBoolean("yarn.timeline-service.enabled", true);
        }
        if (v1Enabled) {
            conf.setFloat("yarn.timeline-service.version", 1.0f);
        }
        if (v2Enabled) {
            conf.setFloat("yarn.timeline-service.version", 2.0f);
            conf.setClass("yarn.timeline-service.writer.class", FileSystemTimelineWriterImpl.class, TimelineWriter.class);
        }
        if (v1Enabled && v2Enabled) {
            conf.set("yarn.timeline-service.version", "1.0");
            conf.set("yarn.timeline-service.versions", "1.0,2.0f");
        }
        MemoryRMStateStore memStore = new MemoryRMStateStore();
        memStore.init((Configuration)conf);
        rm = new MockRM((Configuration)conf, (RMStateStore)memStore);
        rm.start();
    }

    private void validate(boolean v1Enabled, boolean v2Enabled, boolean systemMetricEnabled) {
        boolean v1PublisherServiceFound = false;
        boolean v2PublisherServiceFound = false;
        List services = rm.getServices();
        for (Service service : services) {
            if (service instanceof TimelineServiceV1Publisher) {
                v1PublisherServiceFound = true;
                continue;
            }
            if (!(service instanceof TimelineServiceV2Publisher)) continue;
            v2PublisherServiceFound = true;
        }
        if (systemMetricEnabled) {
            Assert.assertEquals((Object)v1Enabled, (Object)v1PublisherServiceFound);
            Assert.assertEquals((Object)v2Enabled, (Object)v2PublisherServiceFound);
        } else {
            Assert.assertEquals((Object)false, (Object)v1PublisherServiceFound);
            Assert.assertEquals((Object)false, (Object)v2PublisherServiceFound);
        }
    }

    private void cleanup() throws Exception {
        rm.close();
        rm.stop();
    }

    private void runTest(boolean v1Enabled, boolean v2Enabled, boolean systemMetricEnabled) throws Exception {
        this.setup(v1Enabled, v2Enabled, systemMetricEnabled);
        this.validate(v1Enabled, v2Enabled, systemMetricEnabled);
        this.cleanup();
    }

    @Test
    public void testTimelineServiceV1V2Enabled() throws Exception {
        this.runTest(true, true, true);
    }

    @Test
    public void testTimelineServiceV1Enabled() throws Exception {
        this.runTest(true, false, true);
    }

    @Test
    public void testTimelineServiceV2Enabled() throws Exception {
        this.runTest(false, true, true);
    }

    @Test
    public void testTimelineServiceDisabled() throws Exception {
        this.runTest(false, false, true);
    }

    @Test
    public void testTimelineServiceV1V2EnabledSystemMetricDisable() throws Exception {
        this.runTest(true, true, false);
    }

    @Test
    public void testTimelineServiceV1EnabledSystemMetricDisable() throws Exception {
        this.runTest(true, false, false);
    }

    @Test
    public void testTimelineServiceV2EnabledSystemMetricDisable() throws Exception {
        this.runTest(false, true, false);
    }

    @Test
    public void testTimelineServiceDisabledSystemMetricDisable() throws Exception {
        this.runTest(false, false, false);
    }
}

