/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.ClusterMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestRMHAMetrics {
    private Configuration configuration;
    private static final String RM1_ADDRESS = "1.1.1.1:1";
    private static final String RM1_NODE_ID = "rm1";
    private static final String RM2_ADDRESS = "0.0.0.0:0";
    private static final String RM2_NODE_ID = "rm2";

    @Before
    public void setUp() throws Exception {
        this.configuration = new Configuration();
        UserGroupInformation.setConfiguration((Configuration)this.configuration);
        this.configuration.setBoolean("yarn.resourcemanager.ha.enabled", true);
        this.configuration.set("yarn.resourcemanager.ha.rm-ids", "rm1,rm2");
        for (String confKey : YarnConfiguration.getServiceAddressConfKeys((Configuration)this.configuration)) {
            this.configuration.set(HAUtil.addSuffix((String)confKey, (String)RM1_NODE_ID), RM1_ADDRESS);
            this.configuration.set(HAUtil.addSuffix((String)confKey, (String)RM2_NODE_ID), RM2_ADDRESS);
        }
        ClusterMetrics.destroy();
        QueueMetrics.clearQueueMetrics();
        DefaultMetricsSystem.shutdown();
    }

    @Test(timeout=300000L)
    public void testMetricsAfterTransitionToStandby() throws Exception {
        this.configuration.setBoolean("yarn.resourcemanager.ha.automatic-failover.enabled", false);
        YarnConfiguration conf = new YarnConfiguration(this.configuration);
        MockRM rm = new MockRM((Configuration)conf);
        rm.init((Configuration)conf);
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        ObjectName mxbeanName = new ObjectName("Hadoop:service=ResourceManager,name=RMInfo");
        Assert.assertEquals((Object)"initializing", (Object)((String)mbs.getAttribute(mxbeanName, "State")));
        rm.start();
        Assert.assertEquals((Object)"standby", (Object)((String)mbs.getAttribute(mxbeanName, "State")));
        rm.transitionToActive();
        Assert.assertEquals((Object)"active", (Object)((String)mbs.getAttribute(mxbeanName, "State")));
        rm.transitionToStandby(true);
        Assert.assertEquals((Object)"standby", (Object)((String)mbs.getAttribute(mxbeanName, "State")));
        TestCase.assertNotNull((Object)DefaultMetricsSystem.instance().getSource("JvmMetrics"));
        TestCase.assertNotNull((Object)DefaultMetricsSystem.instance().getSource("UgiMetrics"));
        rm.stop();
    }
}

