/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewReservationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewReservationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationDeleteRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationListRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationListResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationSubmissionRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationSubmissionResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationUpdateRequest;
import org.apache.hadoop.yarn.api.records.ReservationACL;
import org.apache.hadoop.yarn.api.records.ReservationAllocationState;
import org.apache.hadoop.yarn.api.records.ReservationDefinition;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.ReservationRequest;
import org.apache.hadoop.yarn.api.records.ReservationRequestInterpreter;
import org.apache.hadoop.yarn.api.records.ReservationRequests;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.ACLsTestBase;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.Plan;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairSchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.allocationfile.AllocationFileQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.allocationfile.AllocationFileWriter;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ReservationACLsTestBase
extends ACLsTestBase {
    private final int defaultDuration = 600000;
    private final ReservationRequest defaultRequest = ReservationRequest.newInstance((Resource)Resources.createResource((int)1024), (int)1, (int)1, (long)600000L);
    private final ReservationRequests defaultRequests = ReservationRequests.newInstance(Collections.singletonList(this.defaultRequest), (ReservationRequestInterpreter)ReservationRequestInterpreter.R_ALL);
    private Configuration configuration;
    private boolean useFullQueuePath;

    public ReservationACLsTestBase(Configuration conf, boolean useFullPath) {
        this.configuration = conf;
        this.useFullQueuePath = useFullPath;
    }

    @After
    public void tearDown() {
        if (this.resourceManager != null) {
            this.resourceManager.stop();
        }
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() throws IOException {
        return Arrays.asList({ReservationACLsTestBase.createCapacitySchedulerConfiguration(), true}, {ReservationACLsTestBase.createFairSchedulerConfiguration(), true});
    }

    @Test
    public void testApplicationACLs() throws Exception {
        this.registerNode("test:1234", 8192, 8);
        String queueA = !this.useFullQueuePath ? "queueA" : "root.queueA";
        String queueB = !this.useFullQueuePath ? "queueB" : "root.queueB";
        String queueC = !this.useFullQueuePath ? "queueC" : "root.queueC";
        this.verifySubmitReservationSuccess("queueA_user", queueA);
        this.verifySubmitReservationSuccess("queueA_admin", queueA);
        this.verifySubmitReservationFailure("queueB_user", queueA);
        this.verifySubmitReservationFailure("queueB_admin", queueA);
        this.verifySubmitReservationSuccess("queueB_user", queueB);
        this.verifySubmitReservationSuccess("queueB_admin", queueB);
        this.verifySubmitReservationFailure("queueA_user", queueB);
        this.verifySubmitReservationFailure("queueA_admin", queueB);
        this.verifySubmitReservationSuccess("queueB_user", queueC);
        this.verifySubmitReservationSuccess("queueB_admin", queueC);
        this.verifySubmitReservationSuccess("queueA_user", queueC);
        this.verifySubmitReservationSuccess("queueA_admin", queueC);
        this.verifySubmitReservationSuccess("common_user", queueC);
        this.verifyListReservationSuccess("queueA_admin", "queueA_user", queueA);
        this.verifyListReservationSuccess("common_user", "queueA_admin", queueA);
        this.verifyListReservationSuccess("common_user", "queueA_user", queueA);
        this.verifyListReservationSuccess("queueA_admin", "queueA_admin", queueA);
        this.verifyListReservationFailure("queueA_user", "queueA_user", queueA);
        this.verifyListReservationFailure("queueA_user", "queueA_admin", queueA);
        this.verifyListReservationByIdSuccess("queueA_user", "queueA_user", queueA);
        this.verifyListReservationByIdFailure("queueA_user", "queueA_admin", queueA);
        this.verifyListReservationSuccess("queueB_admin", "queueB_user", queueB);
        this.verifyListReservationSuccess("common_user", "queueB_admin", queueB);
        this.verifyListReservationSuccess("common_user", "queueB_user", queueB);
        this.verifyListReservationSuccess("queueB_admin", "queueB_admin", queueB);
        this.verifyListReservationFailure("queueB_user", "queueB_user", queueB);
        this.verifyListReservationFailure("queueB_user", "queueB_admin", queueB);
        this.verifyListReservationByIdSuccess("queueB_user", "queueB_user", queueB);
        this.verifyListReservationByIdFailure("queueB_user", "queueB_admin", queueB);
        this.verifyListReservationFailure("queueB_admin", "queueA_admin", queueA);
        this.verifyListReservationFailure("queueB_admin", "queueA_user", queueA);
        this.verifyListReservationFailure("queueA_admin", "queueB_admin", queueB);
        this.verifyListReservationFailure("queueA_admin", "queueB_user", queueB);
        this.verifyListReservationSuccess("queueA_user", "queueA_admin", queueC);
        this.verifyListReservationSuccess("queueB_user", "queueA_admin", queueC);
        this.verifyListReservationSuccess("queueB_admin", "queueA_admin", queueC);
        this.verifyListReservationSuccess("common_user", "queueA_admin", queueC);
        this.verifyListReservationSuccess("queueA_admin", "queueA_user", queueC);
        this.verifyListReservationSuccess("queueB_user", "queueA_user", queueC);
        this.verifyListReservationSuccess("queueB_admin", "queueA_user", queueC);
        this.verifyListReservationSuccess("common_user", "queueA_user", queueC);
        this.verifyListReservationByIdSuccess("queueA_user", "queueA_admin", queueC);
        this.verifyListReservationByIdSuccess("queueB_user", "queueA_admin", queueC);
        this.verifyListReservationByIdSuccess("queueB_admin", "queueA_admin", queueC);
        this.verifyListReservationByIdSuccess("common_user", "queueA_admin", queueC);
        this.verifyListReservationByIdSuccess("queueA_admin", "queueA_user", queueC);
        this.verifyListReservationByIdSuccess("queueB_user", "queueA_user", queueC);
        this.verifyListReservationByIdSuccess("queueB_admin", "queueA_user", queueC);
        this.verifyListReservationByIdSuccess("common_user", "queueA_user", queueC);
        this.verifyDeleteReservationSuccess("queueA_user", "queueA_user", queueA);
        this.verifyDeleteReservationSuccess("queueA_admin", "queueA_user", queueA);
        this.verifyDeleteReservationFailure("common_user", "queueA_user", queueA);
        this.verifyDeleteReservationFailure("queueB_user", "queueA_user", queueA);
        this.verifyDeleteReservationFailure("queueB_admin", "queueA_user", queueA);
        this.verifyDeleteReservationSuccess("queueB_user", "queueB_user", queueB);
        this.verifyDeleteReservationSuccess("queueB_admin", "queueB_user", queueB);
        this.verifyDeleteReservationFailure("common_user", "queueB_user", queueB);
        this.verifyDeleteReservationFailure("queueA_user", "queueB_user", queueB);
        this.verifyDeleteReservationFailure("queueA_admin", "queueB_user", queueB);
        this.verifyDeleteReservationSuccess("common_user", "queueB_admin", queueC);
        this.verifyDeleteReservationSuccess("queueB_user", "queueB_admin", queueC);
        this.verifyDeleteReservationSuccess("queueB_admin", "queueB_admin", queueC);
        this.verifyDeleteReservationSuccess("queueA_user", "queueB_admin", queueC);
        this.verifyDeleteReservationSuccess("queueA_admin", "queueB_admin", queueC);
        this.verifyUpdateReservationSuccess("queueA_user", "queueA_user", queueA);
        this.verifyUpdateReservationSuccess("queueA_admin", "queueA_user", queueA);
        this.verifyUpdateReservationFailure("common_user", "queueA_user", queueA);
        this.verifyUpdateReservationFailure("queueB_user", "queueA_user", queueA);
        this.verifyUpdateReservationFailure("queueB_admin", "queueA_user", queueA);
        this.verifyUpdateReservationSuccess("queueB_user", "queueB_user", queueB);
        this.verifyUpdateReservationSuccess("queueB_admin", "queueB_user", queueB);
        this.verifyUpdateReservationFailure("common_user", "queueB_user", queueB);
        this.verifyUpdateReservationFailure("queueA_user", "queueB_user", queueB);
        this.verifyUpdateReservationFailure("queueA_admin", "queueB_user", queueB);
        this.verifyUpdateReservationSuccess("common_user", "queueB_admin", queueC);
        this.verifyUpdateReservationSuccess("queueB_user", "queueB_admin", queueC);
        this.verifyUpdateReservationSuccess("queueB_admin", "queueB_admin", queueC);
        this.verifyUpdateReservationSuccess("queueA_user", "queueB_admin", queueC);
        this.verifyUpdateReservationSuccess("queueA_admin", "queueB_admin", queueC);
    }

    private void verifySubmitReservationSuccess(String submitter, String queueName) throws Exception {
        ReservationId reservationId = this.createReservation(submitter);
        this.submitReservation(submitter, queueName, reservationId);
        this.deleteReservation(submitter, reservationId);
    }

    private void verifySubmitReservationFailure(String submitter, String queueName) throws Exception {
        try {
            ReservationId reservationId = this.createReservation(submitter);
            this.submitReservation(submitter, queueName, reservationId);
            Assert.fail((String)"Submit reservation by the enemy should fail!");
        }
        catch (YarnException e) {
            this.handleAdministerException((Exception)((Object)e), submitter, queueName, ReservationACL.SUBMIT_RESERVATIONS.name());
        }
    }

    private void verifyListReservationSuccess(String lister, String originalSubmitter, String queueName) throws Exception {
        ReservationId reservationId = this.createReservation(originalSubmitter);
        this.submitReservation(originalSubmitter, queueName, reservationId);
        ReservationListResponse adminResponse = this.listReservation(lister, queueName);
        assert (adminResponse.getReservationAllocationState().size() == 1);
        assert (((ReservationAllocationState)adminResponse.getReservationAllocationState().get(0)).getUser().equals(originalSubmitter));
        this.deleteReservation(originalSubmitter, reservationId);
    }

    private void verifyListReservationFailure(String lister, String originalSubmitter, String queueName) throws Exception {
        ReservationId reservationId = this.createReservation(originalSubmitter);
        this.submitReservation(originalSubmitter, queueName, reservationId);
        try {
            this.listReservation(lister, queueName);
            Assert.fail((String)"List reservation by the enemy should fail!");
        }
        catch (YarnException e) {
            this.handleAdministerException((Exception)((Object)e), lister, queueName, ReservationACL.LIST_RESERVATIONS.name());
        }
        this.deleteReservation(originalSubmitter, reservationId);
    }

    private void verifyListReservationByIdSuccess(String lister, String originalSubmitter, String queueName) throws Exception {
        ReservationId reservationId = this.createReservation(originalSubmitter);
        this.submitReservation(originalSubmitter, queueName, reservationId);
        ReservationListResponse adminResponse = this.listReservationById(lister, reservationId, queueName);
        assert (adminResponse.getReservationAllocationState().size() == 1);
        assert (((ReservationAllocationState)adminResponse.getReservationAllocationState().get(0)).getUser().equals(originalSubmitter));
        this.deleteReservation(originalSubmitter, reservationId);
    }

    private void verifyListReservationByIdFailure(String lister, String originalSubmitter, String queueName) throws Exception {
        ReservationId reservationId = this.createReservation(originalSubmitter);
        this.submitReservation(originalSubmitter, queueName, reservationId);
        try {
            this.listReservationById(lister, reservationId, queueName);
            Assert.fail((String)"List reservation by the enemy should fail!");
        }
        catch (YarnException e) {
            this.handleAdministerException((Exception)((Object)e), lister, queueName, ReservationACL.LIST_RESERVATIONS.name());
        }
        this.deleteReservation(originalSubmitter, reservationId);
    }

    private void verifyDeleteReservationSuccess(String killer, String originalSubmitter, String queueName) throws Exception {
        ReservationId reservationId = this.createReservation(originalSubmitter);
        this.submitReservation(originalSubmitter, queueName, reservationId);
        this.deleteReservation(killer, reservationId);
    }

    private void verifyDeleteReservationFailure(String killer, String originalSubmitter, String queueName) throws Exception {
        ReservationId reservationId = this.createReservation(originalSubmitter);
        this.submitReservation(originalSubmitter, queueName, reservationId);
        try {
            this.deleteReservation(killer, reservationId);
            Assert.fail((String)"Reservation deletion by the enemy should fail!");
        }
        catch (YarnException e) {
            this.handleAdministerException((Exception)((Object)e), killer, queueName, ReservationACL.ADMINISTER_RESERVATIONS.name());
        }
        this.deleteReservation(originalSubmitter, reservationId);
    }

    private void verifyUpdateReservationSuccess(String updater, String originalSubmitter, String queueName) throws Exception {
        ReservationId reservationId = this.createReservation(originalSubmitter);
        this.submitReservation(originalSubmitter, queueName, reservationId);
        ReservationUpdateRequest updateRequest = ReservationUpdateRequest.newInstance((ReservationDefinition)this.makeSimpleReservationDefinition(), (ReservationId)reservationId);
        ApplicationClientProtocol ownerClient = this.getRMClientForUser(updater);
        ownerClient.updateReservation(updateRequest);
        this.deleteReservation(updater, reservationId);
    }

    private void verifyUpdateReservationFailure(String updater, String originalSubmitter, String queueName) throws Exception {
        ReservationId reservationId = this.createReservation(originalSubmitter);
        this.submitReservation(originalSubmitter, queueName, reservationId);
        ReservationUpdateRequest updateRequest = ReservationUpdateRequest.newInstance((ReservationDefinition)this.makeSimpleReservationDefinition(), (ReservationId)reservationId);
        ApplicationClientProtocol unauthorizedClient = this.getRMClientForUser(updater);
        try {
            unauthorizedClient.updateReservation(updateRequest);
            Assert.fail((String)"Reservation updating by the enemy should fail.");
        }
        catch (YarnException e) {
            this.handleAdministerException((Exception)((Object)e), updater, queueName, ReservationACL.ADMINISTER_RESERVATIONS.name());
        }
        this.deleteReservation(originalSubmitter, reservationId);
    }

    private ReservationDefinition makeSimpleReservationDefinition() {
        long arrival = System.currentTimeMillis();
        String reservationName = UUID.randomUUID().toString();
        return ReservationDefinition.newInstance((long)arrival, (long)(arrival + 660000L), (ReservationRequests)this.defaultRequests, (String)reservationName);
    }

    private ReservationListResponse listReservationById(String lister, ReservationId reservationId, String queueName) throws Exception {
        ReservationListRequest listRequest = ReservationListRequest.newInstance((String)queueName, (String)reservationId.toString(), (long)-1L, (long)-1L, (boolean)false);
        ApplicationClientProtocol ownerClient = this.getRMClientForUser(lister);
        return ownerClient.listReservations(listRequest);
    }

    private ReservationListResponse listReservation(String lister, String queueName) throws Exception {
        ReservationListRequest listRequest = ReservationListRequest.newInstance((String)queueName, null, (long)-1L, (long)-1L, (boolean)false);
        ApplicationClientProtocol ownerClient = this.getRMClientForUser(lister);
        return ownerClient.listReservations(listRequest);
    }

    private void deleteReservation(String deleter, ReservationId id) throws Exception {
        ApplicationClientProtocol deleteClient = this.getRMClientForUser(deleter);
        ReservationDeleteRequest deleteRequest = ReservationDeleteRequest.newInstance((ReservationId)id);
        deleteClient.deleteReservation(deleteRequest);
    }

    private ReservationId createReservation(String creator) throws Exception {
        ApplicationClientProtocol creatorClient = this.getRMClientForUser(creator);
        GetNewReservationRequest getNewReservationRequest = GetNewReservationRequest.newInstance();
        GetNewReservationResponse response = creatorClient.getNewReservation(getNewReservationRequest);
        return response.getReservationId();
    }

    private void submitReservation(String submitter, String queueName, ReservationId reservationId) throws Exception {
        ApplicationClientProtocol submitterClient = this.getRMClientForUser(submitter);
        ReservationSubmissionRequest reservationSubmissionRequest = ReservationSubmissionRequest.newInstance((ReservationDefinition)this.makeSimpleReservationDefinition(), (String)queueName, (ReservationId)reservationId);
        ReservationSubmissionResponse response = submitterClient.submitReservation(reservationSubmissionRequest);
    }

    private void handleAdministerException(Exception e, String user, String queue, String operation) {
        LOG.info("Got exception while killing app as the enemy", (Throwable)e);
        Assert.assertTrue((boolean)e.getMessage().contains("User " + user + " cannot perform operation " + operation + " on queue " + queue));
    }

    private void registerNode(String host, int memory, int vCores) throws Exception {
        try {
            this.resourceManager.registerNode(host, memory, vCores);
            int attempts = 10;
            do {
                this.resourceManager.drainEvents();
                LOG.info("Waiting for node capacity to be added to plan");
                Collection<Plan> plans = this.resourceManager.getRMContext().getReservationSystem().getAllPlans().values();
                if (this.checkCapacity(plans)) break;
                Thread.sleep(100L);
            } while (attempts-- > 0);
            if (attempts <= 0) {
                Assert.fail((String)"Exhausted attempts in checking if node capacity was added to the plan");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    private boolean checkCapacity(Collection<Plan> plans) {
        for (Plan plan : plans) {
            if (plan.getTotalCapacity().getMemorySize() <= 0L) continue;
            return true;
        }
        return false;
    }

    private static Configuration createCapacitySchedulerConfiguration() {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        csConf.setQueues("root", new String[]{"queueA", "queueB", "queueC"});
        String absoluteQueueA = "root.queueA";
        String absoluteQueueB = "root.queueB";
        String absoluteQueueC = "root.queueC";
        csConf.setCapacity(absoluteQueueA, 50.0f);
        csConf.setCapacity(absoluteQueueB, 20.0f);
        csConf.setCapacity(absoluteQueueC, 30.0f);
        csConf.setReservable(absoluteQueueA, true);
        csConf.setReservable(absoluteQueueB, true);
        csConf.setReservable(absoluteQueueC, true);
        HashMap<ReservationACL, AccessControlList> reservationAclsOnQueueA = new HashMap<ReservationACL, AccessControlList>();
        AccessControlList submitACLonQueueA = new AccessControlList("queueA_user");
        AccessControlList adminACLonQueueA = new AccessControlList("queueA_admin");
        AccessControlList listACLonQueueA = new AccessControlList("common_user");
        reservationAclsOnQueueA.put(ReservationACL.SUBMIT_RESERVATIONS, submitACLonQueueA);
        reservationAclsOnQueueA.put(ReservationACL.ADMINISTER_RESERVATIONS, adminACLonQueueA);
        reservationAclsOnQueueA.put(ReservationACL.LIST_RESERVATIONS, listACLonQueueA);
        csConf.setReservationAcls(absoluteQueueA, reservationAclsOnQueueA);
        HashMap<ReservationACL, AccessControlList> reservationAclsOnQueueB = new HashMap<ReservationACL, AccessControlList>();
        AccessControlList submitACLonQueueB = new AccessControlList("queueB_user");
        AccessControlList adminACLonQueueB = new AccessControlList("queueB_admin");
        AccessControlList listACLonQueueB = new AccessControlList("common_user");
        reservationAclsOnQueueB.put(ReservationACL.SUBMIT_RESERVATIONS, submitACLonQueueB);
        reservationAclsOnQueueB.put(ReservationACL.ADMINISTER_RESERVATIONS, adminACLonQueueB);
        reservationAclsOnQueueB.put(ReservationACL.LIST_RESERVATIONS, listACLonQueueB);
        csConf.setReservationAcls(absoluteQueueB, reservationAclsOnQueueB);
        csConf.setBoolean("yarn.resourcemanager.reservation-system.enable", true);
        csConf.setBoolean("yarn.acl.enable", true);
        csConf.setBoolean("yarn.acl.reservation-enable", true);
        csConf.set("yarn.resourcemanager.scheduler.class", CapacityScheduler.class.getName());
        return csConf;
    }

    private static Configuration createFairSchedulerConfiguration() {
        FairSchedulerConfiguration fsConf = new FairSchedulerConfiguration();
        String testDir = new File(System.getProperty("test.build.data", "/tmp")).getAbsolutePath();
        String allocFile = new File(testDir, "test-queues.xml").getAbsolutePath();
        AllocationFileWriter.create().drfDefaultQueueSchedulingPolicy().addQueue(new AllocationFileQueue.Builder("queueA").aclSubmitReservations("queueA_user,common_user ").aclAdministerReservations("queueA_admin ").aclListReservations("common_user ").aclSubmitApps("queueA_user,common_user ").aclAdministerApps("queueA_admin ").reservation().build()).addQueue(new AllocationFileQueue.Builder("queueB").aclSubmitReservations("queueB_user,common_user ").aclAdministerReservations("queueB_admin ").aclListReservations("common_user ").aclSubmitApps("queueB_user,common_user ").aclAdministerApps("queueB_admin ").reservation().build()).addQueue(new AllocationFileQueue.Builder("queueC").reservation().build()).writeToFile(allocFile);
        fsConf.set("yarn.scheduler.fair.allocation.file", allocFile);
        fsConf.setBoolean("yarn.resourcemanager.reservation-system.enable", true);
        fsConf.setBoolean("yarn.acl.enable", true);
        fsConf.setBoolean("yarn.acl.reservation-enable", true);
        fsConf.set("yarn.resourcemanager.scheduler.class", FairScheduler.class.getName());
        return fsConf;
    }

    @Override
    protected Configuration createConfiguration() {
        return this.configuration;
    }
}

