/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.IOException;
import java.util.HashMap;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMAppBlock;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.TestRMWebApp;
import org.apache.hadoop.yarn.server.webapp.AppBlock;
import org.apache.hadoop.yarn.webapp.test.WebAppTests;
import org.junit.Test;
import org.mockito.Mockito;

public class TestAppPage {
    @Test
    public void testAppBlockRenderWithNullCurrentAppAttempt() throws Exception {
        ApplicationId APP_ID = ApplicationId.newInstance((long)1234L, (int)0);
        RMApp app = (RMApp)Mockito.mock(RMApp.class);
        Mockito.when((Object)app.getTrackingUrl()).thenReturn((Object)"http://host:123");
        Mockito.when((Object)app.getState()).thenReturn((Object)RMAppState.FAILED);
        Mockito.when((Object)app.getApplicationId()).thenReturn((Object)APP_ID);
        Mockito.when((Object)app.getApplicationType()).thenReturn((Object)"Type");
        Mockito.when((Object)app.getUser()).thenReturn((Object)"user");
        Mockito.when((Object)app.getName()).thenReturn((Object)"Name");
        Mockito.when((Object)app.getQueue()).thenReturn((Object)"queue");
        Mockito.when((Object)app.getDiagnostics()).thenReturn((Object)new StringBuilder());
        Mockito.when((Object)app.getFinalApplicationStatus()).thenReturn((Object)FinalApplicationStatus.FAILED);
        Mockito.when((Object)app.getFinalApplicationStatus()).thenReturn((Object)FinalApplicationStatus.FAILED);
        Mockito.when((Object)app.getStartTime()).thenReturn((Object)0L);
        Mockito.when((Object)app.getFinishTime()).thenReturn((Object)0L);
        Mockito.when((Object)app.createApplicationState()).thenReturn((Object)YarnApplicationState.FAILED);
        RMAppMetrics appMetrics = new RMAppMetrics(Resource.newInstance((int)0, (int)0), 0, 0, new HashMap(), new HashMap(), 0);
        Mockito.when((Object)app.getRMAppMetrics()).thenReturn((Object)appMetrics);
        final RMContext rmContext = TestRMWebApp.mockRMContext(15, 1, 2, 8);
        rmContext.getRMApps().put(APP_ID, app);
        Injector injector = WebAppTests.createMockInjector(RMContext.class, (Object)rmContext, (Module[])new Module[]{new Module(){

            public void configure(Binder binder) {
                try {
                    ResourceManager rm = TestRMWebApp.mockRm(rmContext);
                    binder.bind(ResourceManager.class).toInstance((Object)rm);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
        }});
        AppBlock instance = (AppBlock)injector.getInstance(RMAppBlock.class);
        instance.set("app.id", APP_ID.toString());
        instance.render();
    }
}

