/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.io.IOException;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.protocolrecords.ResourceTypes;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PlacementManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairSchedulerTestBase;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestFairSchedulerWithMultiResourceTypes
extends FairSchedulerTestBase {
    private static final String CUSTOM_RESOURCE = "custom-resource";

    @Before
    public void setUp() throws IOException {
        this.scheduler = new FairScheduler();
        this.conf = this.createConfiguration();
        this.initResourceTypes(this.conf);
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        PlacementManager placementManager = new PlacementManager();
        Mockito.when((Object)rmContext.getQueuePlacementManager()).thenReturn((Object)placementManager);
        this.scheduler.setRMContext(rmContext);
    }

    @After
    public void tearDown() {
        if (this.scheduler != null) {
            this.scheduler.stop();
            this.scheduler = null;
        }
    }

    private Configuration initResourceTypes(Configuration conf) {
        HashMap<String, ResourceInformation> riMap = new HashMap<String, ResourceInformation>();
        ResourceInformation memory = ResourceInformation.newInstance((String)ResourceInformation.MEMORY_MB.getName(), (String)ResourceInformation.MEMORY_MB.getUnits(), (long)1024L, (long)8192L);
        ResourceInformation vcores = ResourceInformation.newInstance((String)ResourceInformation.VCORES.getName(), (String)ResourceInformation.VCORES.getUnits(), (long)1L, (long)4L);
        riMap.put("memory-mb", memory);
        riMap.put("vcores", vcores);
        riMap.put(CUSTOM_RESOURCE, ResourceInformation.newInstance((String)CUSTOM_RESOURCE, (String)"", (long)0L, (ResourceTypes)ResourceTypes.COUNTABLE, (long)0L, (long)3333L));
        ResourceUtils.initializeResourcesFromResourceInformationMap(riMap);
        return conf;
    }

    @Test
    public void testMaximumAllocationRefresh() throws IOException {
        this.conf.set("yarn.resource-types", CUSTOM_RESOURCE);
        this.conf.set("yarn.resource-types.custom-resource.units", "k");
        this.conf.setInt("yarn.resource-types.custom-resource.maximum-allocation", 10000);
        this.conf.setInt("yarn.resource-types." + ResourceInformation.VCORES.getName() + ".maximum-allocation", 4);
        this.conf.setInt("yarn.resource-types." + ResourceInformation.MEMORY_MB.getName() + ".maximum-allocation", 512);
        this.scheduler.init(this.conf);
        this.scheduler.reinitialize(this.conf, null);
        Resource maxAllowedAllocation = this.scheduler.getNodeTracker().getMaxAllowedAllocation();
        ResourceInformation customResource = maxAllowedAllocation.getResourceInformation(CUSTOM_RESOURCE);
        Assert.assertEquals((long)512L, (long)maxAllowedAllocation.getMemorySize());
        Assert.assertEquals((long)4L, (long)maxAllowedAllocation.getVirtualCores());
        Assert.assertEquals((long)10000L, (long)customResource.getValue());
        this.conf = new YarnConfiguration();
        this.conf.set("yarn.resource-types", CUSTOM_RESOURCE);
        this.conf.set("yarn.resource-types.custom-resource.units", "k");
        this.conf.setInt("yarn.resource-types.custom-resource.maximum-allocation", 20000);
        this.conf.setInt("yarn.resource-types." + ResourceInformation.VCORES.getName() + ".maximum-allocation", 8);
        this.conf.setInt("yarn.resource-types." + ResourceInformation.MEMORY_MB.getName() + ".maximum-allocation", 2048);
        this.scheduler.reinitialize(this.conf, null);
        maxAllowedAllocation = this.scheduler.getNodeTracker().getMaxAllowedAllocation();
        customResource = maxAllowedAllocation.getResourceInformation(CUSTOM_RESOURCE);
        Assert.assertEquals((long)2048L, (long)maxAllowedAllocation.getMemorySize());
        Assert.assertEquals((long)8L, (long)maxAllowedAllocation.getVirtualCores());
        Assert.assertEquals((long)20000L, (long)customResource.getValue());
    }
}

