/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.thirdparty.com.google.common.collect.Maps;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.ClusterMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNodes;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmissionData;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmitter;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.NullRMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ClusterNodeTracker;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePath;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.util.resource.DominantResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestCSAllocateCustomResource {
    private YarnConfiguration conf;
    private RMNodeLabelsManager mgr;
    private File resourceTypesFile = null;
    private final int g = 1024;
    private ClusterNodeTracker<FiCaSchedulerNode> nodeTracker;
    private ClusterMetrics metrics;

    @Before
    public void setUp() throws Exception {
        this.conf = new YarnConfiguration();
        this.conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        this.mgr = new NullRMNodeLabelsManager();
        this.mgr.init((Configuration)this.conf);
    }

    @After
    public void tearDown() {
        if (this.resourceTypesFile != null && this.resourceTypesFile.exists()) {
            this.resourceTypesFile.delete();
        }
    }

    @Test
    public void testCapacitySchedulerJobWhenConfigureCustomResourceType() throws Exception {
        ResourceUtils.resetResourceTypes();
        String resourceTypesFileName = "resource-types-test.xml";
        File source = new File(this.conf.getClassLoader().getResource(resourceTypesFileName).getFile());
        this.resourceTypesFile = new File(source.getParent(), "resource-types.xml");
        FileUtils.copyFile((File)source, (File)this.resourceTypesFile);
        CapacitySchedulerConfiguration newConf = (CapacitySchedulerConfiguration)TestUtils.getConfigurationWithMultipleQueues((Configuration)this.conf);
        newConf.setClass("yarn.scheduler.capacity.resource-calculator", DominantResourceCalculator.class, ResourceCalculator.class);
        newConf.set(CapacitySchedulerConfiguration.getQueuePrefix((String)"root.a") + "maximum-allocation-mb", "4096");
        newConf.setBoolean("yarn.test.reset-resource-types", false);
        MockRM rm = new MockRM((Configuration)newConf);
        rm.start();
        String customResourceType = "yarn.io/gpu";
        Resource nodeResource = Resources.createResource((int)4096, (int)4);
        nodeResource.setResourceValue(customResourceType, 10L);
        MockNM nm1 = rm.registerNode("h1:1234", nodeResource);
        Resource amResource = Resources.createResource((int)1024, (int)1);
        amResource.setResourceValue(customResourceType, 1L);
        RMApp app1 = MockRMAppSubmitter.submit(rm, MockRMAppSubmissionData.Builder.createWithResource(amResource, rm).withAppName("app").withUser("user").withAcls(null).withQueue("a").build());
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, nm1);
        Resource cResource = Resources.createResource((int)1024, (int)1);
        amResource.setResourceValue(customResourceType, 1L);
        am1.allocate("*", cResource, 2, new ArrayList<ContainerId>(), null);
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        RMNode rmNode1 = (RMNode)rm.getRMContext().getRMNodes().get(nm1.getNodeId());
        FiCaSchedulerApp schedulerApp1 = cs.getApplicationAttempt(am1.getApplicationAttemptId());
        cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        rm.drainEvents();
        Assert.assertEquals((long)2L, (long)schedulerApp1.getLiveContainers().size());
        rm.close();
    }

    @Test
    public void testCapacitySchedulerInitWithCustomResourceType() throws IOException {
        ResourceUtils.resetResourceTypes();
        String resourceTypesFileName = "resource-types-test.xml";
        File source = new File(this.conf.getClassLoader().getResource(resourceTypesFileName).getFile());
        this.resourceTypesFile = new File(source.getParent(), "resource-types.xml");
        FileUtils.copyFile((File)source, (File)this.resourceTypesFile);
        CapacitySchedulerConfiguration newConf = (CapacitySchedulerConfiguration)TestUtils.getConfigurationWithMultipleQueues((Configuration)this.conf);
        newConf.setClass("yarn.scheduler.capacity.resource-calculator", DominantResourceCalculator.class, ResourceCalculator.class);
        MockRM rm = new MockRM((Configuration)newConf);
        rm.start();
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        Assert.assertNotEquals((long)0L, (long)ResourceUtils.fetchMaximumAllocationFromConfig((Configuration)cs.getConfiguration()).getResourceValue("yarn.io/gpu"));
        Assert.assertNotEquals((long)0L, (long)cs.getMaximumResourceCapability("a").getResourceValue("yarn.io/gpu"));
        rm.close();
    }

    @Test
    public void testClusterMetricsWithGPU() throws Exception {
        this.metrics = ClusterMetrics.getMetrics();
        ResourceUtils.resetResourceTypes();
        String resourceTypesFileName = "resource-types-test.xml";
        File source = new File(this.conf.getClassLoader().getResource(resourceTypesFileName).getFile());
        this.resourceTypesFile = new File(source.getParent(), "resource-types.xml");
        FileUtils.copyFile((File)source, (File)this.resourceTypesFile);
        CapacitySchedulerConfiguration newConf = (CapacitySchedulerConfiguration)TestUtils.getConfigurationWithMultipleQueues((Configuration)this.conf);
        newConf.setClass("yarn.scheduler.capacity.resource-calculator", DominantResourceCalculator.class, ResourceCalculator.class);
        MockRM rm = new MockRM((Configuration)newConf);
        rm.start();
        this.nodeTracker = new ClusterNodeTracker();
        MockNodes.resetHostIds();
        Resource nodeResource = Resource.newInstance((long)4096L, (int)4, Collections.singletonMap("yarn.io/gpu", 4L));
        List<RMNode> rmNodes = MockNodes.newNodes(2, 4, nodeResource);
        for (RMNode rmNode : rmNodes) {
            this.nodeTracker.addNode((SchedulerNode)new FiCaSchedulerNode(rmNode, false));
        }
        Assert.assertEquals((String)"Cluster Capability Memory incorrect", (long)this.metrics.getCapabilityMB(), (long)32768L);
        Assert.assertEquals((String)"Cluster Capability Vcores incorrect", (long)this.metrics.getCapabilityVirtualCores(), (long)32L);
        Assert.assertEquals((String)"Cluster Capability GPUs incorrect", (long)((Long)this.metrics.getCustomResourceCapability().get("yarn.io/gpu")), (long)32L);
        for (RMNode rmNode : rmNodes) {
            this.nodeTracker.removeNode(rmNode.getNodeID());
        }
        Assert.assertEquals((String)"Cluster Capability Memory incorrect", (long)this.metrics.getCapabilityMB(), (long)0L);
        Assert.assertEquals((String)"Cluster Capability Vcores incorrect", (long)this.metrics.getCapabilityVirtualCores(), (long)0L);
        Assert.assertEquals((String)"Cluster Capability GPUs incorrect", (long)((Long)this.metrics.getCustomResourceCapability().get("yarn.io/gpu")), (long)0L);
        ClusterMetrics.destroy();
        rm.stop();
    }

    @Test
    public void testCapacitySchedulerAbsoluteConfWithCustomResourceType() throws IOException {
        ResourceUtils.resetResourceTypes();
        String resourceTypesFileName = "resource-types-test.xml";
        File source = new File(this.conf.getClassLoader().getResource(resourceTypesFileName).getFile());
        this.resourceTypesFile = new File(source.getParent(), "resource-types.xml");
        FileUtils.copyFile((File)source, (File)this.resourceTypesFile);
        CapacitySchedulerConfiguration newConf = new CapacitySchedulerConfiguration((Configuration)this.conf);
        Set resourceTypes = Arrays.stream(CapacitySchedulerConfiguration.AbsoluteResourceType.values()).map(value -> value.toString().toLowerCase()).collect(Collectors.toSet());
        HashMap valuesMin = Maps.newHashMap();
        valuesMin.put("yarn.io/gpu", 10L);
        valuesMin.put("yarn.io/fpga", 10L);
        valuesMin.put("testType", 10L);
        HashMap valuesMax = Maps.newHashMap();
        valuesMax.put("yarn.io/gpu", 100L);
        valuesMax.put("yarn.io/fpga", 100L);
        valuesMax.put("testType", 100L);
        Resource aMINRES = Resource.newInstance((long)1000L, (int)10, (Map)valuesMin);
        Resource aMAXRES = Resource.newInstance((long)1000L, (int)10, (Map)valuesMax);
        newConf.setQueues("root", new String[]{"a", "b", "c"});
        newConf.setMinimumResourceRequirement("", new QueuePath("root", "a"), aMINRES);
        newConf.setMaximumResourceRequirement("", new QueuePath("root", "a"), aMAXRES);
        newConf.setClass("yarn.scheduler.capacity.resource-calculator", DominantResourceCalculator.class, ResourceCalculator.class);
        MockRM rm = new MockRM((Configuration)newConf);
        rm.start();
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        Assert.assertEquals((Object)aMINRES, (Object)cs.getConfiguration().getMinimumResourceRequirement("", "root.a", resourceTypes));
        Assert.assertEquals((Object)aMAXRES, (Object)cs.getConfiguration().getMaximumResourceRequirement("", "root.a", resourceTypes));
        Assert.assertEquals((Object)aMINRES, (Object)cs.getQueue("root.a").getQueueResourceQuotas().getConfiguredMinResource());
        Assert.assertEquals((Object)aMAXRES, (Object)cs.getQueue("root.a").getQueueResourceQuotas().getConfiguredMaxResource());
        rm.close();
    }
}

