/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.metrics;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.api.records.YarnApplicationAttemptState;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntityType;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEvent;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.DrainDispatcher;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryServer;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.metrics.CombinedSystemMetricsPublisher;
import org.apache.hadoop.yarn.server.resourcemanager.metrics.NoOpSystemMetricPublisher;
import org.apache.hadoop.yarn.server.resourcemanager.metrics.TimelineServiceV1Publisher;
import org.apache.hadoop.yarn.server.resourcemanager.metrics.TimelineServiceV2Publisher;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.timelineservice.RMTimelineCollectorManager;
import org.apache.hadoop.yarn.server.timeline.MemoryTimelineStore;
import org.apache.hadoop.yarn.server.timeline.TimelineReader;
import org.apache.hadoop.yarn.server.timeline.TimelineStore;
import org.apache.hadoop.yarn.server.timeline.recovery.MemoryTimelineStateStore;
import org.apache.hadoop.yarn.server.timeline.recovery.TimelineStateStore;
import org.apache.hadoop.yarn.server.timelineservice.collector.AppLevelTimelineCollector;
import org.apache.hadoop.yarn.server.timelineservice.collector.TimelineCollector;
import org.apache.hadoop.yarn.server.timelineservice.storage.FileSystemTimelineReaderImpl;
import org.apache.hadoop.yarn.server.timelineservice.storage.FileSystemTimelineWriterImpl;
import org.apache.hadoop.yarn.server.timelineservice.storage.TimelineWriter;
import org.apache.hadoop.yarn.util.TimelineServiceHelper;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestCombinedSystemMetricsPublisher {
    private static File testRootDir = new File("target", TestCombinedSystemMetricsPublisher.class.getName() + "-localDir").getAbsoluteFile();
    private static ApplicationHistoryServer timelineServer;
    private static CombinedSystemMetricsPublisher metricsPublisher;
    private static TimelineStore store;
    private static ConcurrentMap<ApplicationId, RMApp> rmAppsMapInContext;
    private static RMTimelineCollectorManager rmTimelineCollectorManager;
    private static DrainDispatcher dispatcher;
    private static YarnConfiguration conf;
    private static TimelineServiceV1Publisher publisherV1;
    private static TimelineServiceV2Publisher publisherV2;
    private static ApplicationAttemptId appAttemptId;
    private static RMApp app;

    private void testSetup(boolean enableV1, boolean enableV2) throws Exception {
        if (testRootDir.exists()) {
            FileContext.getLocalFSFileContext().delete(new Path(testRootDir.getAbsolutePath()), true);
        }
        conf = TestCombinedSystemMetricsPublisher.getConf(enableV1, enableV2);
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        rmAppsMapInContext = new ConcurrentHashMap<ApplicationId, RMApp>();
        Mockito.when((Object)rmContext.getRMApps()).thenReturn(rmAppsMapInContext);
        ResourceManager rm = (ResourceManager)Mockito.mock(ResourceManager.class);
        Mockito.when((Object)rm.getRMContext()).thenReturn((Object)rmContext);
        if (enableV2) {
            dispatcher = new DrainDispatcher();
            rmTimelineCollectorManager = new RMTimelineCollectorManager(rm);
            Mockito.when((Object)rmContext.getRMTimelineCollectorManager()).thenReturn((Object)rmTimelineCollectorManager);
            rmTimelineCollectorManager.init((Configuration)conf);
            rmTimelineCollectorManager.start();
        } else {
            dispatcher = null;
            rmTimelineCollectorManager = null;
        }
        timelineServer = new ApplicationHistoryServer();
        timelineServer.init((Configuration)conf);
        timelineServer.start();
        store = timelineServer.getTimelineStore();
        if (enableV2) {
            dispatcher.init((Configuration)conf);
            dispatcher.start();
        }
        ArrayList<Object> publishers = new ArrayList<Object>();
        if (YarnConfiguration.timelineServiceV1Enabled((Configuration)conf)) {
            Assert.assertTrue((boolean)enableV1);
            publisherV1 = new TimelineServiceV1Publisher();
            publishers.add(publisherV1);
            publisherV1.init((Configuration)conf);
            publisherV1.start();
        } else {
            Assert.assertFalse((boolean)enableV1);
            publisherV1 = null;
        }
        if (YarnConfiguration.timelineServiceV2Enabled((Configuration)conf)) {
            Assert.assertTrue((boolean)enableV2);
            publisherV2 = new TimelineServiceV2Publisher(rmTimelineCollectorManager){

                protected Dispatcher getDispatcher() {
                    return dispatcher;
                }
            };
            publishers.add(publisherV2);
            publisherV2.init((Configuration)conf);
            publisherV2.start();
        } else {
            Assert.assertFalse((boolean)enableV2);
            publisherV2 = null;
        }
        if (publishers.isEmpty()) {
            NoOpSystemMetricPublisher noopPublisher = new NoOpSystemMetricPublisher();
            publishers.add(noopPublisher);
        }
        metricsPublisher = new CombinedSystemMetricsPublisher(publishers);
    }

    private void testCleanup() throws Exception {
        if (publisherV1 != null) {
            publisherV1.stop();
        }
        if (publisherV2 != null) {
            publisherV2.stop();
        }
        if (timelineServer != null) {
            timelineServer.stop();
        }
        if (testRootDir.exists()) {
            FileContext.getLocalFSFileContext().delete(new Path(testRootDir.getAbsolutePath()), true);
        }
        if (rmTimelineCollectorManager != null) {
            rmTimelineCollectorManager.stop();
        }
    }

    private static YarnConfiguration getConf(boolean v1Enabled, boolean v2Enabled) {
        YarnConfiguration yarnConf = new YarnConfiguration();
        if (v1Enabled || v2Enabled) {
            yarnConf.setBoolean("yarn.timeline-service.enabled", true);
        } else {
            yarnConf.setBoolean("yarn.timeline-service.enabled", false);
        }
        if (v1Enabled) {
            yarnConf.set("yarn.timeline-service.version", "1.0");
            yarnConf.setClass("yarn.timeline-service.store-class", MemoryTimelineStore.class, TimelineStore.class);
            yarnConf.setClass("yarn.timeline-service.state-store-class", MemoryTimelineStateStore.class, TimelineStateStore.class);
        }
        if (v2Enabled) {
            yarnConf.set("yarn.timeline-service.version", "2.0");
            yarnConf.setBoolean("yarn.system-metrics-publisher.enabled", true);
            yarnConf.setBoolean("yarn.rm.system-metrics-publisher.emit-container-events", true);
            yarnConf.setClass("yarn.timeline-service.writer.class", FileSystemTimelineWriterImpl.class, TimelineWriter.class);
            try {
                yarnConf.set("yarn.timeline-service.fs-writer.root-dir", testRootDir.getCanonicalPath());
            }
            catch (IOException e) {
                e.printStackTrace();
                Assert.fail((String)"Exception while setting the TIMELINE_SERVICE_STORAGE_DIR_ROOT ");
            }
        }
        if (v1Enabled && v2Enabled) {
            yarnConf.set("yarn.timeline-service.version", "1.0");
            yarnConf.set("yarn.timeline-service.versions", "1.0,2.0f");
        }
        yarnConf.setInt("yarn.resourcemanager.system-metrics-publisher.dispatcher.pool-size", 2);
        return yarnConf;
    }

    private void runTest(boolean v1Enabled, boolean v2Enabled) throws Exception {
        this.testSetup(v1Enabled, v2Enabled);
        this.publishEvents(v1Enabled, v2Enabled);
        this.validateV1(v1Enabled);
        this.validateV2(v2Enabled);
        this.testCleanup();
    }

    @Test(timeout=10000L)
    public void testTimelineServiceEventPublishingV1V2Enabled() throws Exception {
        this.runTest(true, true);
    }

    @Test(timeout=10000L)
    public void testTimelineServiceEventPublishingV1Enabled() throws Exception {
        this.runTest(true, false);
    }

    @Test(timeout=10000L)
    public void testTimelineServiceEventPublishingV2Enabled() throws Exception {
        this.runTest(false, true);
    }

    @Test(timeout=10000L)
    public void testTimelineServiceEventPublishingNoService() throws Exception {
        this.runTest(false, false);
    }

    @Test(timeout=10000L)
    public void testTimelineServiceConfiguration() throws Exception {
        Configuration config = new Configuration(false);
        config.setBoolean("yarn.timeline-service.enabled", true);
        config.set("yarn.timeline-service.versions", "2.0,1.5");
        config.set("yarn.timeline-service.version", "2.0");
        Assert.assertTrue((boolean)YarnConfiguration.timelineServiceV2Enabled((Configuration)config));
        Assert.assertTrue((boolean)YarnConfiguration.timelineServiceV15Enabled((Configuration)config));
        Assert.assertTrue((boolean)YarnConfiguration.timelineServiceV1Enabled((Configuration)config));
        config.set("yarn.timeline-service.versions", "2.0,1");
        config.set("yarn.timeline-service.version", "1.5");
        Assert.assertTrue((boolean)YarnConfiguration.timelineServiceV2Enabled((Configuration)config));
        Assert.assertFalse((boolean)YarnConfiguration.timelineServiceV15Enabled((Configuration)config));
        Assert.assertTrue((boolean)YarnConfiguration.timelineServiceV1Enabled((Configuration)config));
        config.set("yarn.timeline-service.versions", "2.0");
        config.set("yarn.timeline-service.version", "1.5");
        Assert.assertTrue((boolean)YarnConfiguration.timelineServiceV2Enabled((Configuration)config));
        Assert.assertFalse((boolean)YarnConfiguration.timelineServiceV15Enabled((Configuration)config));
        Assert.assertFalse((boolean)YarnConfiguration.timelineServiceV1Enabled((Configuration)config));
    }

    private void publishEvents(boolean v1Enabled, boolean v2Enabled) {
        long timestamp = v1Enabled ? 1L : 2L;
        int id = v2Enabled ? 3 : 4;
        ApplicationId appId = ApplicationId.newInstance((long)timestamp, (int)id);
        app = TestCombinedSystemMetricsPublisher.createRMApp(appId);
        rmAppsMapInContext.putIfAbsent(appId, app);
        if (v2Enabled) {
            AppLevelTimelineCollector collector = new AppLevelTimelineCollector(appId);
            rmTimelineCollectorManager.putIfAbsent(appId, (TimelineCollector)collector);
        }
        appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        RMAppAttempt appAttempt = TestCombinedSystemMetricsPublisher.createRMAppAttempt(true);
        metricsPublisher.appAttemptRegistered(appAttempt, 0x80000000L);
        metricsPublisher.appAttemptFinished(appAttempt, RMAppAttemptState.FINISHED, app, 0x80000001L);
        if (v2Enabled) {
            dispatcher.await();
        }
    }

    private void validateV1(boolean v1Enabled) throws Exception {
        TimelineEntity entity = null;
        if (!v1Enabled) {
            Thread.sleep(1000L);
            entity = store.getEntity(appAttemptId.toString(), "YARN_APPLICATION_ATTEMPT", EnumSet.allOf(TimelineReader.Field.class));
            Assert.assertNull((Object)entity);
            return;
        }
        do {
            entity = store.getEntity(appAttemptId.toString(), "YARN_APPLICATION_ATTEMPT", EnumSet.allOf(TimelineReader.Field.class));
            Thread.sleep(100L);
        } while (entity == null || entity.getEvents().size() < 2);
        boolean hasRegisteredEvent = false;
        boolean hasFinishedEvent = false;
        for (org.apache.hadoop.yarn.api.records.timeline.TimelineEvent event : entity.getEvents()) {
            if (event.getEventType().equals("YARN_APPLICATION_ATTEMPT_REGISTERED")) {
                hasRegisteredEvent = true;
            } else if (event.getEventType().equals("YARN_APPLICATION_ATTEMPT_FINISHED")) {
                hasFinishedEvent = true;
                Assert.assertEquals((Object)FinalApplicationStatus.UNDEFINED.toString(), event.getEventInfo().get("YARN_APPLICATION_ATTEMPT_FINAL_STATUS"));
                Assert.assertEquals((Object)YarnApplicationAttemptState.FINISHED.toString(), event.getEventInfo().get("YARN_APPLICATION_ATTEMPT_STATE"));
            }
            Assert.assertEquals((Object)appAttemptId.toString(), (Object)entity.getEntityId());
        }
        Assert.assertTrue((hasRegisteredEvent && hasFinishedEvent ? 1 : 0) != 0);
    }

    private void validateV2(boolean v2Enabled) throws Exception {
        String outputDirApp = this.getTimelineEntityDir() + "/" + TimelineEntityType.YARN_APPLICATION_ATTEMPT + "/";
        File entityFolder = new File(outputDirApp);
        Assert.assertEquals((Object)v2Enabled, (Object)entityFolder.isDirectory());
        if (v2Enabled) {
            String timelineServiceFileName = appAttemptId.toString() + ".thist";
            File entityFile = new File(outputDirApp, timelineServiceFileName);
            Assert.assertTrue((boolean)entityFile.exists());
            long idPrefix = TimelineServiceHelper.invertLong((long)appAttemptId.getAttemptId());
            this.verifyEntity(entityFile, 2L, "YARN_APPLICATION_ATTEMPT_REGISTERED", 0L, idPrefix);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyEntity(File entityFile, long expectedEvents, String eventForCreatedTime, long expectedMetrics, long idPrefix) throws IOException {
        BufferedReader reader = null;
        long count = 0L;
        long metricsCount = 0L;
        try {
            String strLine;
            reader = new BufferedReader(new FileReader(entityFile));
            while ((strLine = reader.readLine()) != null) {
                if (strLine.trim().length() <= 0) continue;
                org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity entity = (org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity)FileSystemTimelineReaderImpl.getTimelineRecordFromJSON((String)strLine.trim(), org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity.class);
                metricsCount = entity.getMetrics().size();
                Assert.assertEquals((long)idPrefix, (long)entity.getIdPrefix());
                for (TimelineEvent event : entity.getEvents()) {
                    if (!event.getId().equals(eventForCreatedTime)) continue;
                    Assert.assertTrue((entity.getCreatedTime() > 0L ? 1 : 0) != 0);
                    break;
                }
                ++count;
            }
        }
        finally {
            reader.close();
        }
        Assert.assertEquals((String)("Expected " + expectedEvents + " events to be published"), (long)expectedEvents, (long)count);
        Assert.assertEquals((String)("Expected " + expectedMetrics + " metrics is incorrect"), (long)expectedMetrics, (long)metricsCount);
    }

    private String getTimelineEntityDir() {
        String outputDirApp = testRootDir.getAbsolutePath() + "/" + "entities" + "/" + "yarn_cluster" + "/" + app.getUser() + "/" + app.getName() + "/" + "1" + "/" + app.getStartTime() + "/" + app.getApplicationId();
        return outputDirApp;
    }

    private static RMAppAttempt createRMAppAttempt(boolean unmanagedAMAttempt) {
        RMAppAttempt appAttempt = (RMAppAttempt)Mockito.mock(RMAppAttempt.class);
        Mockito.when((Object)appAttempt.getAppAttemptId()).thenReturn((Object)appAttemptId);
        Mockito.when((Object)appAttempt.getHost()).thenReturn((Object)"test host");
        Mockito.when((Object)appAttempt.getRpcPort()).thenReturn((Object)-100);
        if (!unmanagedAMAttempt) {
            Container container = (Container)Mockito.mock(Container.class);
            Mockito.when((Object)container.getId()).thenReturn((Object)ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)1L));
            Mockito.when((Object)appAttempt.getMasterContainer()).thenReturn((Object)container);
        }
        Mockito.when((Object)appAttempt.getDiagnostics()).thenReturn((Object)"test diagnostics info");
        Mockito.when((Object)appAttempt.getTrackingUrl()).thenReturn((Object)"test tracking url");
        Mockito.when((Object)appAttempt.getOriginalTrackingUrl()).thenReturn((Object)"test original tracking url");
        return appAttempt;
    }

    private static RMApp createRMApp(ApplicationId appId) {
        RMApp rmApp = (RMApp)Mockito.mock(RMAppImpl.class);
        Mockito.when((Object)rmApp.getApplicationId()).thenReturn((Object)appId);
        Mockito.when((Object)rmApp.getName()).thenReturn((Object)"test app");
        Mockito.when((Object)rmApp.getApplicationType()).thenReturn((Object)"test app type");
        Mockito.when((Object)rmApp.getUser()).thenReturn((Object)"testUser");
        Mockito.when((Object)rmApp.getQueue()).thenReturn((Object)"test queue");
        Mockito.when((Object)rmApp.getSubmitTime()).thenReturn((Object)0x80000000L);
        Mockito.when((Object)rmApp.getStartTime()).thenReturn((Object)0x80000001L);
        Mockito.when((Object)rmApp.getFinishTime()).thenReturn((Object)0x80000002L);
        Mockito.when((Object)rmApp.getDiagnostics()).thenReturn((Object)new StringBuilder("test diagnostics info"));
        RMAppAttempt appAttempt = (RMAppAttempt)Mockito.mock(RMAppAttempt.class);
        Mockito.when((Object)appAttempt.getAppAttemptId()).thenReturn((Object)ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1));
        Mockito.when((Object)rmApp.getCurrentAppAttempt()).thenReturn((Object)appAttempt);
        Mockito.when((Object)rmApp.getFinalApplicationStatus()).thenReturn((Object)FinalApplicationStatus.UNDEFINED);
        HashMap<String, Long> resourceMap = new HashMap<String, Long>();
        resourceMap.put(ResourceInformation.MEMORY_MB.getName(), (Long)Integer.MAX_VALUE);
        resourceMap.put(ResourceInformation.VCORES.getName(), Long.MAX_VALUE);
        HashMap<String, Long> preemptedMap = new HashMap<String, Long>();
        preemptedMap.put(ResourceInformation.MEMORY_MB.getName(), (Long)Integer.MAX_VALUE);
        preemptedMap.put(ResourceInformation.VCORES.getName(), Long.MAX_VALUE);
        Mockito.when((Object)rmApp.getRMAppMetrics()).thenReturn((Object)new RMAppMetrics(Resource.newInstance((int)0, (int)0), 0, 0, resourceMap, preemptedMap, 0));
        Mockito.when((Object)rmApp.getApplicationTags()).thenReturn(Collections.emptySet());
        ApplicationSubmissionContext appSubmissionContext = (ApplicationSubmissionContext)Mockito.mock(ApplicationSubmissionContext.class);
        Mockito.when((Object)appSubmissionContext.getPriority()).thenReturn((Object)Priority.newInstance((int)0));
        ContainerLaunchContext containerLaunchContext = (ContainerLaunchContext)Mockito.mock(ContainerLaunchContext.class);
        Mockito.when((Object)containerLaunchContext.getCommands()).thenReturn(Collections.singletonList("java -Xmx1024m"));
        Mockito.when((Object)appSubmissionContext.getAMContainerSpec()).thenReturn((Object)containerLaunchContext);
        Mockito.when((Object)rmApp.getApplicationPriority()).thenReturn((Object)Priority.newInstance((int)10));
        Mockito.when((Object)rmApp.getApplicationSubmissionContext()).thenReturn((Object)appSubmissionContext);
        return rmApp;
    }
}

