/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.federation;

import com.sun.jersey.api.json.JSONConfiguration;
import com.sun.jersey.api.json.JSONJAXBContext;
import com.sun.jersey.api.json.JSONUnmarshaller;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import javax.xml.bind.JAXBException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.yarn.MockApps;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationSubmissionContextPBImpl;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.federation.policies.exceptions.FederationPolicyInitializationException;
import org.apache.hadoop.yarn.server.federation.policies.manager.UniformBroadcastPolicyManager;
import org.apache.hadoop.yarn.server.federation.store.FederationStateStore;
import org.apache.hadoop.yarn.server.federation.store.exception.FederationStateStoreException;
import org.apache.hadoop.yarn.server.federation.store.records.AddApplicationHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.ApplicationHomeSubCluster;
import org.apache.hadoop.yarn.server.federation.store.records.GetApplicationHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetApplicationHomeSubClusterResponse;
import org.apache.hadoop.yarn.server.federation.store.records.GetApplicationsHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetApplicationsHomeSubClusterResponse;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterInfoRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterInfoResponse;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterPoliciesConfigurationsRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterPoliciesConfigurationsResponse;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterPolicyConfigurationRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterPolicyConfigurationResponse;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClustersInfoRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClustersInfoResponse;
import org.apache.hadoop.yarn.server.federation.store.records.SetSubClusterPolicyConfigurationRequest;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterDeregisterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterHeartbeatRequest;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterHeartbeatResponse;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterPolicyConfiguration;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterRegisterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterState;
import org.apache.hadoop.yarn.server.resourcemanager.ApplicationMasterService;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.RMAppManager;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.federation.FederationStateStoreHeartbeat;
import org.apache.hadoop.yarn.server.resourcemanager.federation.FederationStateStoreService;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.MemoryRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppImpl;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ClusterMetricsInfo;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;

public class TestFederationRMStateStoreService {
    private final HAServiceProtocol.StateChangeRequestInfo requestInfo = new HAServiceProtocol.StateChangeRequestInfo(HAServiceProtocol.RequestSource.REQUEST_BY_USER);
    private final SubClusterId subClusterId = SubClusterId.newInstance((String)"SC-1");
    private final GetSubClusterInfoRequest request = GetSubClusterInfoRequest.newInstance((SubClusterId)this.subClusterId);
    private Configuration conf;
    private FederationStateStore stateStore;
    private long lastHearbeatTS = 0L;
    private JSONJAXBContext jc;
    private JSONUnmarshaller unmarshaller;
    private MockRM mockRM;

    @Before
    public void setUp() throws IOException, YarnException, JAXBException {
        this.conf = new YarnConfiguration();
        this.jc = new JSONJAXBContext(JSONConfiguration.mapped().rootUnwrapping(false).build(), new Class[]{ClusterMetricsInfo.class});
        this.unmarshaller = this.jc.createJSONUnmarshaller();
        this.conf.setBoolean("yarn.federation.enabled", true);
        this.conf.setInt("yarn.federation.state-store.heartbeat.initial-delay", 10);
        this.conf.set("yarn.resourcemanager.cluster-id", this.subClusterId.getId());
        this.mockRM = new MockRM(this.conf);
        this.mockRM.init(this.conf);
        this.mockRM.start();
    }

    @After
    public void tearDown() throws Exception {
        this.unmarshaller = null;
        this.jc = null;
        this.mockRM.stop();
        this.mockRM = null;
    }

    @Test
    public void testFederationStateStoreService() throws Exception {
        this.conf.setBoolean("yarn.federation.enabled", true);
        this.conf.set("yarn.resourcemanager.cluster-id", this.subClusterId.getId());
        MockRM rm = new MockRM(this.conf);
        rm.init(this.conf);
        this.stateStore = rm.getFederationStateStoreService().getStateStoreClient();
        GetSubClusterInfoResponse response = this.stateStore.getSubCluster(this.request);
        Assert.assertNull((Object)response);
        rm.start();
        String capability = this.checkSubClusterInfo(SubClusterState.SC_NEW);
        Assert.assertTrue((boolean)capability.isEmpty());
        FederationStateStoreHeartbeat storeHeartbeat = rm.getFederationStateStoreService().getStateStoreHeartbeatThread();
        storeHeartbeat.run();
        capability = this.checkSubClusterInfo(SubClusterState.SC_RUNNING);
        this.checkClusterMetricsInfo(capability, 0);
        rm.registerNode("127.0.0.1:1234", 4096);
        storeHeartbeat.run();
        capability = this.checkSubClusterInfo(SubClusterState.SC_RUNNING);
        this.checkClusterMetricsInfo(capability, 1);
        rm.getFederationStateStoreService().deregisterSubCluster(SubClusterDeregisterRequest.newInstance((SubClusterId)this.subClusterId, (SubClusterState)SubClusterState.SC_UNREGISTERED));
        this.checkSubClusterInfo(SubClusterState.SC_UNREGISTERED);
        this.explicitFailover(rm);
        capability = this.checkSubClusterInfo(SubClusterState.SC_NEW);
        Assert.assertTrue((boolean)capability.isEmpty());
        storeHeartbeat = rm.getFederationStateStoreService().getStateStoreHeartbeatThread();
        storeHeartbeat.run();
        capability = this.checkSubClusterInfo(SubClusterState.SC_RUNNING);
        this.checkClusterMetricsInfo(capability, 0);
        rm.registerNode("127.0.0.1:1234", 4096);
        storeHeartbeat.run();
        capability = this.checkSubClusterInfo(SubClusterState.SC_RUNNING);
        this.checkClusterMetricsInfo(capability, 1);
        rm.stop();
    }

    private void explicitFailover(MockRM rm) throws IOException {
        rm.getAdminService().transitionToStandby(this.requestInfo);
        Assert.assertTrue((rm.getRMContext().getHAServiceState() == HAServiceProtocol.HAServiceState.STANDBY ? 1 : 0) != 0);
        rm.getAdminService().transitionToActive(this.requestInfo);
        Assert.assertTrue((rm.getRMContext().getHAServiceState() == HAServiceProtocol.HAServiceState.ACTIVE ? 1 : 0) != 0);
        this.lastHearbeatTS = 0L;
        this.stateStore = rm.getFederationStateStoreService().getStateStoreClient();
    }

    private void checkClusterMetricsInfo(String capability, int numNodes) throws JAXBException {
        ClusterMetricsInfo clusterMetricsInfo = (ClusterMetricsInfo)this.unmarshaller.unmarshalFromJSON((Reader)new StringReader(capability), ClusterMetricsInfo.class);
        Assert.assertEquals((long)numNodes, (long)clusterMetricsInfo.getTotalNodes());
    }

    private String checkSubClusterInfo(SubClusterState state) throws YarnException, UnknownHostException {
        Assert.assertNotNull((Object)this.stateStore.getSubCluster(this.request));
        SubClusterInfo response = this.stateStore.getSubCluster(this.request).getSubClusterInfo();
        Assert.assertEquals((Object)state, (Object)response.getState());
        Assert.assertTrue((response.getLastHeartBeat() >= this.lastHearbeatTS ? 1 : 0) != 0);
        String expectedAddress = response.getClientRMServiceAddress().split(":")[0];
        Assert.assertEquals((Object)expectedAddress, (Object)response.getAMRMServiceAddress().split(":")[0]);
        Assert.assertEquals((Object)expectedAddress, (Object)response.getRMAdminServiceAddress().split(":")[0]);
        Assert.assertEquals((Object)expectedAddress, (Object)response.getRMWebServiceAddress().split(":")[0]);
        this.lastHearbeatTS = response.getLastHeartBeat();
        return response.getCapability();
    }

    @Test
    public void testFederationStateStoreServiceInitialHeartbeatDelay() throws Exception {
        this.conf.setBoolean("yarn.federation.enabled", true);
        this.conf.setInt("yarn.federation.state-store.heartbeat.initial-delay", 10);
        this.conf.set("yarn.resourcemanager.cluster-id", this.subClusterId.getId());
        GenericTestUtils.LogCapturer logCapture = GenericTestUtils.LogCapturer.captureLogs((Logger)FederationStateStoreService.LOG);
        MockRM rm = new MockRM(this.conf);
        rm.init(this.conf);
        this.stateStore = rm.getFederationStateStoreService().getStateStoreClient();
        GetSubClusterInfoResponse response = this.stateStore.getSubCluster(this.request);
        Assert.assertNull((Object)response);
        rm.start();
        String capability = this.checkSubClusterInfo(SubClusterState.SC_NEW);
        Assert.assertTrue((boolean)capability.isEmpty());
        FederationStateStoreHeartbeat storeHeartbeat = rm.getFederationStateStoreService().getStateStoreHeartbeatThread();
        storeHeartbeat.run();
        capability = this.checkSubClusterInfo(SubClusterState.SC_RUNNING);
        this.checkClusterMetricsInfo(capability, 0);
        Assert.assertTrue((boolean)logCapture.getOutput().contains("Started federation membership heartbeat with interval: 300 and initial delay: 10"));
        rm.stop();
    }

    @Test
    public void testCleanUpApplication() throws Exception {
        this.conf.setBoolean("yarn.federation.enabled", true);
        this.conf.setInt("yarn.federation.state-store.heartbeat.initial-delay", 10);
        this.conf.set("yarn.resourcemanager.cluster-id", this.subClusterId.getId());
        MockRM rm = new MockRM(this.conf);
        rm.init(this.conf);
        this.stateStore = rm.getFederationStateStoreService().getStateStoreClient();
        rm.start();
        FederationStateStoreService stateStoreService = rm.getFederationStateStoreService();
        FederationStateStoreHeartbeat storeHeartbeat = stateStoreService.getStateStoreHeartbeatThread();
        storeHeartbeat.run();
        this.checkSubClusterInfo(SubClusterState.SC_RUNNING);
        ApplicationId appId = ApplicationId.newInstance((long)Time.now(), (int)1);
        this.addApplication2StateStore(appId, this.stateStore);
        GetApplicationHomeSubClusterRequest appRequest = GetApplicationHomeSubClusterRequest.newInstance((ApplicationId)appId);
        GetApplicationHomeSubClusterResponse response = this.stateStore.getApplicationHomeSubCluster(appRequest);
        Assert.assertNotNull((Object)response);
        ApplicationHomeSubCluster appHomeSubCluster = response.getApplicationHomeSubCluster();
        Assert.assertNotNull((Object)appHomeSubCluster);
        Assert.assertNotNull((Object)appHomeSubCluster.getApplicationId());
        Assert.assertEquals((Object)appId, (Object)appHomeSubCluster.getApplicationId());
        boolean cleanUpResult = stateStoreService.cleanUpFinishApplicationsWithRetries(appId, true);
        Assert.assertTrue((boolean)cleanUpResult);
        LambdaTestUtils.intercept(FederationStateStoreException.class, (String)("Application " + appId + " does not exist"), () -> this.stateStore.getApplicationHomeSubCluster(appRequest));
    }

    @Test
    public void testCleanUpApplicationWhenRMStart() throws Exception {
        this.conf.setBoolean("yarn.federation.enabled", true);
        this.conf.setInt("yarn.federation.state-store.heartbeat.initial-delay", 10);
        this.conf.set("yarn.resourcemanager.cluster-id", this.subClusterId.getId());
        this.conf.setBoolean("yarn.resourcemanager.recovery.enabled", true);
        MockRM rm = new MockRM(this.conf);
        rm.init(this.conf);
        this.stateStore = rm.getFederationStateStoreService().getStateStoreClient();
        ArrayList<ApplicationId> appIds = new ArrayList<ApplicationId>();
        ApplicationId appId01 = ApplicationId.newInstance((long)Time.now(), (int)1);
        this.addApplication2StateStore(appId01, this.stateStore);
        appIds.add(appId01);
        ApplicationId appId02 = ApplicationId.newInstance((long)Time.now(), (int)2);
        this.addApplication2StateStore(appId02, this.stateStore);
        appIds.add(appId02);
        ApplicationId appId03 = ApplicationId.newInstance((long)Time.now(), (int)3);
        this.addApplication2StateStore(appId03, this.stateStore);
        appIds.add(appId03);
        GetApplicationsHomeSubClusterRequest allRequest = GetApplicationsHomeSubClusterRequest.newInstance((SubClusterId)this.subClusterId);
        GetApplicationsHomeSubClusterResponse allResponse = this.stateStore.getApplicationsHomeSubCluster(allRequest);
        Assert.assertNotNull((Object)allResponse);
        List appHomeSCLists = allResponse.getAppsHomeSubClusters();
        Assert.assertNotNull((Object)appHomeSCLists);
        Assert.assertEquals((long)3L, (long)appHomeSCLists.size());
        ApplicationId appId04 = ApplicationId.newInstance((long)Time.now(), (int)4);
        this.addApplication2StateStore(appId04, this.stateStore);
        this.addApplication2RMAppManager(rm, appId04);
        rm.start();
        GenericTestUtils.waitFor(() -> {
            int appsSize = 0;
            try {
                List<ApplicationHomeSubCluster> subClusters = this.getApplicationsFromStateStore();
                Assert.assertNotNull(subClusters);
                appsSize = subClusters.size();
            }
            catch (YarnException e) {
                e.printStackTrace();
            }
            return appsSize == 1;
        }, (long)100L, (long)5000L);
        for (ApplicationId appId : appIds) {
            GetApplicationHomeSubClusterRequest appRequest = GetApplicationHomeSubClusterRequest.newInstance((ApplicationId)appId);
            LambdaTestUtils.intercept(FederationStateStoreException.class, (String)("Application " + appId + " does not exist"), () -> this.stateStore.getApplicationHomeSubCluster(appRequest));
        }
        if (rm != null) {
            rm.stop();
            rm = null;
        }
    }

    @Test
    public void testCleanUpApplicationWhenRMCompleteOneApp() throws Exception {
        this.conf.setBoolean("yarn.federation.enabled", true);
        this.conf.setInt("yarn.federation.state-store.heartbeat.initial-delay", 10);
        this.conf.set("yarn.resourcemanager.cluster-id", this.subClusterId.getId());
        this.conf.setBoolean("yarn.resourcemanager.recovery.enabled", true);
        this.conf.setInt("yarn.resourcemanager.state-store.max-completed-applications", 1);
        this.conf.set("yarn.resourcemanager.store.class", MemoryRMStateStore.class.getName());
        MockRM rm = new MockRM(this.conf);
        rm.init(this.conf);
        this.stateStore = rm.getFederationStateStoreService().getStateStoreClient();
        rm.start();
        ArrayList<ApplicationId> appIds = new ArrayList<ApplicationId>();
        ApplicationId appId01 = ApplicationId.newInstance((long)Time.now(), (int)1);
        this.addApplication2StateStore(appId01, this.stateStore);
        this.addApplication2RMAppManager(rm, appId01);
        appIds.add(appId01);
        ApplicationId appId02 = ApplicationId.newInstance((long)Time.now(), (int)2);
        this.addApplication2StateStore(appId02, this.stateStore);
        this.addApplication2RMAppManager(rm, appId02);
        appIds.add(appId02);
        ApplicationId appId03 = ApplicationId.newInstance((long)Time.now(), (int)3);
        this.addApplication2StateStore(appId03, this.stateStore);
        this.addApplication2RMAppManager(rm, appId03);
        RMAppManager rmAppManager = rm.getRMAppManager();
        rmAppManager.finishApplication4Test(appId01);
        rmAppManager.finishApplication4Test(appId02);
        rmAppManager.finishApplication4Test(appId03);
        rmAppManager.checkAppNumCompletedLimit4Test();
        for (ApplicationId appId : appIds) {
            GetApplicationHomeSubClusterRequest appRequest = GetApplicationHomeSubClusterRequest.newInstance((ApplicationId)appId);
            LambdaTestUtils.intercept(FederationStateStoreException.class, (String)("Application " + appId + " does not exist"), () -> this.stateStore.getApplicationHomeSubCluster(appRequest));
        }
        List<ApplicationHomeSubCluster> appHomeScList = this.getApplicationsFromStateStore();
        Assert.assertNotNull(appHomeScList);
        Assert.assertEquals((long)1L, (long)appHomeScList.size());
        ApplicationHomeSubCluster homeSubCluster = appHomeScList.get(0);
        Assert.assertNotNull((Object)homeSubCluster);
        Assert.assertEquals((Object)appId03, (Object)homeSubCluster.getApplicationId());
    }

    private void addApplication2StateStore(ApplicationId appId, FederationStateStore fedStateStore) throws YarnException {
        ApplicationHomeSubCluster appHomeSC = ApplicationHomeSubCluster.newInstance((ApplicationId)appId, (SubClusterId)this.subClusterId);
        AddApplicationHomeSubClusterRequest addHomeSCRequest = AddApplicationHomeSubClusterRequest.newInstance((ApplicationHomeSubCluster)appHomeSC);
        fedStateStore.addApplicationHomeSubCluster(addHomeSCRequest);
    }

    private List<ApplicationHomeSubCluster> getApplicationsFromStateStore() throws YarnException {
        GetApplicationsHomeSubClusterRequest allRequest = GetApplicationsHomeSubClusterRequest.newInstance((SubClusterId)this.subClusterId);
        GetApplicationsHomeSubClusterResponse allResponse = this.stateStore.getApplicationsHomeSubCluster(allRequest);
        Assert.assertNotNull((Object)allResponse);
        List appHomeSCLists = allResponse.getAppsHomeSubClusters();
        Assert.assertNotNull((Object)appHomeSCLists);
        return appHomeSCLists;
    }

    private void addApplication2RMAppManager(MockRM rm, ApplicationId appId) {
        RMContext rmContext = rm.getRMContext();
        ConcurrentMap rmAppMaps = rmContext.getRMApps();
        String user = MockApps.newUserName();
        String name = MockApps.newAppName();
        String queue = MockApps.newQueue();
        YarnScheduler scheduler = (YarnScheduler)Mockito.mock(YarnScheduler.class);
        ApplicationMasterService masterService = new ApplicationMasterService(rmContext, scheduler);
        ApplicationSubmissionContextPBImpl submissionContext = new ApplicationSubmissionContextPBImpl();
        submissionContext.setApplicationId(appId);
        submissionContext.setPriority(Priority.newInstance((int)0));
        RMAppImpl application = new RMAppImpl(appId, rmContext, this.conf, name, user, queue, (ApplicationSubmissionContext)submissionContext, scheduler, masterService, System.currentTimeMillis(), "YARN", null, new ArrayList());
        rmAppMaps.putIfAbsent(application.getApplicationId(), application);
    }

    @Test
    public void testPolicyConfigurationMethod() throws YarnException {
        FederationStateStoreService stateStoreService = this.mockRM.getFederationStateStoreService();
        String queue1 = "queue1";
        SubClusterPolicyConfiguration requestPolicyConf1 = this.getUniformPolicy(queue1);
        SetSubClusterPolicyConfigurationRequest configurationRequest1 = SetSubClusterPolicyConfigurationRequest.newInstance((SubClusterPolicyConfiguration)requestPolicyConf1);
        stateStoreService.setPolicyConfiguration(configurationRequest1);
        String queue2 = "queue2";
        SubClusterPolicyConfiguration requestPolicyConf2 = this.getUniformPolicy(queue2);
        SetSubClusterPolicyConfigurationRequest configurationRequest2 = SetSubClusterPolicyConfigurationRequest.newInstance((SubClusterPolicyConfiguration)requestPolicyConf2);
        stateStoreService.setPolicyConfiguration(configurationRequest2);
        GetSubClusterPolicyConfigurationRequest request1 = GetSubClusterPolicyConfigurationRequest.newInstance((String)queue1);
        GetSubClusterPolicyConfigurationResponse response = stateStoreService.getPolicyConfiguration(request1);
        Assert.assertNotNull((Object)response);
        SubClusterPolicyConfiguration responsePolicyConf = response.getPolicyConfiguration();
        Assert.assertNotNull((Object)responsePolicyConf);
        Assert.assertEquals((Object)requestPolicyConf1, (Object)responsePolicyConf);
        GetSubClusterPoliciesConfigurationsRequest policiesRequest1 = GetSubClusterPoliciesConfigurationsRequest.newInstance();
        GetSubClusterPoliciesConfigurationsResponse policiesResponse1 = stateStoreService.getPoliciesConfigurations(policiesRequest1);
        Assert.assertNotNull((Object)policiesResponse1);
        List policiesConfigs = policiesResponse1.getPoliciesConfigs();
        Assert.assertNotNull((Object)policiesConfigs);
        Assert.assertEquals((long)2L, (long)policiesConfigs.size());
        Assert.assertTrue((boolean)policiesConfigs.contains(requestPolicyConf1));
        Assert.assertTrue((boolean)policiesConfigs.contains(requestPolicyConf2));
    }

    public SubClusterPolicyConfiguration getUniformPolicy(String queue) throws FederationPolicyInitializationException {
        UniformBroadcastPolicyManager wfp = new UniformBroadcastPolicyManager();
        wfp.setQueue(queue);
        SubClusterPolicyConfiguration fpc = wfp.serializeConf();
        return fpc;
    }

    @Test
    public void testSubClusterMethod() throws YarnException {
        FederationStateStoreService stateStoreService = this.mockRM.getFederationStateStoreService();
        SubClusterId subClusterId1 = SubClusterId.newInstance((String)"SC1");
        SubClusterInfo subClusterInfo1 = this.createSubClusterInfo(subClusterId1);
        SubClusterRegisterRequest registerRequest1 = SubClusterRegisterRequest.newInstance((SubClusterInfo)subClusterInfo1);
        stateStoreService.registerSubCluster(registerRequest1);
        SubClusterId subClusterId2 = SubClusterId.newInstance((String)"SC2");
        SubClusterInfo subClusterInfo2 = this.createSubClusterInfo(subClusterId2);
        SubClusterRegisterRequest registerRequest2 = SubClusterRegisterRequest.newInstance((SubClusterInfo)subClusterInfo2);
        stateStoreService.registerSubCluster(registerRequest2);
        GetSubClusterInfoRequest subClusterRequest = GetSubClusterInfoRequest.newInstance((SubClusterId)subClusterId1);
        GetSubClusterInfoResponse subClusterResponse = stateStoreService.getSubCluster(subClusterRequest);
        Assert.assertNotNull((Object)subClusterResponse);
        SubClusterInfo subClusterInfo1Resp = subClusterResponse.getSubClusterInfo();
        Assert.assertNotNull((Object)subClusterInfo1Resp);
        Assert.assertEquals((Object)subClusterInfo1, (Object)subClusterInfo1Resp);
        GetSubClustersInfoRequest subClustersInfoRequest = GetSubClustersInfoRequest.newInstance((boolean)true);
        GetSubClustersInfoResponse subClustersInfoResp = stateStoreService.getSubClusters(subClustersInfoRequest);
        Assert.assertNotNull((Object)subClustersInfoResp);
        List subClusterInfos = subClustersInfoResp.getSubClusters();
        Assert.assertNotNull((Object)subClusterInfos);
        Assert.assertEquals((long)0L, (long)subClusterInfos.size());
        SubClusterHeartbeatRequest heartbeatRequest = SubClusterHeartbeatRequest.newInstance((SubClusterId)subClusterId1, (SubClusterState)SubClusterState.SC_RUNNING, (String)"capability");
        SubClusterHeartbeatResponse heartbeatResponse = stateStoreService.subClusterHeartbeat(heartbeatRequest);
        Assert.assertNotNull((Object)heartbeatResponse);
        GetSubClustersInfoRequest subClustersInfoRequest1 = GetSubClustersInfoRequest.newInstance((boolean)true);
        GetSubClustersInfoResponse subClustersInfoResp1 = stateStoreService.getSubClusters(subClustersInfoRequest1);
        Assert.assertNotNull((Object)subClustersInfoResp1);
        List subClusterInfos1 = subClustersInfoResp1.getSubClusters();
        Assert.assertNotNull((Object)subClusterInfos1);
        Assert.assertEquals((long)1L, (long)subClusterInfos1.size());
    }

    private SubClusterInfo createSubClusterInfo(SubClusterId clusterId) {
        String amRMAddress = "1.2.3.4:1";
        String clientRMAddress = "1.2.3.4:2";
        String rmAdminAddress = "1.2.3.4:3";
        String webAppAddress = "1.2.3.4:4";
        return SubClusterInfo.newInstance((SubClusterId)clusterId, (String)amRMAddress, (String)clientRMAddress, (String)rmAdminAddress, (String)webAppAddress, (SubClusterState)SubClusterState.SC_NEW, (long)Time.now(), (String)"capability");
    }
}

