/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationResponse;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.ClientRMService;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmissionData;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractYarnScheduler;
import org.apache.hadoop.yarn.util.Records;

public class MockRMAppSubmitter {
    public static RMApp submitWithMemory(long memory, MockRM mockRM) throws Exception {
        Resource resource = (Resource)Records.newRecord(Resource.class);
        resource.setMemorySize(memory);
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithResource(resource, mockRM).build();
        return MockRMAppSubmitter.submit(mockRM, data);
    }

    public static RMApp submit(MockRM mockRM, MockRMAppSubmissionData data) throws Exception {
        List<ResourceRequest> amResourceRequests;
        ApplicationId appId = data.isAppIdProvided() ? data.getApplicationId() : null;
        ClientRMService client = mockRM.getClientRMService();
        if (!data.isAppIdProvided()) {
            GetNewApplicationResponse resp = client.getNewApplication((GetNewApplicationRequest)Records.newRecord(GetNewApplicationRequest.class));
            appId = resp.getApplicationId();
        }
        SubmitApplicationRequest req = (SubmitApplicationRequest)Records.newRecord(SubmitApplicationRequest.class);
        ApplicationSubmissionContext sub = (ApplicationSubmissionContext)Records.newRecord(ApplicationSubmissionContext.class);
        sub.setKeepContainersAcrossApplicationAttempts(data.isKeepContainers());
        sub.setApplicationId(appId);
        sub.setApplicationName(data.getName());
        sub.setMaxAppAttempts(data.getMaxAppAttempts());
        if (data.getApplicationTags() != null) {
            sub.setApplicationTags(data.getApplicationTags());
        }
        if (data.getApplicationTimeouts() != null && data.getApplicationTimeouts().size() > 0) {
            sub.setApplicationTimeouts(data.getApplicationTimeouts());
        }
        if (data.isUnmanaged()) {
            sub.setUnmanagedAM(true);
        }
        if (data.getQueue() != null) {
            sub.setQueue(data.getQueue());
        }
        if (data.getPriority() != null) {
            sub.setPriority(data.getPriority());
        }
        if (data.getAppNodeLabel() != null) {
            sub.setNodeLabelExpression(data.getAppNodeLabel());
        }
        sub.setApplicationType(data.getAppType());
        ContainerLaunchContext clc = (ContainerLaunchContext)Records.newRecord(ContainerLaunchContext.class);
        clc.setApplicationACLs(data.getAcls());
        if (data.getCredentials() != null && UserGroupInformation.isSecurityEnabled()) {
            DataOutputBuffer dob = new DataOutputBuffer();
            data.getCredentials().writeTokenStorageToStream((DataOutputStream)dob);
            ByteBuffer securityTokens = ByteBuffer.wrap(dob.getData(), 0, dob.getLength());
            clc.setTokens(securityTokens);
            clc.setTokensConf(data.getTokensConf());
        }
        sub.setAMContainerSpec(clc);
        sub.setAttemptFailuresValidityInterval(data.getAttemptFailuresValidityInterval());
        if (data.getLogAggregationContext() != null) {
            sub.setLogAggregationContext(data.getLogAggregationContext());
        }
        sub.setCancelTokensWhenComplete(data.isCancelTokensWhenComplete());
        Priority priority2 = data.getPriority();
        if (priority2 == null) {
            priority2 = Priority.newInstance((int)0);
        }
        if ((amResourceRequests = data.getAmResourceRequests()) == null || amResourceRequests.isEmpty()) {
            ResourceRequest amResReq = ResourceRequest.newInstance((Priority)priority2, (String)"*", (Resource)data.getResource(), (int)1);
            amResourceRequests = Collections.singletonList(amResReq);
        }
        if (data.getAmLabel() != null && !data.getAmLabel().isEmpty()) {
            for (ResourceRequest amResourceRequest : amResourceRequests) {
                amResourceRequest.setNodeLabelExpression(data.getAmLabel().trim());
            }
        }
        sub.setAMContainerResourceRequests(amResourceRequests);
        req.setApplicationSubmissionContext(sub);
        UserGroupInformation fakeUser = UserGroupInformation.createUserForTesting((String)data.getUser(), (String[])new String[]{"someGroup"});
        PrivilegedExceptionAction<SubmitApplicationResponse> action = new SubmitApplicationResponsePrivilegedExceptionAction().setClientReq((ApplicationClientProtocol)client, req);
        fakeUser.doAs(action);
        if (data.isWaitForAccepted()) {
            mockRM.waitForState(appId, RMAppState.ACCEPTED);
        }
        RMApp rmApp = (RMApp)mockRM.getRMContext().getRMApps().get(appId);
        if (data.isWaitForAccepted() && !data.isUnmanaged()) {
            mockRM.waitForState(rmApp.getCurrentAppAttempt().getAppAttemptId(), RMAppAttemptState.SCHEDULED);
        }
        ((AbstractYarnScheduler)mockRM.getResourceScheduler()).update();
        return rmApp;
    }

    private static class SubmitApplicationResponsePrivilegedExceptionAction
    implements PrivilegedExceptionAction<SubmitApplicationResponse> {
        ApplicationClientProtocol client;
        SubmitApplicationRequest req;

        private SubmitApplicationResponsePrivilegedExceptionAction() {
        }

        @Override
        public SubmitApplicationResponse run() throws IOException, YarnException {
            try {
                return this.client.submitApplication(this.req);
            }
            catch (IOException | YarnException e) {
                e.printStackTrace();
                throw e;
            }
        }

        PrivilegedExceptionAction<SubmitApplicationResponse> setClientReq(ApplicationClientProtocol client, SubmitApplicationRequest req) {
            this.client = client;
            this.req = req;
            return this;
        }
    }
}

