/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbsoluteResourceCapacityCalculator;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractQueueCapacityCalculator;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CalculationContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueCapacityVector;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ResourceCalculationDriver;

public class RootQueueCapacityCalculator
extends AbstractQueueCapacityCalculator {
    @Override
    public void calculateResourcePrerequisites(ResourceCalculationDriver resourceCalculationDriver) {
        AbsoluteResourceCapacityCalculator.setNormalizedResourceRatio(resourceCalculationDriver);
    }

    @Override
    public double calculateMinimumResource(ResourceCalculationDriver resourceCalculationDriver, CalculationContext context, String label) {
        return resourceCalculationDriver.getUpdateContext().getUpdatedClusterResource(label).getResourceValue(context.getResourceName());
    }

    @Override
    public double calculateMaximumResource(ResourceCalculationDriver resourceCalculationDriver, CalculationContext context, String label) {
        return resourceCalculationDriver.getUpdateContext().getUpdatedClusterResource(label).getResourceValue(context.getResourceName());
    }

    @Override
    public void updateCapacitiesAfterCalculation(ResourceCalculationDriver resourceCalculationDriver, CSQueue queue, String label) {
        queue.getQueueCapacities().setAbsoluteCapacity(label, 1.0f);
        if (queue.getQueueCapacities().getWeight(label) == 1.0f) {
            queue.getQueueCapacities().setNormalizedWeight(label, 1.0f);
        }
    }

    @Override
    public QueueCapacityVector.ResourceUnitCapacityType getCapacityType() {
        return QueueCapacityVector.ResourceUnitCapacityType.PERCENTAGE;
    }
}

