/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.security;

import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.security.ProxyCAManager;
import org.apache.hadoop.yarn.server.webproxy.ProxyCA;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestProxyCAManager {
    @Test
    public void testBasics() throws Exception {
        ProxyCA proxyCA = (ProxyCA)Mockito.spy((Object)new ProxyCA());
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        RMStateStore rmStateStore = (RMStateStore)Mockito.mock(RMStateStore.class);
        Mockito.when((Object)rmContext.getStateStore()).thenReturn((Object)rmStateStore);
        ProxyCAManager proxyCAManager = new ProxyCAManager(proxyCA, rmContext);
        proxyCAManager.init((Configuration)new YarnConfiguration());
        Assert.assertEquals((Object)proxyCA, (Object)proxyCAManager.getProxyCA());
        ((RMContext)Mockito.verify((Object)rmContext, (VerificationMode)Mockito.times((int)0))).getStateStore();
        ((RMStateStore)Mockito.verify((Object)rmStateStore, (VerificationMode)Mockito.times((int)0))).storeProxyCACert((X509Certificate)ArgumentMatchers.any(), (PrivateKey)ArgumentMatchers.any());
        ((ProxyCA)Mockito.verify((Object)proxyCA, (VerificationMode)Mockito.times((int)0))).init();
        Assert.assertNull((Object)proxyCA.getCaCert());
        Assert.assertNull((Object)proxyCA.getCaKeyPair());
        proxyCAManager.start();
        ((RMContext)Mockito.verify((Object)rmContext, (VerificationMode)Mockito.times((int)1))).getStateStore();
        ((RMStateStore)Mockito.verify((Object)rmStateStore, (VerificationMode)Mockito.times((int)1))).storeProxyCACert(proxyCA.getCaCert(), proxyCA.getCaKeyPair().getPrivate());
        ((ProxyCA)Mockito.verify((Object)proxyCA, (VerificationMode)Mockito.times((int)1))).init();
        Assert.assertNotNull((Object)proxyCA.getCaCert());
        Assert.assertNotNull((Object)proxyCA.getCaKeyPair());
    }

    @Test
    public void testRecover() throws Exception {
        ProxyCA proxyCA = (ProxyCA)Mockito.spy((Object)new ProxyCA());
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        RMStateStore rmStateStore = (RMStateStore)Mockito.mock(RMStateStore.class);
        Mockito.when((Object)rmContext.getStateStore()).thenReturn((Object)rmStateStore);
        ProxyCAManager proxyCAManager = new ProxyCAManager(proxyCA, rmContext);
        proxyCAManager.init((Configuration)new YarnConfiguration());
        Assert.assertEquals((Object)proxyCA, (Object)proxyCAManager.getProxyCA());
        ((RMContext)Mockito.verify((Object)rmContext, (VerificationMode)Mockito.times((int)0))).getStateStore();
        ((RMStateStore)Mockito.verify((Object)rmStateStore, (VerificationMode)Mockito.times((int)0))).storeProxyCACert((X509Certificate)ArgumentMatchers.any(), (PrivateKey)ArgumentMatchers.any());
        ((ProxyCA)Mockito.verify((Object)proxyCA, (VerificationMode)Mockito.times((int)0))).init();
        Assert.assertNull((Object)proxyCA.getCaCert());
        Assert.assertNull((Object)proxyCA.getCaKeyPair());
        RMStateStore.RMState rmState = (RMStateStore.RMState)Mockito.mock(RMStateStore.RMState.class);
        RMStateStore.ProxyCAState proxyCAState = (RMStateStore.ProxyCAState)Mockito.mock(RMStateStore.ProxyCAState.class);
        ProxyCA otherProxyCA = new ProxyCA();
        otherProxyCA.init();
        X509Certificate certificate = otherProxyCA.getCaCert();
        Mockito.when((Object)proxyCAState.getCaCert()).thenReturn((Object)certificate);
        PrivateKey privateKey = otherProxyCA.getCaKeyPair().getPrivate();
        Mockito.when((Object)proxyCAState.getCaPrivateKey()).thenReturn((Object)privateKey);
        Mockito.when((Object)rmState.getProxyCAState()).thenReturn((Object)proxyCAState);
        proxyCAManager.recover(rmState);
        ((ProxyCA)Mockito.verify((Object)proxyCA, (VerificationMode)Mockito.times((int)1))).init(certificate, privateKey);
        Assert.assertEquals((Object)certificate, (Object)proxyCA.getCaCert());
        Assert.assertEquals((Object)privateKey, (Object)proxyCA.getCaKeyPair().getPrivate());
        proxyCAManager.start();
        ((RMContext)Mockito.verify((Object)rmContext, (VerificationMode)Mockito.times((int)1))).getStateStore();
        ((RMStateStore)Mockito.verify((Object)rmStateStore, (VerificationMode)Mockito.times((int)1))).storeProxyCACert(proxyCA.getCaCert(), proxyCA.getCaKeyPair().getPrivate());
        ((ProxyCA)Mockito.verify((Object)proxyCA, (VerificationMode)Mockito.times((int)0))).init();
        Assert.assertEquals((Object)certificate, (Object)proxyCA.getCaCert());
        Assert.assertEquals((Object)privateKey, (Object)proxyCA.getCaKeyPair().getPrivate());
    }
}

