/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.FSYarnSiteConverter;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.DominantResourceCalculator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestFSYarnSiteConverter {
    private Configuration yarnConfig;
    private FSYarnSiteConverter converter;
    private Configuration yarnConvertedConfig;

    @Before
    public void setup() {
        this.yarnConfig = new Configuration(false);
        this.yarnConvertedConfig = new Configuration(false);
        this.converter = new FSYarnSiteConverter();
    }

    @Test
    public void testSiteContinuousSchedulingConversion() {
        this.yarnConfig.setBoolean("yarn.scheduler.fair.continuous-scheduling-enabled", true);
        this.yarnConfig.setInt("yarn.scheduler.fair.continuous-scheduling-sleep-ms", 666);
        this.converter.convertSiteProperties(this.yarnConfig, this.yarnConvertedConfig, false, false);
        Assert.assertTrue((String)"Cont. scheduling", (boolean)this.yarnConvertedConfig.getBoolean("yarn.scheduler.capacity.schedule-asynchronously.enable", false));
        Assert.assertEquals((String)"Scheduling interval", (long)666L, (long)this.yarnConvertedConfig.getInt("yarn.scheduler.capacity.schedule-asynchronously.scheduling-interval-ms", -1));
    }

    @Test
    public void testSiteMinimumAllocationIncrementConversion() {
        this.yarnConfig.setInt("yarn.resource-types.memory-mb.increment-allocation", 11);
        this.yarnConfig.setInt("yarn.resource-types.vcores.increment-allocation", 5);
        this.converter.convertSiteProperties(this.yarnConfig, this.yarnConvertedConfig, false, false);
        Assert.assertEquals((String)"Memory alloc increment", (long)11L, (long)this.yarnConvertedConfig.getInt("yarn.scheduler.minimum-allocation-mb", -1));
        Assert.assertEquals((String)"Vcore increment", (long)5L, (long)this.yarnConvertedConfig.getInt("yarn.scheduler.minimum-allocation-vcores", -1));
    }

    @Test
    public void testSitePreemptionConversion() {
        this.yarnConfig.setBoolean("yarn.scheduler.fair.preemption", true);
        this.yarnConfig.setInt("yarn.scheduler.fair.waitTimeBeforeKill", 123);
        this.yarnConfig.setInt("yarn.scheduler.fair.waitTimeBeforeNextStarvationCheck", 321);
        this.converter.convertSiteProperties(this.yarnConfig, this.yarnConvertedConfig, false, false);
        Assert.assertTrue((String)"Preemption enabled", (boolean)this.yarnConvertedConfig.getBoolean("yarn.resourcemanager.scheduler.monitor.enable", false));
        Assert.assertEquals((String)"Wait time before kill", (long)123L, (long)this.yarnConvertedConfig.getInt("yarn.resourcemanager.monitor.capacity.preemption.max_wait_before_kill", -1));
        Assert.assertEquals((String)"Starvation check wait time", (long)321L, (long)this.yarnConvertedConfig.getInt("yarn.resourcemanager.monitor.capacity.preemption.monitoring_interval", -1));
    }

    @Test
    public void testSiteAssignMultipleConversion() {
        this.yarnConfig.setBoolean("yarn.scheduler.fair.assignmultiple", true);
        this.converter.convertSiteProperties(this.yarnConfig, this.yarnConvertedConfig, false, false);
        Assert.assertTrue((String)"Assign multiple", (boolean)this.yarnConvertedConfig.getBoolean("yarn.scheduler.capacity.per-node-heartbeat.multiple-assignments-enabled", false));
    }

    @Test
    public void testSiteMaxAssignConversion() {
        this.yarnConfig.setInt("yarn.scheduler.fair.max.assign", 111);
        this.converter.convertSiteProperties(this.yarnConfig, this.yarnConvertedConfig, false, false);
        Assert.assertEquals((String)"Max assign", (long)111L, (long)this.yarnConvertedConfig.getInt("yarn.scheduler.capacity.per-node-heartbeat.maximum-container-assignments", -1));
    }

    @Test
    public void testSiteLocalityThresholdConversion() {
        this.yarnConfig.set("yarn.scheduler.fair.locality.threshold.node", "123.123");
        this.yarnConfig.set("yarn.scheduler.fair.locality.threshold.rack", "321.321");
        this.converter.convertSiteProperties(this.yarnConfig, this.yarnConvertedConfig, false, false);
        Assert.assertEquals((String)"Locality threshold node", (Object)"123.123", (Object)this.yarnConvertedConfig.get("yarn.scheduler.capacity.node-locality-delay"));
        Assert.assertEquals((String)"Locality threshold rack", (Object)"321.321", (Object)this.yarnConvertedConfig.get("yarn.scheduler.capacity.rack-locality-additional-delay"));
    }

    @Test
    public void testSiteDrfEnabledConversion() {
        this.converter.convertSiteProperties(this.yarnConfig, this.yarnConvertedConfig, true, false);
        Assert.assertEquals((String)"Resource calculator type", DominantResourceCalculator.class, (Object)this.yarnConvertedConfig.getClass("yarn.scheduler.capacity.resource-calculator", null));
    }

    @Test
    public void testSiteDrfDisabledConversion() {
        this.converter.convertSiteProperties(this.yarnConfig, this.yarnConvertedConfig, false, false);
        Assert.assertEquals((String)"Resource calculator type", DefaultResourceCalculator.class, (Object)this.yarnConvertedConfig.getClass("yarn.scheduler.capacity.resource-calculator", CapacitySchedulerConfiguration.DEFAULT_RESOURCE_CALCULATOR_CLASS));
    }

    @Test
    public void testAsyncSchedulingEnabledConversion() {
        this.converter.convertSiteProperties(this.yarnConfig, this.yarnConvertedConfig, true, true);
        Assert.assertTrue((String)"Asynchronous scheduling", (boolean)this.yarnConvertedConfig.getBoolean("yarn.scheduler.capacity.schedule-asynchronously.enable", false));
    }

    @Test
    public void testAsyncSchedulingDisabledConversion() {
        this.converter.convertSiteProperties(this.yarnConfig, this.yarnConvertedConfig, false, false);
        Assert.assertFalse((String)"Asynchronous scheduling", (boolean)this.yarnConvertedConfig.getBoolean("yarn.scheduler.capacity.schedule-asynchronously.enable", false));
    }
}

